/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.tools.assimp;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMaterial;
import com.badlogic.gdx.graphics.g3d.model.data.ModelTexture;
import com.badlogic.gdx.utils.Array;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import org.lwjgl.assimp.AIMaterial;
import org.lwjgl.assimp.AIMaterialProperty;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.Assimp;
import org.lwjgl.system.MemoryUtil;
import us.ihmc.log.LogTools;
import us.ihmc.tools.io.resources.ResourceTools;

public class RDXAssimpMaterialLoader {
    private final AIMaterial assimpMaterial;
    private final String basePath;
    private ModelMaterial modelMaterial;

    public RDXAssimpMaterialLoader(AIMaterial assimpMaterial, String basePath) {
        this.assimpMaterial = assimpMaterial;
        this.basePath = basePath;
    }

    public ModelMaterial load() {
        this.modelMaterial = new ModelMaterial();
        int numberAllocated = this.assimpMaterial.mNumAllocated();
        LogTools.debug((String)"Number allocated: {}", (Object)numberAllocated);
        int numberOfMaterialProperties = this.assimpMaterial.mNumProperties();
        LogTools.debug((String)"Number of material properties: {}", (Object)numberOfMaterialProperties);
        this.loadTextureInformation();
        for (int j = 0; j < numberOfMaterialProperties; ++j) {
            AIMaterialProperty assimpMaterialProperty = new AIMaterialProperty(MemoryUtil.memByteBuffer((long)this.assimpMaterial.mProperties().get(j), (int)AIMaterialProperty.SIZEOF));
            String materialPropertyKey = assimpMaterialProperty.mKey().dataString();
            int valueType = assimpMaterialProperty.mType();
            if (materialPropertyKey.equals("?mat.name")) {
                this.modelMaterial.id = MemoryUtil.memUTF8((ByteBuffer)assimpMaterialProperty.mData()).trim();
            } else if (materialPropertyKey.equals("$clr.diffuse")) {
                this.modelMaterial.diffuse = this.loadColor(assimpMaterialProperty);
                float desiredMax = 0.588235f;
                float max = Math.max(Math.max(this.modelMaterial.diffuse.r, this.modelMaterial.diffuse.g), this.modelMaterial.diffuse.b);
                float ratio = desiredMax / max;
                this.modelMaterial.diffuse.r = ratio * this.modelMaterial.diffuse.r;
                this.modelMaterial.diffuse.g = ratio * this.modelMaterial.diffuse.g;
                this.modelMaterial.diffuse.b = ratio * this.modelMaterial.diffuse.b;
                this.modelMaterial.diffuse.a = 1.0f;
            } else if (materialPropertyKey.equals("$clr.ambient")) {
                this.modelMaterial.ambient = this.loadColor(assimpMaterialProperty);
                this.modelMaterial.ambient.r = 0.050876f;
                this.modelMaterial.ambient.g = 0.050876f;
                this.modelMaterial.ambient.b = 0.050876f;
                this.modelMaterial.ambient.a = 1.0f;
            } else if (materialPropertyKey.equals("$clr.emissive")) {
                this.modelMaterial.emissive = this.loadColor(assimpMaterialProperty);
                this.modelMaterial.emissive.r = 0.0f;
                this.modelMaterial.emissive.g = 0.0f;
                this.modelMaterial.emissive.b = 0.0f;
                this.modelMaterial.emissive.a = 1.0f;
            } else if (materialPropertyKey.equals("$clr.specular")) {
                this.modelMaterial.specular = this.loadColor(assimpMaterialProperty);
                this.modelMaterial.specular.r = 0.8f;
                this.modelMaterial.specular.g = 0.8f;
                this.modelMaterial.specular.b = 0.8f;
                this.modelMaterial.specular.a = 1.0f;
            } else if (materialPropertyKey.equals("$clr.reflective")) {
                this.modelMaterial.reflection = this.loadColor(assimpMaterialProperty);
            } else if (materialPropertyKey.equals("$mat.shininess")) {
                this.modelMaterial.shininess = assimpMaterialProperty.mData().getFloat();
                this.modelMaterial.shininess = 1.111111f;
            } else if (materialPropertyKey.equals("$mat.opacity")) {
                this.modelMaterial.opacity = assimpMaterialProperty.mData().getFloat();
            } else if (!materialPropertyKey.equals("$tex.file") && materialPropertyKey.equals("$tex.uvwsrc")) {
                ModelTexture modelTexture = (ModelTexture)this.modelMaterial.textures.get(this.modelMaterial.textures.size - 1);
                int max = assimpMaterialProperty.mData().getInt();
            }
            Object valueAsString = "";
            if (valueType == 1) {
                int dataLength = assimpMaterialProperty.mDataLength() / 4;
                for (int i = 0; i < dataLength; ++i) {
                    float floatValue = assimpMaterialProperty.mData().getFloat(i);
                    valueAsString = (String)valueAsString + floatValue + " ";
                }
            } else if (valueType == 2) {
                int dataLength = assimpMaterialProperty.mDataLength() / 8;
                for (int i = 0; i < dataLength; ++i) {
                    double doubleValue = assimpMaterialProperty.mData().getDouble(i);
                    valueAsString = (String)valueAsString + doubleValue + " ";
                }
            } else if (valueType == 3) {
                String stringFromMemUTF8 = MemoryUtil.memUTF8((ByteBuffer)assimpMaterialProperty.mData()).trim();
                valueAsString = stringFromMemUTF8;
            } else if (valueType == 4) {
                int dataLength = assimpMaterialProperty.mDataLength() / 4;
                for (int i = 0; i < dataLength; ++i) {
                    int intValue = assimpMaterialProperty.mData().getInt(i);
                    valueAsString = (String)valueAsString + intValue + " ";
                }
            } else if (valueType == 5) {
                valueAsString = (String)valueAsString + " buffer of length " + assimpMaterialProperty.mDataLength();
            }
            LogTools.debug((String)"Property: {}: {}", (Object)materialPropertyKey, (Object)valueAsString);
        }
        return this.modelMaterial;
    }

    private void loadTextureInformation() {
        this.loadTextureInformation(0);
        this.loadTextureInformation(1);
        this.loadTextureInformation(2);
        this.loadTextureInformation(3);
        this.loadTextureInformation(4);
        this.loadTextureInformation(5);
        this.loadTextureInformation(6);
        this.loadTextureInformation(7);
        this.loadTextureInformation(8);
        this.loadTextureInformation(9);
        this.loadTextureInformation(10);
        this.loadTextureInformation(11);
        this.loadTextureInformation(18);
    }

    private void loadTextureInformation(int textureType) {
        int numberOfMaterialTexturesOfType = Assimp.aiGetMaterialTextureCount((AIMaterial)this.assimpMaterial, (int)textureType);
        if (numberOfMaterialTexturesOfType > 0) {
            LogTools.debug((String)"Number of {} textures: {}", (Object)this.getTextureTypeString(textureType), (Object)numberOfMaterialTexturesOfType);
            if (this.modelMaterial.textures == null) {
                this.modelMaterial.textures = new Array();
            }
            for (int i = 0; i < numberOfMaterialTexturesOfType; ++i) {
                AIString path = AIString.create();
                int[] mapping = new int[1];
                int[] uvSourceChannelIndex = new int[1];
                float[] blendFactor = new float[1];
                int[] blendWithPreviousTextureOperation = new int[1];
                int[] mapmode = null;
                int[] flags = new int[1];
                Assimp.aiGetMaterialTexture((AIMaterial)this.assimpMaterial, (int)textureType, (int)i, (AIString)path, (int[])mapping, (int[])uvSourceChannelIndex, (float[])blendFactor, (int[])blendWithPreviousTextureOperation, mapmode, (int[])flags);
                String textureFilePath = ResourceTools.sanitizeResourcePath((String)Paths.get(this.basePath, new String[0]).resolve(path.dataString()).toString());
                LogTools.debug((String)"Path: {}", (Object)textureFilePath);
                LogTools.debug((String)"Mapping: {}", (Object)mapping[0]);
                LogTools.debug((String)"UV source channel index: {}", (Object)uvSourceChannelIndex[0]);
                LogTools.debug((String)"Blend factor: {}", (Object)Float.valueOf(blendFactor[0]));
                LogTools.debug((String)"Blend with previous texture operation: {}", (Object)blendWithPreviousTextureOperation[0]);
                LogTools.debug((String)"Flags: {}", (Object)flags[0]);
                ModelTexture modelTexture = new ModelTexture();
                modelTexture.fileName = textureFilePath;
                modelTexture.id = "texture" + this.modelMaterial.textures.size;
                modelTexture.usage = this.getModelTextureTypeCode(textureType);
                this.modelMaterial.textures.add((Object)modelTexture);
            }
        }
    }

    private String getTextureTypeString(int textureType) {
        switch (textureType) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Diffuse";
            }
            case 2: {
                return "Specular";
            }
            case 3: {
                return "Ambient";
            }
            case 4: {
                return "Emissive";
            }
            case 5: {
                return "Height";
            }
            case 6: {
                return "Normals";
            }
            case 7: {
                return "Shininess";
            }
            case 8: {
                return "Opacity";
            }
            case 9: {
                return "Displacement";
            }
            case 10: {
                return "Lightmap";
            }
            case 11: {
                return "Reflection";
            }
            case 18: {
                return "Unknown";
            }
        }
        return "NotAType";
    }

    private int getModelTextureTypeCode(int textureType) {
        switch (textureType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 9;
            }
            case 9: {
                return -1;
            }
            case 10: {
                return -1;
            }
            case 11: {
                return 10;
            }
            case 18: {
                return 0;
            }
        }
        return -1;
    }

    private Color loadColor(AIMaterialProperty assimpMaterialProperty) {
        int materialPropertyDataLength;
        int valueType = assimpMaterialProperty.mType();
        if (valueType != 1) {
            LogTools.error((String)"Implement other types!");
        }
        boolean isThreeFloats = (materialPropertyDataLength = assimpMaterialProperty.mDataLength()) == 12;
        boolean isFourFloats = materialPropertyDataLength == 16;
        Color color = new Color(0.5f, 0.5f, 0.5f, 1.0f);
        if (isThreeFloats || isFourFloats) {
            color.r = assimpMaterialProperty.mData().getFloat();
            color.g = assimpMaterialProperty.mData().getFloat(4);
            color.b = assimpMaterialProperty.mData().getFloat(8);
            color.a = isFourFloats ? assimpMaterialProperty.mData().getFloat(12) : 1.0f;
        } else {
            LogTools.error((String)"What to do with {} float(s)?", (Object)(materialPropertyDataLength / 4));
        }
        return color;
    }

    public AIMaterial getAssimpMaterial() {
        return this.assimpMaterial;
    }

    public ModelMaterial getModelMaterial() {
        return this.modelMaterial;
    }
}

