/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.lighting;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import java.util.function.Consumer;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.lighting.RDXPointLight;
import us.ihmc.rdx.lighting.RDXShadowManager;

public class RDXShadowMapShader
extends BaseShader {
    private Renderable renderable;
    private final RDXShadowManager shadowManager;

    protected RDXShadowMapShader(Renderable renderable, RDXShadowManager shadowManager) {
        this.renderable = renderable;
        this.shadowManager = shadowManager;
        this.register(DefaultShader.Inputs.worldTrans, DefaultShader.Setters.worldTrans);
        this.register(DefaultShader.Inputs.projViewTrans, DefaultShader.Setters.projViewTrans);
        this.register(DefaultShader.Inputs.normalMatrix, DefaultShader.Setters.normalMatrix);
        ShaderProgram.pedantic = false;
        String directory = "us/ihmc/rdx/shadows";
        String prefix = "shadows";
        this.program = new ShaderProgram(Gdx.files.classpath("us/ihmc/rdx/shadows/shadows_v.glsl"), Gdx.files.classpath("us/ihmc/rdx/shadows/shadows_f.glsl"));
        if (!this.program.isCompiled()) {
            LogTools.fatal((String)("Error with shader shadows: " + this.program.getLog()));
            System.exit(1);
        } else {
            LogTools.info((String)"Shader shadows compiled");
        }
    }

    public void init() {
        ShaderProgram program = this.program;
        this.program = null;
        super.init(program, this.renderable);
        this.renderable = null;
    }

    public boolean canRender(Renderable instance) {
        return true;
    }

    public int compareTo(Shader other) {
        if (other == null) {
            return -1;
        }
        if (other == this) {
            return 0;
        }
        return 0;
    }

    public void begin(Camera camera, RenderContext context) {
        super.begin(camera, context);
        context.setDepthTest(515);
        context.setCullFace(1029);
    }

    public void render(Renderable renderable, Attributes combinedAttributes) {
        if (!combinedAttributes.has(BlendingAttribute.Type)) {
            this.context.setBlending(false, 770, 771);
        }
        this.context.setDepthTest(515);
        this.context.setBlending(false, 1, 1);
        super.render(renderable, combinedAttributes);
        for (RDXPointLight light : this.shadowManager.getPointLights()) {
            this.context.setDepthTest(515);
            this.context.setBlending(true, 1, 1);
            this.renderLight(renderable, combinedAttributes, light::apply);
        }
    }

    private void renderLight(Renderable renderable, Attributes combinedAttributes, Consumer<ShaderProgram> light) {
        light.accept(this.program);
        this.context.setBlending(true, 1, 1);
        renderable.meshPart.render(this.program);
    }
}

