/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.lighting;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.utils.DefaultShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.ShaderProvider;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import java.util.ArrayList;
import org.lwjgl.opengl.GL41;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.lighting.RDXDirectionalLight;
import us.ihmc.rdx.lighting.RDXPointLight;
import us.ihmc.rdx.lighting.RDXShadowMapShader;
import us.ihmc.rdx.lighting.RDXShadowSceneShader;

public class RDXShadowManager {
    private final float antiAliasing;
    private boolean useViewport = false;
    private int x = 0;
    private int y = 0;
    private int width = 0;
    private int height = 0;
    private FrameBuffer framebuffer;
    private final ArrayList<RDXPointLight> additionalOffscreenLights = new ArrayList();
    private final ArrayList<RDXPointLight> pointLights = new ArrayList();
    private final ArrayList<RDXDirectionalLight> directionalLights = new ArrayList();
    private final ShaderProgram shadowSceneShaderProgram;
    private final ModelBatch shadowMapBatch;
    private final ModelBatch shadowSceneBatch;
    private float ambientLight;

    public RDXShadowManager(float antiAliasing, float ambientLight) {
        this.antiAliasing = antiAliasing;
        this.ambientLight = ambientLight;
        String vertexShader = Gdx.files.classpath("us/ihmc/rdx/shadows/scene_v.glsl").readString();
        String fragmentShader = Gdx.files.classpath("us/ihmc/rdx/shadows/scene_f.glsl").readString();
        this.shadowSceneShaderProgram = new ShaderProgram(vertexShader, fragmentShader);
        this.shadowSceneBatch = new ModelBatch((ShaderProvider)new DefaultShaderProvider(){

            protected Shader createShader(Renderable renderable) {
                return new RDXShadowSceneShader(renderable, RDXShadowManager.this.shadowSceneShaderProgram);
            }
        });
        this.shadowMapBatch = new ModelBatch((ShaderProvider)new DefaultShaderProvider(){

            protected Shader createShader(Renderable renderable) {
                return new RDXShadowMapShader(renderable, RDXShadowManager.this);
            }
        });
        RDXPointLight lightOne = new RDXPointLight();
        lightOne.getPosition().set(0.0, 0.0, -500.0);
        this.additionalOffscreenLights.add(lightOne);
        RDXPointLight lightTwo = new RDXPointLight();
        lightTwo.getPosition().set(1.0, 0.0, -500.0);
        this.additionalOffscreenLights.add(lightTwo);
        RDXPointLight lightThree = new RDXPointLight();
        lightThree.getPosition().set(2.0, 0.0, -500.0);
        this.additionalOffscreenLights.add(lightThree);
    }

    public <T extends RenderableProvider> void renderShadows(Camera camera, Iterable<T> renderableProviders) {
        this.renderShadows(camera, renderableProviders, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public <T extends RenderableProvider> void renderShadows(Camera camera, Iterable<T> renderableProviders, int width, int height) {
        for (RDXPointLight additionalOffscreenLight : this.additionalOffscreenLights) {
            additionalOffscreenLight.render(renderableProviders);
        }
        for (RDXPointLight pointLight : this.pointLights) {
            pointLight.render(renderableProviders);
        }
        for (RDXDirectionalLight directionalLight : this.directionalLights) {
            directionalLight.render(renderableProviders);
        }
        if ((this.framebuffer == null || width != this.framebuffer.getWidth() || height != this.framebuffer.getHeight()) && width > 0 && height > 0) {
            if (this.framebuffer != null) {
                this.framebuffer.dispose();
            }
            LogTools.info((String)("Allocating framebuffer of size: " + width + "x" + height));
            this.framebuffer = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, true);
        }
        this.framebuffer.begin();
        if (this.useViewport) {
            GL41.glViewport((int)this.x, (int)this.y, (int)this.width, (int)this.height);
        }
        GL41.glClearColor((float)0.4f, (float)0.4f, (float)0.4f, (float)0.4f);
        GL41.glClear((int)16640);
        for (RenderableProvider renderable : renderableProviders) {
            this.shadowMapBatch.begin(camera);
            this.shadowMapBatch.render(renderable);
            this.shadowMapBatch.end();
        }
        this.framebuffer.end();
    }

    public void apply(ShaderProgram program) {
        program.begin();
        Texture shadows = (Texture)this.framebuffer.getColorBufferTexture();
        int textureNum = shadows.getTextureObjectHandle();
        shadows.bind(textureNum);
        program.setUniformi("u_shadows", textureNum);
        program.setUniformf("u_screenWidth", (float)Gdx.graphics.getWidth());
        program.setUniformf("u_screenHeight", (float)Gdx.graphics.getHeight());
        program.setUniformf("u_antiAliasing", this.antiAliasing);
        program.setUniformf("u_ambientLight", this.ambientLight);
        program.end();
    }

    public void preRender(Camera camera) {
        this.apply(this.shadowSceneShaderProgram);
        this.shadowSceneBatch.begin(camera);
    }

    public void render(Iterable<? extends RenderableProvider> renderables) {
        this.shadowSceneBatch.render(renderables);
    }

    public void postRender() {
        this.shadowSceneBatch.end();
    }

    public void setViewportBounds(int x, int y, int width, int height) {
        this.useViewport = true;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void dispose() {
        this.shadowSceneBatch.dispose();
    }

    public ArrayList<RDXPointLight> getPointLights() {
        return this.pointLights;
    }

    public ArrayList<RDXDirectionalLight> getDirectionalLights() {
        return this.directionalLights;
    }

    public void setAmbientLight(float ambientLight) {
        this.ambientLight = ambientLight;
    }

    public ModelBatch getShadowSceneBatch() {
        return this.shadowSceneBatch;
    }
}

