/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.lighting;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.utils.DefaultShaderProvider;
import com.badlogic.gdx.graphics.g3d.utils.ShaderProvider;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import org.lwjgl.opengl.GL41;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.rdx.lighting.RDXDepthMapShader;
import us.ihmc.rdx.tools.LibGDXTools;

public class RDXDirectionalLight {
    public static final int DEPTHMAP_SIZE = 4096;
    public static final float CAMERA_NEAR = 0.1f;
    public static final float CAMERA_FAR = 100.0f;
    protected ModelBatch modelBatch;
    private final Camera camera;
    private final Point3D position = new Point3D();
    private final Vector3D direction = new Vector3D();
    private FrameBuffer framebuffer;
    private Texture depthMap;
    private DirectionalLight attribute;

    public RDXDirectionalLight() {
        this.camera = new PerspectiveCamera(150.0f, 4096.0f, 4096.0f);
        this.modelBatch = new ModelBatch((ShaderProvider)new DefaultShaderProvider(){

            protected Shader createShader(Renderable renderable) {
                return new RDXDepthMapShader(renderable);
            }
        });
        this.update();
    }

    public void update() {
        this.camera.near = 0.1f;
        this.camera.far = 100.0f;
        LibGDXTools.toLibGDX((Tuple3DReadOnly)this.position, this.camera.position);
        this.camera.lookAt(this.direction.getX32(), this.direction.getY32(), this.direction.getZ32());
        this.camera.update();
        if (this.attribute != null) {
            LibGDXTools.toLibGDX((Tuple3DReadOnly)this.direction, this.attribute.direction);
        }
    }

    public <T extends RenderableProvider> void render(Iterable<T> renderableProviders) {
        if (this.framebuffer == null) {
            this.framebuffer = new FrameBuffer(Pixmap.Format.RGBA8888, 4096, 4096, true);
        }
        ShaderProgram shaderProgram = RDXDepthMapShader.getOrLoadShaderProgram();
        shaderProgram.begin();
        shaderProgram.setUniformf("u_cameraFar", this.camera.far);
        shaderProgram.setUniformf("u_lightPosition_x", this.getPosition().getX32());
        shaderProgram.setUniformf("u_lightPosition_y", this.getPosition().getY32());
        shaderProgram.setUniformf("u_lightPosition_z", this.getPosition().getZ32());
        shaderProgram.end();
        this.framebuffer.begin();
        GL41.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL41.glClear((int)16640);
        this.modelBatch.begin(this.camera);
        this.modelBatch.render(renderableProviders);
        this.modelBatch.end();
        this.framebuffer.end();
        this.depthMap = (Texture)this.framebuffer.getColorBufferTexture();
    }

    public void apply(ShaderProgram shader) {
        shader.begin();
        int textureNum = this.depthMap.getTextureObjectHandle();
        this.depthMap.bind(textureNum);
        shader.setUniformf("u_type", 1.0f);
        shader.setUniformi("u_depthMapDir", textureNum);
        shader.setUniformMatrix("u_lightTrans", this.camera.combined);
        shader.setUniformf("u_cameraFar", this.camera.far);
        shader.setUniformf("u_lightPosition_x", this.getPosition().getX32());
        shader.setUniformf("u_lightPosition_y", this.getPosition().getY32());
        shader.setUniformf("u_lightPosition_z", this.getPosition().getZ32());
        shader.end();
    }

    public Point3D getPosition() {
        return this.position;
    }

    public Vector3D getDirection() {
        return this.direction;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setAttribute(DirectionalLight attribute) {
        this.attribute = attribute;
    }

    public DirectionalLight getAttribute() {
        return this.attribute;
    }
}

