/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.lighting;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import us.ihmc.log.LogTools;

public class RDXDepthMapShader
extends BaseShader {
    private static ShaderProgram shaderProgram = null;
    private Renderable renderable;

    protected RDXDepthMapShader(Renderable renderable) {
        this.renderable = renderable;
        this.register(DefaultShader.Inputs.worldTrans, DefaultShader.Setters.worldTrans);
        this.register(DefaultShader.Inputs.projViewTrans, DefaultShader.Setters.projViewTrans);
        this.register(DefaultShader.Inputs.normalMatrix, DefaultShader.Setters.normalMatrix);
    }

    public static ShaderProgram getOrLoadShaderProgram() {
        if (shaderProgram == null) {
            ShaderProgram.pedantic = false;
            String directory = "us/ihmc/rdx/shadows";
            String prefix = "depthmap";
            shaderProgram = new ShaderProgram(Gdx.files.classpath(directory + "/" + prefix + "_v.glsl"), Gdx.files.classpath(directory + "/" + prefix + "_f.glsl"));
            if (!shaderProgram.isCompiled()) {
                LogTools.fatal((String)("Error with shader " + prefix + ": " + shaderProgram.getLog()));
                System.exit(1);
            } else {
                LogTools.info((String)("Shader " + prefix + " compiled"));
            }
        }
        return shaderProgram;
    }

    public void init() {
        super.init(RDXDepthMapShader.getOrLoadShaderProgram(), this.renderable);
        this.renderable = null;
    }

    public boolean canRender(Renderable instance) {
        return true;
    }

    public int compareTo(Shader other) {
        return 0;
    }

    public void begin(Camera camera, RenderContext context) {
        super.begin(camera, context);
        context.setDepthTest(515);
        context.setCullFace(1029);
    }

    public void render(Renderable renderable, Attributes combinedAttributes) {
        if (!combinedAttributes.has(BlendingAttribute.Type)) {
            this.context.setBlending(false, 770, 771);
        }
        super.render(renderable, combinedAttributes);
    }
}

