/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.extension.implot.ImPlot;
import us.ihmc.rdx.imgui.ImPlotPlotLineSwapBuffer;
import us.ihmc.rdx.imgui.ImPlotTools;

public class ImPlotPlotLineIntegerSwapBuffer
implements ImPlotPlotLineSwapBuffer {
    private double[] yValuesA;
    private double[] yValuesB;
    private int bufferSize;
    private int value = 0;
    private boolean isA = true;

    @Override
    public void initialize(int bufferSize) {
        this.bufferSize = bufferSize;
        this.yValuesA = ImPlotTools.newZeroFilledBuffer(bufferSize);
        this.yValuesB = ImPlotTools.newZeroFilledBuffer(bufferSize);
    }

    public void addValue(int value) {
        this.value = value;
    }

    @Override
    public void setAValue(int index) {
        this.yValuesA[index] = this.value;
    }

    @Override
    public void setPreviousValue(int index) {
        if (this.isA) {
            this.yValuesA[index] = this.value;
        } else {
            this.yValuesB[index] = this.value;
        }
    }

    @Override
    public void setUpdatedValue(int index) {
        if (this.isA) {
            this.yValuesB[index] = this.value;
        } else {
            this.yValuesA[index] = this.value;
        }
    }

    @Override
    public void copyAToB() {
        System.arraycopy(this.yValuesA, 0, this.yValuesB, 0, this.bufferSize);
    }

    @Override
    public void copyPreviousToUpdated(int srcPos, int destPos, int length) {
        double[] previousValues = this.isA ? this.yValuesA : this.yValuesB;
        double[] updatedValues = this.isA ? this.yValuesB : this.yValuesA;
        System.arraycopy(previousValues, srcPos, updatedValues, 0, length);
        this.isA = !this.isA;
    }

    @Override
    public void plot(String labelID, double[] xValues, int offset) {
        ImPlot.plotLine((String)labelID, (double[])xValues, (double[])(this.isA ? this.yValuesA : this.yValuesB), (int)xValues.length, (int)offset);
    }

    public int getValue(int bufferIndex) {
        return (int)(this.isA ? this.yValuesA[bufferIndex] : this.yValuesB[bufferIndex]);
    }
}

