/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.ImVec2;
import imgui.extension.implot.ImPlot;
import imgui.extension.implot.ImPlotPoint;
import imgui.internal.ImGui;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;
import us.ihmc.rdx.imgui.ImPlotPlotLine;
import us.ihmc.rdx.imgui.ImPlotTools;

public class ImPlotPlot {
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private Consumer<String> dragAndDropPayloadConsumer;
    private Runnable popupContextWindowImGuiRenderer;
    private final ArrayList<ImPlotPlotLine> plotLines = new ArrayList();
    private final String xLabel;
    private final String yLabel;
    private float graphHeight;
    private float graphWidth;
    private int flags;
    private int xFlags;
    private int yFlags;
    private final ImVec2 outerBoundsDimensionsPixels;
    private final ConcurrentLinkedQueue<ImPlotPlotLine> removalQueue = new ConcurrentLinkedQueue();
    private Runnable customBeforePlotLogic = () -> {};
    private Runnable customDuringPlotLogic = () -> {};

    public ImPlotPlot() {
        this(60.0f);
    }

    public ImPlotPlot(float plotHeight) {
        ImPlotTools.ensureImPlotInitialized();
        ImPlotTools.setSCSStyle();
        this.xLabel = "";
        this.yLabel = "";
        this.flags = 0;
        this.flags += 4;
        this.flags += 8;
        ++this.flags;
        this.flags += 16;
        this.xFlags = 0;
        this.xFlags += 15;
        this.xFlags += 512;
        this.yFlags = 0;
        ++this.yFlags;
        this.yFlags += 512;
        this.graphHeight = plotHeight;
        this.graphWidth = 100.0f;
        this.outerBoundsDimensionsPixels = new ImVec2(this.graphWidth, this.graphHeight);
    }

    public void render() {
        this.graphWidth = ImGui.getColumnWidth();
        this.render(this.graphWidth, this.graphHeight);
    }

    public void render(float plotWidth, float plotHeight) {
        while (!this.removalQueue.isEmpty()) {
            this.plotLines.remove(this.removalQueue.poll());
        }
        this.outerBoundsDimensionsPixels.x = plotWidth;
        this.outerBoundsDimensionsPixels.y = plotHeight;
        this.customBeforePlotLogic.run();
        if (ImPlot.beginPlot((String)this.labels.get("Plot"), (String)this.xLabel, (String)this.yLabel, (ImVec2)this.outerBoundsDimensionsPixels, (int)this.flags, (int)this.xFlags, (int)this.yFlags)) {
            String payload;
            this.customDuringPlotLogic.run();
            boolean outside = true;
            ImPlot.setLegendLocation((int)6, (int)0, (boolean)outside);
            boolean showingLegendPopup = false;
            for (ImPlotPlotLine plotLine : this.plotLines) {
                showingLegendPopup |= plotLine.render();
            }
            if (!this.plotLines.isEmpty() && ImPlot.isPlotHovered()) {
                ImPlotPoint plotMousePosition = ImPlot.getPlotMousePos((int)-1);
                int bufferIndex = (int)Math.round(plotMousePosition.getX());
                Object tooltipText = "";
                for (ImPlotPlotLine plotLine : this.plotLines) {
                    tooltipText = (String)tooltipText + plotLine.getVariableName() + ": " + plotLine.getValueString(bufferIndex) + "\n";
                }
                ((String)tooltipText).trim();
                ImGui.setTooltip((String)tooltipText);
                plotMousePosition.destroy();
            }
            if (this.popupContextWindowImGuiRenderer != null && !showingLegendPopup && ImGui.beginPopupContextWindow()) {
                this.popupContextWindowImGuiRenderer.run();
                ImGui.endPopup();
            }
            if (this.dragAndDropPayloadConsumer != null && ImPlot.beginDragDropTarget() && (payload = (String)ImGui.acceptDragDropPayload(String.class)) != null) {
                this.dragAndDropPayloadConsumer.accept(payload);
            }
            ImPlot.endPlot();
        }
    }

    public void setDragAndDropPayloadConsumer(Consumer<String> dragAndDropPayloadConsumer) {
        this.dragAndDropPayloadConsumer = dragAndDropPayloadConsumer;
    }

    public void setPopupContextWindowImGuiRenderer(Runnable popupContextWindowImGuiRenderer) {
        this.popupContextWindowImGuiRenderer = popupContextWindowImGuiRenderer;
    }

    public ArrayList<ImPlotPlotLine> getPlotLines() {
        return this.plotLines;
    }

    public void queueRemovePlotLine(ImPlotPlotLine plotLineToRemove) {
        this.removalQueue.add(plotLineToRemove);
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setXFlags(int xFlags) {
        this.xFlags = xFlags;
    }

    public void setYFlags(int yFlags) {
        this.yFlags = yFlags;
    }

    public void setCustomDuringPlotLogic(Runnable customDuringPlotLogic) {
        this.customDuringPlotLogic = customDuringPlotLogic;
    }

    public void setCustomBeforePlotLogic(Runnable customBeforePlotLogic) {
        this.customBeforePlotLogic = customBeforePlotLogic;
    }
}

