/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import us.ihmc.rdx.imgui.ImGuiTools;

public class ImGuiUniqueLabelMap {
    private static final HashMap<String, AtomicInteger> CLASS_TO_INDEX = new HashMap();
    private final HashMap<String, String> namesToLabels = new HashMap();
    private final HashMap<String, String> hiddenNamesToLabels = new HashMap();
    private final int index;
    private final String classSimpleName;

    public ImGuiUniqueLabelMap(Class<?> clazz) {
        this.classSimpleName = clazz.getSimpleName();
        AtomicInteger classIndex = CLASS_TO_INDEX.get(this.classSimpleName);
        if (classIndex == null) {
            classIndex = new AtomicInteger();
            CLASS_TO_INDEX.put(this.classSimpleName, classIndex);
        }
        this.index = classIndex.getAndIncrement();
    }

    public String get(String visibleLabel) {
        String label = this.namesToLabels.get(visibleLabel);
        if (label == null) {
            label = ImGuiTools.uniqueLabel(this.classSimpleName + this.index, visibleLabel);
            this.namesToLabels.put(visibleLabel, label);
        }
        return label;
    }

    public String getHidden(String hiddenQualifier) {
        Object label = this.hiddenNamesToLabels.get(hiddenQualifier);
        if (label == null) {
            label = "###" + this.classSimpleName + this.index + ":" + hiddenQualifier;
            this.hiddenNamesToLabels.put(hiddenQualifier, (String)label);
        }
        return label;
    }

    public String get(String visibleLabel, String hiddenQualifier) {
        String label = this.namesToLabels.get(visibleLabel + hiddenQualifier);
        if (label == null) {
            label = ImGuiTools.uniqueLabel(this.classSimpleName + this.index + "_" + hiddenQualifier, visibleLabel);
            this.namesToLabels.put(visibleLabel, label);
        }
        return label;
    }

    public String get(String visibleLabel, int moreSpecificIndex) {
        String label = this.namesToLabels.get(visibleLabel + moreSpecificIndex);
        if (label == null) {
            label = ImGuiTools.uniqueLabel(this.classSimpleName + this.index + "_" + moreSpecificIndex, visibleLabel);
            this.namesToLabels.put(visibleLabel + moreSpecificIndex, label);
        }
        return label;
    }

    public String get(String visibleLabel, String hiddenQualifier, int moreSpecificIndex) {
        String label = this.namesToLabels.get(visibleLabel + hiddenQualifier + moreSpecificIndex);
        if (label == null) {
            label = ImGuiTools.uniqueLabel(this.classSimpleName + this.index + "_" + moreSpecificIndex + "_" + hiddenQualifier, visibleLabel);
            this.namesToLabels.put(visibleLabel + moreSpecificIndex, label);
        }
        return label;
    }
}

