/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.ImGui;
import imgui.type.ImFloat;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;

public class ImGuiRigidBodyTransformTuner {
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final RigidBodyTransform transformToTune;
    private final ImFloat x = new ImFloat();
    private final ImFloat y = new ImFloat();
    private final ImFloat z = new ImFloat();
    private final ImFloat yaw = new ImFloat();
    private final ImFloat pitch = new ImFloat();
    private final ImFloat roll = new ImFloat();
    private final ImFloat m00 = new ImFloat();
    private final ImFloat m01 = new ImFloat();
    private final ImFloat m02 = new ImFloat();
    private final ImFloat m10 = new ImFloat();
    private final ImFloat m11 = new ImFloat();
    private final ImFloat m12 = new ImFloat();
    private final ImFloat m20 = new ImFloat();
    private final ImFloat m21 = new ImFloat();
    private final ImFloat m22 = new ImFloat();

    public ImGuiRigidBodyTransformTuner() {
        this(new RigidBodyTransform());
    }

    public ImGuiRigidBodyTransformTuner(RigidBodyTransform transformToTune) {
        this.transformToTune = transformToTune;
    }

    public void renderTunerWithRotationMatrix() {
        this.renderTranslationTuner(0.01);
        this.m00.set((float)this.transformToTune.getRotation().getM00());
        this.m01.set((float)this.transformToTune.getRotation().getM01());
        this.m02.set((float)this.transformToTune.getRotation().getM02());
        this.m10.set((float)this.transformToTune.getRotation().getM10());
        this.m11.set((float)this.transformToTune.getRotation().getM11());
        this.m12.set((float)this.transformToTune.getRotation().getM12());
        this.m20.set((float)this.transformToTune.getRotation().getM20());
        this.m21.set((float)this.transformToTune.getRotation().getM21());
        this.m22.set((float)this.transformToTune.getRotation().getM22());
        ImGui.pushItemWidth((float)50.0f);
        ImGui.dragFloat((String)this.labels.get("m00"), (float[])this.m00.getData(), (float)0.01f);
        ImGui.sameLine();
        ImGui.dragFloat((String)this.labels.get("m01"), (float[])this.m01.getData(), (float)0.01f);
        ImGui.sameLine();
        ImGui.dragFloat((String)this.labels.get("m02"), (float[])this.m02.getData(), (float)0.01f);
        ImGui.dragFloat((String)this.labels.get("m10"), (float[])this.m10.getData(), (float)0.01f);
        ImGui.sameLine();
        ImGui.dragFloat((String)this.labels.get("m11"), (float[])this.m11.getData(), (float)0.01f);
        ImGui.sameLine();
        ImGui.dragFloat((String)this.labels.get("m12"), (float[])this.m12.getData(), (float)0.01f);
        ImGui.dragFloat((String)this.labels.get("m20"), (float[])this.m20.getData(), (float)0.01f);
        ImGui.sameLine();
        ImGui.dragFloat((String)this.labels.get("m21"), (float[])this.m21.getData(), (float)0.01f);
        ImGui.sameLine();
        ImGui.dragFloat((String)this.labels.get("m22"), (float[])this.m22.getData(), (float)0.01f);
        ImGui.popItemWidth();
        this.transformToTune.getRotation().set((double)this.m00.get(), (double)this.m01.get(), (double)this.m02.get(), (double)this.m10.get(), (double)this.m11.get(), (double)this.m12.get(), (double)this.m20.get(), (double)this.m21.get(), (double)this.m22.get());
    }

    public void renderTunerWithYawPitchRoll() {
        this.renderTunerWithYawPitchRoll(0.01);
    }

    public void renderTunerWithYawPitchRoll(double fineAdjustmentStepSize) {
        this.renderTranslationTuner(fineAdjustmentStepSize);
        this.yaw.set((float)this.transformToTune.getRotation().getYaw());
        this.pitch.set((float)this.transformToTune.getRotation().getPitch());
        this.roll.set((float)this.transformToTune.getRotation().getRoll());
        ImGui.pushItemWidth((float)50.0f);
        ImGui.dragFloat((String)this.labels.get("yaw"), (float[])this.yaw.getData(), (float)((float)fineAdjustmentStepSize));
        ImGui.sameLine();
        ImGui.dragFloat((String)this.labels.get("pitch"), (float[])this.pitch.getData(), (float)((float)fineAdjustmentStepSize));
        ImGui.sameLine();
        ImGui.dragFloat((String)this.labels.get("roll"), (float[])this.roll.getData(), (float)((float)fineAdjustmentStepSize));
        ImGui.popItemWidth();
        this.transformToTune.getRotation().setYawPitchRoll((double)this.yaw.get(), (double)this.pitch.get(), (double)this.roll.get());
    }

    public void renderTranslationTuner(double fineAdjustmentStepSize) {
        this.x.set((float)this.transformToTune.getTranslation().getX());
        this.y.set((float)this.transformToTune.getTranslation().getY());
        this.z.set((float)this.transformToTune.getTranslation().getZ());
        ImGui.pushItemWidth((float)50.0f);
        ImGui.dragFloat((String)this.labels.get("x"), (float[])this.x.getData(), (float)((float)fineAdjustmentStepSize));
        ImGui.sameLine();
        ImGui.dragFloat((String)this.labels.get("y"), (float[])this.y.getData(), (float)((float)fineAdjustmentStepSize));
        ImGui.sameLine();
        ImGui.dragFloat((String)this.labels.get("z"), (float[])this.z.getData(), (float)((float)fineAdjustmentStepSize));
        ImGui.popItemWidth();
        this.transformToTune.getTranslation().set((double)this.x.get(), (double)this.y.get(), (double)this.z.get());
    }
}

