/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import com.fasterxml.jackson.databind.node.ObjectNode;
import imgui.internal.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImInt;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import us.ihmc.commons.FormattingTools;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.imgui.GlfwWindowForImGui;
import us.ihmc.rdx.imgui.RDXImGuiWindowAndDockSystem;
import us.ihmc.rdx.imgui.RDXPanel;
import us.ihmc.rdx.imgui.RDXPanelManager;
import us.ihmc.rdx.ui.ImGuiConfigurationLocation;
import us.ihmc.rdx.ui.RDXImGuiLayoutManager;
import us.ihmc.tools.io.HybridResourceDirectory;
import us.ihmc.tools.io.HybridResourceFile;
import us.ihmc.tools.io.JSONFileTools;
import us.ihmc.tools.time.FrequencyCalculator;

public class ImGuiGlfwWindow {
    private final Path dotIHMCDirectory = Paths.get(System.getProperty("user.home"), ".ihmc");
    private final String configurationExtraPath;
    private final HybridResourceDirectory configurationBaseDirectory;
    private HybridResourceFile windowSettingsFile;
    private final FrequencyCalculator fpsCalculator = new FrequencyCalculator();
    private final Stopwatch runTime = new Stopwatch().start();
    private String[] iconPaths = null;
    private final GlfwWindowForImGui glfwWindowForImGui;
    private final RDXImGuiWindowAndDockSystem imGuiWindowAndDockSystem;
    private final RDXImGuiLayoutManager layoutManager;
    private final ImBoolean vsync = new ImBoolean(true);
    private final ImInt maxFrameRate = new ImInt(240);

    public ImGuiGlfwWindow(Class<?> classForLoading) {
        this(classForLoading, classForLoading.getSimpleName());
    }

    public ImGuiGlfwWindow(Class<?> classForLoading, String windowTitle) {
        this.configurationExtraPath = "configurations/" + windowTitle.replaceAll(" ", "");
        this.configurationBaseDirectory = new HybridResourceDirectory(this.dotIHMCDirectory, classForLoading).resolve(this.configurationExtraPath);
        this.glfwWindowForImGui = new GlfwWindowForImGui(windowTitle);
        this.layoutManager = new RDXImGuiLayoutManager(classForLoading, this.configurationExtraPath, this.configurationBaseDirectory);
        this.imGuiWindowAndDockSystem = new RDXImGuiWindowAndDockSystem(this.layoutManager);
        this.layoutManager.getLayoutDirectoryUpdatedListeners().add(this.imGuiWindowAndDockSystem::setDirectory);
        this.layoutManager.getLayoutDirectoryUpdatedListeners().add(updatedLayoutDirectory -> {
            this.windowSettingsFile = new HybridResourceFile(updatedLayoutDirectory, "WindowSettings.json");
        });
        this.layoutManager.getLoadListeners().add(this.imGuiWindowAndDockSystem::loadConfiguration);
        this.layoutManager.getLoadListeners().add(loadConfigurationLocation -> {
            this.windowSettingsFile.setMode(loadConfigurationLocation.toHybridResourceMode());
            return this.windowSettingsFile.getInputStream(inputStream -> JSONFileTools.load((InputStream)inputStream, jsonNode -> {
                int width = jsonNode.get("windowWidth").asInt();
                int height = jsonNode.get("windowHeight").asInt();
                this.glfwWindowForImGui.setWindowSize(width, height);
            }));
        });
        this.layoutManager.getSaveListeners().add(this::saveApplicationSettings);
        this.layoutManager.applyLayoutDirectory();
    }

    public void run(Runnable create, Runnable render, Runnable dispose) {
        this.run(create, null, render, dispose);
    }

    public void run(Runnable create, Runnable configure, Runnable render, Runnable dispose) {
        JSONFileTools.loadUserWithClasspathDefaultFallback((HybridResourceFile)this.windowSettingsFile, jsonNode -> this.glfwWindowForImGui.setWindowSize(jsonNode.get("windowWidth").asInt(), jsonNode.get("windowHeight").asInt()));
        this.glfwWindowForImGui.create();
        if (this.iconPaths != null) {
            this.glfwWindowForImGui.setIcon(this.iconPaths);
        }
        long windowHandle = this.glfwWindowForImGui.getWindowHandle();
        this.imGuiWindowAndDockSystem.create(windowHandle);
        if (create != null) {
            create.run();
        }
        this.glfwWindowForImGui.launch(() -> {
            if (configure != null) {
                configure.run();
            }
            this.imGuiWindowAndDockSystem.beforeWindowManagement();
            this.renderMenuBar();
            render.run();
            this.imGuiWindowAndDockSystem.afterWindowManagement();
        });
        dispose.run();
        this.imGuiWindowAndDockSystem.dispose();
        this.glfwWindowForImGui.dispose();
    }

    private void renderMenuBar() {
        ImGui.beginMainMenuBar();
        this.layoutManager.renderImGuiLayoutMenu();
        if (ImGui.beginMenu((String)"Panels")) {
            this.imGuiWindowAndDockSystem.renderMenuDockPanelItems();
            ImGui.endMenu();
        }
        if (ImGui.beginMenu((String)"Settings")) {
            ImGui.pushItemWidth((float)80.0f);
            if (ImGui.checkbox((String)"Vsync", (ImBoolean)this.vsync)) {
                this.glfwWindowForImGui.setVSyncEnabled(this.vsync.get());
            }
            if (ImGui.inputInt((String)"Max Frame Rate", (ImInt)this.maxFrameRate, (int)1)) {
                this.glfwWindowForImGui.setMaxFrameRate(this.maxFrameRate.get());
            }
            ImGui.popItemWidth();
            ImGui.endMenu();
        }
        ImGui.sameLine((float)(ImGui.getWindowSizeX() - 110.0f));
        this.fpsCalculator.ping();
        Object fpsString = String.valueOf((int)this.fpsCalculator.getFrequency());
        while (((String)fpsString).length() < 3) {
            fpsString = " " + (String)fpsString;
        }
        ImGui.text((String)((String)fpsString + " Hz"));
        ImGui.text((String)(FormattingTools.getFormattedDecimal2D((double)this.runTime.totalElapsed()) + " s"));
        ImGui.endMainMenuBar();
    }

    private void saveApplicationSettings(ImGuiConfigurationLocation saveConfigurationLocation) {
        this.imGuiWindowAndDockSystem.saveConfiguration(saveConfigurationLocation);
        Consumer<ObjectNode> rootConsumer = root -> {
            root.put("windowWidth", this.glfwWindowForImGui.getWindowWidth());
            root.put("windowHeight", this.glfwWindowForImGui.getWindowHeight());
        };
        if (saveConfigurationLocation.isVersionControl()) {
            LogTools.info((String)"Saving window settings to {}", (Object)this.windowSettingsFile.getWorkspaceFile().toString());
            JSONFileTools.save((Path)this.windowSettingsFile.getWorkspaceFile(), rootConsumer);
        } else {
            LogTools.info((String)"Saving window settings to {}", (Object)this.windowSettingsFile.getExternalFile().toString());
            JSONFileTools.save((Path)this.windowSettingsFile.getExternalFile(), rootConsumer);
        }
    }

    public void runWithSinglePanel(Runnable renderImGuiWidgets) {
        RDXPanel mainPanel = new RDXPanel("Main Panel", renderImGuiWidgets);
        mainPanel.getIsShowing().set(true);
        this.imGuiWindowAndDockSystem.getPanelManager().addPanel(mainPanel);
        this.run(null, () -> {}, () -> System.exit(0));
    }

    public void setIcons(String ... iconPaths) {
        this.iconPaths = iconPaths;
    }

    public void setEnableVsync(boolean enableVsync) {
        this.vsync.set(enableVsync);
        this.glfwWindowForImGui.setVSyncEnabled(enableVsync);
    }

    public RDXPanelManager getPanelManager() {
        return this.imGuiWindowAndDockSystem.getPanelManager();
    }

    public RDXImGuiWindowAndDockSystem getImGuiDockSystem() {
        return this.imGuiWindowAndDockSystem;
    }
}

