/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.ImGui;
import us.ihmc.euclid.tuple2D.Point2D32;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public class ImGuiDirectionalTriangleRenderer {
    private final Point2D32 center = new Point2D32();
    private final Point2D32 a = new Point2D32();
    private final Point2D32 b = new Point2D32();
    private final Point2D32 c = new Point2D32();

    public void render(int imGuiDirection, float scale, int color) {
        float framePaddingY = ImGui.getStyle().getFramePaddingY();
        ImGui.setCursorPosY((float)(ImGui.getCursorPosY() + framePaddingY));
        float fontSize = ImGui.getFontSize();
        float radius = fontSize * 0.4f * scale;
        this.center.set(0.5, 0.5);
        this.center.scale((double)fontSize);
        this.center.setY(this.center.getY32() * scale);
        float zero = 0.0f;
        float halfheight = 0.75f;
        float halfwidth = 0.866f;
        if (imGuiDirection == 3) {
            this.a.set((double)zero, (double)halfheight);
            this.b.set((double)(-halfwidth), (double)(-halfheight));
            this.c.set((double)halfwidth, (double)(-halfheight));
        }
        if (imGuiDirection == 1) {
            this.a.set((double)halfheight, (double)zero);
            this.b.set((double)(-halfheight), (double)halfwidth);
            this.c.set((double)(-halfheight), (double)(-halfwidth));
        }
        this.a.scaleAdd((double)radius, (Tuple2DReadOnly)this.center);
        this.b.scaleAdd((double)radius, (Tuple2DReadOnly)this.center);
        this.c.scaleAdd((double)radius, (Tuple2DReadOnly)this.center);
        float cursorXDesktopFrame = ImGui.getWindowPosX() + ImGui.getCursorPosX() - ImGui.getScrollX();
        float cursorYDesktopFrame = ImGui.getWindowPosY() + ImGui.getCursorPosY() - ImGui.getScrollY();
        ImGui.getWindowDrawList().addTriangleFilled(cursorXDesktopFrame + this.a.getX32(), cursorYDesktopFrame + this.a.getY32(), cursorXDesktopFrame + this.b.getX32(), cursorYDesktopFrame + this.b.getY32(), cursorXDesktopFrame + this.c.getX32(), cursorYDesktopFrame + this.c.getY32(), color);
        ImGui.setCursorPosY((float)(ImGui.getCursorPosY() - framePaddingY));
    }
}

