/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.function.Function;
import org.lwjgl.opengl.GL41;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.rdx.shader.RDXShader;
import us.ihmc.rdx.shader.RDXUniform;

public class RDXPointCloudRenderer
implements RenderableProvider {
    private Renderable renderable;
    private float[] vertices;
    public static final int FLOATS_PER_VERTEX = 8;
    public static final int BYTES_PER_VERTEX = 32;
    private final VertexAttributes vertexAttributes = new VertexAttributes(new VertexAttribute[]{new VertexAttribute(1, 3, "a_position"), new VertexAttribute(2, 4, "a_color"), new VertexAttribute(32, 1, 5126, false, "a_size")});
    private final int floatsPerVertex;
    private final RDXUniform screenWidthUniform;
    private int multiColor;
    private final RDXUniform multiColorUniform;
    private RecyclingArrayList<Point3D32> pointsToRender;
    private ColorProvider colorProvider;
    private float pointScale;
    private int pointsPerSegment;
    private int numberOfSegments;
    private boolean hasTurnedOver;
    private int currentSegmentIndex;
    private int maxPoints;

    public RDXPointCloudRenderer() {
        this.floatsPerVertex = this.vertexAttributes.vertexSize / 4;
        this.screenWidthUniform = RDXUniform.createGlobalUniform("u_screenWidth", (shader, inputID, renderable, combinedAttributes) -> shader.set(inputID, shader.camera.viewportWidth));
        this.multiColor = 0;
        this.multiColorUniform = RDXUniform.createGlobalUniform("u_multiColor", (shader, inputID, renderable, combinedAttributes) -> shader.set(inputID, this.multiColor));
        this.pointScale = 0.01f;
        this.hasTurnedOver = false;
        this.currentSegmentIndex = 0;
    }

    public void create(int size) {
        this.create(size, 1);
    }

    public void create(int pointsPerSegment, int numberOfSegments) {
        this.currentSegmentIndex = 0;
        this.hasTurnedOver = false;
        this.pointsPerSegment = pointsPerSegment;
        this.numberOfSegments = numberOfSegments;
        GL41.glEnable((int)34370);
        this.renderable = new Renderable();
        this.renderable.meshPart.primitiveType = 0;
        this.renderable.meshPart.offset = 0;
        this.renderable.material = new Material(new Attribute[]{ColorAttribute.createDiffuse((Color)Color.WHITE)});
        this.maxPoints = pointsPerSegment * numberOfSegments;
        this.vertices = new float[this.maxPoints * this.floatsPerVertex];
        if (this.renderable.meshPart.mesh != null) {
            this.renderable.meshPart.mesh.dispose();
        }
        boolean isStatic = false;
        int maxIndices = 0;
        this.renderable.meshPart.mesh = new Mesh(isStatic, this.maxPoints, maxIndices, this.vertexAttributes);
        RDXShader shader = new RDXShader(this.getClass());
        shader.create();
        shader.getBaseShader().register(DefaultShader.Inputs.viewTrans, DefaultShader.Setters.viewTrans);
        shader.getBaseShader().register(DefaultShader.Inputs.projTrans, DefaultShader.Setters.projTrans);
        shader.registerUniform(this.screenWidthUniform);
        shader.registerUniform(this.multiColorUniform);
        shader.init(this.renderable);
        this.renderable.shader = shader.getBaseShader();
    }

    public void updateMesh() {
        this.updateMesh(1.0f);
    }

    public void updateMesh(float alpha) {
        if (this.pointsToRender != null) {
            if (this.pointsToRender.isEmpty()) {
                ((Point3D32)this.pointsToRender.add()).setToNaN();
            }
            for (int i = 0; i < this.pointsToRender.size(); ++i) {
                int offset = i * this.floatsPerVertex;
                Point3D32 point = (Point3D32)this.pointsToRender.get(i);
                this.vertices[offset] = point.getX32();
                this.vertices[offset + 1] = point.getY32();
                this.vertices[offset + 2] = point.getZ32();
                this.vertices[offset + 3] = this.colorProvider.getNextR();
                this.vertices[offset + 4] = this.colorProvider.getNextG();
                this.vertices[offset + 5] = this.colorProvider.getNextB();
                this.vertices[offset + 6] = alpha;
                this.vertices[offset + 7] = this.pointScale;
            }
            this.renderable.meshPart.size = this.pointsToRender.size();
            this.renderable.meshPart.mesh.setVertices(this.vertices, 0, this.pointsToRender.size() * this.floatsPerVertex);
        }
    }

    public void updateMesh(RecyclingArrayList<? extends Tuple3DBasics> pointsToRender, Color color) {
        if (pointsToRender != null) {
            if (pointsToRender.isEmpty()) {
                ((Tuple3DBasics)pointsToRender.add()).setToNaN();
            }
            for (int i = 0; i < pointsToRender.size(); ++i) {
                int offset = i * this.floatsPerVertex;
                Tuple3DReadOnly point = (Tuple3DReadOnly)pointsToRender.get(i);
                this.vertices[offset] = point.getX32();
                this.vertices[offset + 1] = point.getY32();
                this.vertices[offset + 2] = point.getZ32();
                this.vertices[offset + 3] = color.r;
                this.vertices[offset + 4] = color.g;
                this.vertices[offset + 5] = color.b;
                this.vertices[offset + 6] = color.a;
                this.vertices[offset + 7] = this.pointScale;
            }
            this.renderable.meshPart.size = pointsToRender.size();
            this.renderable.meshPart.mesh.setVertices(this.vertices, 0, pointsToRender.size() * this.floatsPerVertex);
        }
    }

    public void updateMesh(RecyclingArrayList<Point3D32> pointsToRender, ArrayList<Integer> colors) {
        for (int i = 0; i < pointsToRender.size(); ++i) {
            int offset = i * this.floatsPerVertex;
            Point3D32 point = (Point3D32)pointsToRender.get(i);
            this.vertices[offset] = point.getX32();
            this.vertices[offset + 1] = point.getY32();
            this.vertices[offset + 2] = point.getZ32();
            if (colors.size() > i) {
                this.vertices[offset + 3] = (float)((colors.get(i) & 0xFF000000) >>> 24) / 255.0f;
                this.vertices[offset + 4] = (float)((colors.get(i) & 0xFF0000) >>> 16) / 255.0f;
                this.vertices[offset + 5] = (float)((colors.get(i) & 0xFF00) >>> 8) / 255.0f;
                this.vertices[offset + 6] = (float)(colors.get(i) & 0xFF) / 255.0f;
            }
            this.vertices[offset + 7] = this.pointScale;
        }
        this.renderable.meshPart.size = pointsToRender.size();
        this.renderable.meshPart.mesh.setVertices(this.vertices, 0, pointsToRender.size() * this.floatsPerVertex);
        if (!pointsToRender.isEmpty()) {
            // empty if block
        }
    }

    public void updateMeshFastest(Function<FloatBuffer, Integer> bufferConsumer) {
        this.updateMeshFastest(bufferConsumer, this.currentSegmentIndex);
    }

    public void updateMeshFastest(Function<FloatBuffer, Integer> bufferConsumer, int segmentToUpdate) {
        if (!this.hasTurnedOver && segmentToUpdate > this.currentSegmentIndex) {
            return;
        }
        FloatBuffer floatBuffer = this.renderable.meshPart.mesh.getVerticesBuffer();
        floatBuffer.position(segmentToUpdate * this.pointsPerSegment * this.floatsPerVertex);
        floatBuffer.limit(floatBuffer.position() + this.pointsPerSegment * this.floatsPerVertex);
        int numberOfPoints = bufferConsumer.apply(floatBuffer);
        this.updateMeshFastest(numberOfPoints, segmentToUpdate);
    }

    public void updateMeshFastest() {
        this.updateMeshFastest(this.getVertexBuffer().position() / 8);
    }

    public void updateMeshFastest(int numberOfPoints) {
        FloatBuffer floatBuffer = this.renderable.meshPart.mesh.getVerticesBuffer();
        floatBuffer.position(0);
        floatBuffer.limit(numberOfPoints * 8);
        this.renderable.meshPart.size = numberOfPoints;
    }

    public void updateMeshFastest(int numberOfPoints, int segmentToUpdate) {
        FloatBuffer floatBuffer = this.renderable.meshPart.mesh.getVerticesBuffer();
        if (numberOfPoints < this.pointsPerSegment) {
            if (numberOfPoints == 0) {
                numberOfPoints = 1;
                floatBuffer.put(Float.NaN);
                floatBuffer.put(Float.NaN);
                floatBuffer.put(Float.NaN);
                floatBuffer.put(1.0f);
                floatBuffer.put(1.0f);
                floatBuffer.put(1.0f);
                floatBuffer.put(1.0f);
                floatBuffer.put(1.0f);
            }
            floatBuffer.position(0);
            floatBuffer.limit(numberOfPoints * this.floatsPerVertex);
            this.renderable.meshPart.size = numberOfPoints;
        } else {
            floatBuffer.position(0);
            if (this.hasTurnedOver) {
                floatBuffer.limit(this.maxPoints * this.floatsPerVertex);
            } else {
                floatBuffer.limit((segmentToUpdate + 1) * this.pointsPerSegment * this.floatsPerVertex);
            }
            this.renderable.meshPart.size = this.maxPoints;
        }
        this.currentSegmentIndex = segmentToUpdate + 1;
        if (this.currentSegmentIndex == this.numberOfSegments) {
            this.hasTurnedOver = true;
            this.currentSegmentIndex = 0;
        }
    }

    public void updateMeshFastestBeforeKernel() {
        FloatBuffer floatBuffer = this.renderable.meshPart.mesh.getVerticesBuffer();
        floatBuffer.position(0);
        int numberOfPointsNow = !this.hasTurnedOver ? (this.currentSegmentIndex + 1) * this.pointsPerSegment : this.maxPoints;
        floatBuffer.limit(numberOfPointsNow * this.floatsPerVertex);
        this.renderable.meshPart.size = numberOfPointsNow;
    }

    public void updateMeshFastestAfterKernel() {
        ++this.currentSegmentIndex;
        if (this.currentSegmentIndex >= this.numberOfSegments) {
            this.hasTurnedOver = true;
            this.currentSegmentIndex = 0;
        }
    }

    public void setVertex(int vertexIndex, Tuple3DReadOnly point) {
        this.setVertex(vertexIndex, point.getX32(), point.getY32(), point.getZ32(), 1.0f, 1.0f, 1.0f, 1.0f, 0.01f);
    }

    public void setVertex(int vertexIndex, float x, float y, float z, float r, float g, float b, float a, float pointSize) {
        int offset = vertexIndex * 8;
        this.getVertexBuffer().put(offset++, x);
        this.getVertexBuffer().put(offset++, y);
        this.getVertexBuffer().put(offset++, z);
        this.getVertexBuffer().put(offset++, r);
        this.getVertexBuffer().put(offset++, g);
        this.getVertexBuffer().put(offset++, b);
        this.getVertexBuffer().put(offset++, a);
        this.getVertexBuffer().put(offset, pointSize);
    }

    public void putVertex(Tuple3DReadOnly point) {
        this.putVertex(point.getX32(), point.getY32(), point.getZ32(), 1.0f, 1.0f, 1.0f, 1.0f, 0.01f);
    }

    public void putVertex(float x, float y, float z, float r, float g, float b, float a, float pointSize) {
        this.getVertexBuffer().put(x);
        this.getVertexBuffer().put(y);
        this.getVertexBuffer().put(z);
        this.getVertexBuffer().put(r);
        this.getVertexBuffer().put(g);
        this.getVertexBuffer().put(b);
        this.getVertexBuffer().put(a);
        this.getVertexBuffer().put(pointSize);
    }

    public void prepareVertexBufferForAddingPoints() {
        FloatBuffer vertexBuffer = this.getVertexBuffer();
        vertexBuffer.limit(vertexBuffer.capacity());
        vertexBuffer.rewind();
    }

    public FloatBuffer getAndPrepareVertexBuffer() {
        this.prepareVertexBufferForAddingPoints();
        return this.getVertexBuffer();
    }

    public FloatBuffer getVertexBuffer() {
        return this.renderable.meshPart.mesh.getVerticesBuffer();
    }

    @Deprecated
    public float[] getVerticesArray() {
        return this.vertices;
    }

    public void updateMeshFast(int numberOfPoints) {
        this.renderable.meshPart.size = numberOfPoints;
        this.renderable.meshPart.mesh.setVertices(this.vertices, 0, numberOfPoints * this.floatsPerVertex);
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.renderable != null) {
            renderables.add((Object)this.renderable);
        }
    }

    public void dispose() {
        if (this.renderable.meshPart.mesh != null) {
            this.renderable.meshPart.mesh.dispose();
        }
    }

    public void setPointsToRender(RecyclingArrayList<Point3D32> pointsToRender) {
        this.setPointsToRender(pointsToRender, new ColorProvider(){

            @Override
            public float getNextR() {
                return Color.WHITE.r;
            }

            @Override
            public float getNextG() {
                return Color.WHITE.g;
            }

            @Override
            public float getNextB() {
                return Color.WHITE.b;
            }

            @Override
            public float getNextA() {
                return Color.WHITE.a;
            }
        });
    }

    public void setPointsToRender(RecyclingArrayList<Point3D32> pointsToRender, final Color color) {
        this.setPointsToRender(pointsToRender, new ColorProvider(){

            @Override
            public float getNextR() {
                return color.r;
            }

            @Override
            public float getNextG() {
                return color.g;
            }

            @Override
            public float getNextB() {
                return color.b;
            }

            @Override
            public float getNextA() {
                return color.a;
            }
        });
    }

    public void setPointsToRender(RecyclingArrayList<Point3D32> pointsToRender, ColorProvider provider) {
        this.pointsToRender = pointsToRender;
        this.colorProvider = provider;
    }

    public void setPointScale(float size) {
        this.pointScale = size;
    }

    public int getFloatsPerVertex() {
        return this.floatsPerVertex;
    }

    public int getMaxPoints() {
        return this.maxPoints;
    }

    public int getCurrentSegmentIndex() {
        return this.currentSegmentIndex;
    }

    public static interface ColorProvider {
        public float getNextR();

        public float getNextG();

        public float getNextB();

        public float getNextA();
    }
}

