/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import org.lwjgl.opengl.GL41;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.HmdMatrix44;
import org.lwjgl.openvr.Texture;
import org.lwjgl.openvr.VRSystem;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.rdx.sceneManager.RDX3DScene;
import us.ihmc.rdx.sceneManager.RDX3DSceneTools;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.vr.RDXVRHeadset;
import us.ihmc.robotics.robotSide.RobotSide;

public class RDXVREye
extends Camera {
    private final GLFrameBuffer<com.badlogic.gdx.graphics.Texture> frameBuffer;
    private final Texture openVRTexture;
    private final RobotSide side;
    private final HmdMatrix44 projectionHmdMatrix44 = HmdMatrix44.create();
    private final HmdMatrix34 eyeToHeadHmdMatrix34 = HmdMatrix34.create();
    private final Vector3 target = new Vector3();
    private final RigidBodyTransform openVREyeToHeadTransform = new RigidBodyTransform();
    private final ReferenceFrame eyeXRightZBackFrame;
    private final RigidBodyTransformReadOnly xForwardZUpToXRightZBackTransform = new RigidBodyTransform((Orientation3DReadOnly)new YawPitchRoll(Math.toRadians(90.0), Math.toRadians(90.0), Math.toRadians(0.0)), (Tuple3DReadOnly)new Point3D());
    private final ReferenceFrame eyeXForwardZUpFrame;
    private final FramePose3D eyeFramePose = new FramePose3D();
    private final Vector3D euclidDirection = new Vector3D();
    private final Vector3D euclidUp = new Vector3D();

    public RDXVREye(RobotSide side, RDXVRHeadset headset, int width, int height) {
        this.side = side;
        this.eyeXRightZBackFrame = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)(side.getLowerCaseName() + "EyeXRightZBackFrame"), (ReferenceFrame)headset.getDeviceYUpZBackFrame(), (RigidBodyTransformReadOnly)this.openVREyeToHeadTransform);
        this.eyeXForwardZUpFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)(side.getLowerCaseName() + "EyeXForwardZUpFrame"), (ReferenceFrame)this.eyeXRightZBackFrame, (RigidBodyTransformReadOnly)this.xForwardZUpToXRightZBackTransform);
        boolean hasDepth = true;
        boolean hasStencil = false;
        this.frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, hasDepth, hasStencil);
        this.openVRTexture = Texture.create();
        this.openVRTexture.set((long)((com.badlogic.gdx.graphics.Texture)this.frameBuffer.getColorBufferTexture()).getTextureObjectHandle(), 1, 1);
        this.viewportWidth = width;
        this.viewportHeight = height;
        this.near = 0.1f;
        this.far = 1000.0f;
    }

    public void update() {
        this.update(true);
    }

    public void update(boolean updateFrustum) {
        VRSystem.VRSystem_GetEyeToHeadTransform((int)(this.side == RobotSide.LEFT ? 0 : 1), (HmdMatrix34)this.eyeToHeadHmdMatrix34);
        LibGDXTools.toEuclid(this.eyeToHeadHmdMatrix34, this.openVREyeToHeadTransform);
        this.eyeXRightZBackFrame.update();
        this.eyeFramePose.setToZero(this.eyeXForwardZUpFrame);
        this.eyeFramePose.changeFrame(ReferenceFrame.getWorldFrame());
        this.euclidDirection.set((Tuple3DReadOnly)Axis3D.X);
        this.eyeFramePose.getOrientation().transform((Tuple3DBasics)this.euclidDirection);
        this.euclidUp.set((Tuple3DReadOnly)Axis3D.Z);
        this.eyeFramePose.getOrientation().transform((Tuple3DBasics)this.euclidUp);
        LibGDXTools.toLibGDX((Tuple3DReadOnly)this.eyeFramePose.getPosition(), this.position);
        this.direction.set(this.euclidDirection.getX32(), this.euclidDirection.getY32(), this.euclidDirection.getZ32());
        this.up.set(this.euclidUp.getX32(), this.euclidUp.getY32(), this.euclidUp.getZ32());
        VRSystem.VRSystem_GetProjectionMatrix((int)this.side.ordinal(), (float)Math.abs(this.near), (float)Math.abs(this.far), (HmdMatrix44)this.projectionHmdMatrix44);
        LibGDXTools.toLibGDX(this.projectionHmdMatrix44, this.projection);
        this.view.setToLookAt(this.position, this.target.set(this.position).add(this.direction), this.up);
        this.combined.set(this.projection);
        Matrix4.mul((float[])this.combined.val, (float[])this.view.val);
        if (updateFrustum) {
            this.invProjectionView.set(this.combined);
            Matrix4.inv((float[])this.invProjectionView.val);
            this.frustum.update(this.invProjectionView);
        }
    }

    public void render(RDX3DScene scene) {
        this.update();
        this.frameBuffer.begin();
        GL41.glViewport((int)0, (int)0, (int)((int)this.viewportWidth), (int)((int)this.viewportHeight));
        RDX3DSceneTools.glClearGray();
        scene.renderToCamera(this);
        this.frameBuffer.end();
    }

    public ReferenceFrame getEyeXForwardZUpFrame() {
        return this.eyeXForwardZUpFrame;
    }

    public ReferenceFrame getEyeXRightZBackFrame() {
        return this.eyeXRightZBackFrame;
    }

    public GLFrameBuffer<com.badlogic.gdx.graphics.Texture> getFrameBuffer() {
        return this.frameBuffer;
    }

    public Texture getOpenVRTexture() {
        return this.openVRTexture;
    }
}

