/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import org.lwjgl.openvr.InputAnalogActionData;
import org.lwjgl.openvr.InputDigitalActionData;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameBox3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.rdx.tools.RDXModelBuilder;
import us.ihmc.rdx.tools.RDXModelInstance;
import us.ihmc.rdx.vr.RDXVRController;
import us.ihmc.rdx.vr.RDXVRControllerButtonLabel;
import us.ihmc.rdx.vr.RDXVRRadialMenuSelection;
import us.ihmc.robotics.referenceFrames.MutableReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;

public class RDXVRControllerRadialMenu {
    private final RobotSide side;
    private final FrameBox3D selectionCollisionBox = new FrameBox3D();
    private final MutableReferenceFrame joystickReferenceFrame;
    private final MutableReferenceFrame radialMenuSpherePoseFrame;
    private final MutableReferenceFrame radialMenuReferenceFrame;
    private InputAnalogActionData joystickActionData;
    private InputDigitalActionData joystickPressActionData;
    private RDXModelInstance radialMenuSphere;
    private RDXModelInstance radialMenuSelectionGraphic;
    private boolean showSphere = false;
    private boolean showSelectionBox = false;
    private RDXVRRadialMenuSelection radialMenuSelection = RDXVRRadialMenuSelection.NONE;
    private Point3D topJoystickOffset;
    private Point3D bottomJoystickOffset;
    private Point3D leftJoystickOffset;
    private Point3D rightJoystickOffset;
    private RDXVRControllerButtonLabel topJoystickLabel;
    private RDXVRControllerButtonLabel bottomJoystickLabel;
    private RDXVRControllerButtonLabel leftJoystickLabel;
    private RDXVRControllerButtonLabel rightJoystickLabel;
    private final Point3D boxOffset = new Point3D();
    private final FramePose3D radialMenuFramePose = new FramePose3D();
    private final FramePose3D joystickFramePose = new FramePose3D();
    private final FramePose3D joystickSphereFramePose = new FramePose3D();

    public RDXVRControllerRadialMenu(RobotSide side, ReferenceFrame xForwardZUpControllerFrame) {
        this.side = side;
        this.selectionCollisionBox.getSize().set(0.0125, 0.075, 0.0025);
        this.joystickReferenceFrame = new MutableReferenceFrame(xForwardZUpControllerFrame);
        this.joystickReferenceFrame.getTransformToParent().getTranslation().setX(-0.04);
        this.joystickReferenceFrame.getTransformToParent().getTranslation().setY(side.negateIfLeftSide(-0.015));
        this.joystickReferenceFrame.getTransformToParent().getTranslation().setZ(-0.017);
        this.joystickReferenceFrame.getReferenceFrame().update();
        this.radialMenuSpherePoseFrame = new MutableReferenceFrame(this.joystickReferenceFrame.getReferenceFrame());
        this.radialMenuReferenceFrame = new MutableReferenceFrame(this.joystickReferenceFrame.getReferenceFrame());
    }

    public void create(InputAnalogActionData joystickActionData, InputDigitalActionData joystickPressActionData) {
        this.joystickActionData = joystickActionData;
        this.joystickPressActionData = joystickPressActionData;
        this.radialMenuSphere = new RDXModelInstance(RDXModelBuilder.createSphere(0.0025f, new Color(Color.WHITE)));
        this.radialMenuSelectionGraphic = new RDXModelInstance(RDXModelBuilder.buildModel(boxMeshBuilder -> boxMeshBuilder.addMultiLineBox((Point3DReadOnly[])this.selectionCollisionBox.getVertices(), 5.0E-4, new Color(Color.WHITE))));
        this.topJoystickOffset = new Point3D(0.1, 0.0, 0.0);
        this.bottomJoystickOffset = new Point3D(-0.1, 0.0, -0.006);
        this.rightJoystickOffset = new Point3D(0.0, -0.1, -0.002);
        this.leftJoystickOffset = new Point3D(0.0, 0.1, -0.002);
        this.topJoystickLabel = new RDXVRControllerButtonLabel(this.joystickReferenceFrame.getReferenceFrame(), this.side, this.topJoystickOffset, new YawPitchRoll());
        this.bottomJoystickLabel = new RDXVRControllerButtonLabel(this.joystickReferenceFrame.getReferenceFrame(), this.side, this.bottomJoystickOffset, new YawPitchRoll());
        this.rightJoystickLabel = new RDXVRControllerButtonLabel(this.joystickReferenceFrame.getReferenceFrame(), this.side, this.rightJoystickOffset, new YawPitchRoll());
        this.leftJoystickLabel = new RDXVRControllerButtonLabel(this.joystickReferenceFrame.getReferenceFrame(), this.side, this.leftJoystickOffset, new YawPitchRoll());
    }

    public void update() {
        this.joystickReferenceFrame.getReferenceFrame().update();
        this.joystickFramePose.setToZero(this.joystickReferenceFrame.getReferenceFrame());
        this.joystickFramePose.changeFrame(ReferenceFrame.getWorldFrame());
        this.radialMenuSpherePoseFrame.getReferenceFrame().update();
        this.joystickSphereFramePose.setToZero(this.radialMenuSpherePoseFrame.getReferenceFrame());
        this.joystickSphereFramePose.changeFrame(ReferenceFrame.getWorldFrame());
        this.radialMenuSphere.setPoseInWorldFrame((Pose3DReadOnly)this.joystickSphereFramePose);
        this.topJoystickLabel.setText("");
        this.bottomJoystickLabel.setText("");
        this.leftJoystickLabel.setText("");
        this.rightJoystickLabel.setText("");
        double radialSelectorTranslationScalar = 0.1;
        this.radialMenuSpherePoseFrame.getTransformToParent().getTranslation().setX(radialSelectorTranslationScalar * (double)this.joystickActionData.y());
        this.radialMenuSpherePoseFrame.getTransformToParent().getTranslation().setY(-radialSelectorTranslationScalar * (double)this.joystickActionData.x());
        this.showSphere = false;
        this.showSelectionBox = false;
        this.radialMenuSelection = RDXVRRadialMenuSelection.NONE;
    }

    public void run(RDXVRController controller, String topText, String bottomText, String rightText, String leftText, Runnable topRunnable, Runnable bottomRunnable, Runnable rightRunnable, Runnable leftRunnable) {
        this.showSphere = true;
        if (!controller.getJoystickIsCentered()) {
            this.showSelectionBox = true;
            this.topJoystickLabel.setText(topText);
            this.bottomJoystickLabel.setText(bottomText);
            this.rightJoystickLabel.setText(rightText);
            this.leftJoystickLabel.setText(leftText);
            if (this.joystickActionData.x() < 0.0f && Math.abs(this.joystickActionData.x()) > Math.abs(this.joystickActionData.y())) {
                this.radialMenuSelection = RDXVRRadialMenuSelection.LEFT_RING;
            }
            if (this.joystickActionData.x() > 0.0f && Math.abs(this.joystickActionData.x()) > Math.abs(this.joystickActionData.y())) {
                this.radialMenuSelection = RDXVRRadialMenuSelection.RIGHT_RING;
            }
            if (this.joystickActionData.y() > 0.0f && Math.abs(this.joystickActionData.y()) > Math.abs(this.joystickActionData.x())) {
                this.radialMenuSelection = RDXVRRadialMenuSelection.TOP_RING;
            }
            if (this.joystickActionData.y() < 0.0f && Math.abs(this.joystickActionData.y()) > Math.abs(this.joystickActionData.x())) {
                this.radialMenuSelection = RDXVRRadialMenuSelection.BOTTOM_RING;
            }
            switch (this.radialMenuSelection) {
                case LEFT_RING: {
                    this.boxOffset.set(this.leftJoystickOffset);
                    break;
                }
                case RIGHT_RING: {
                    this.boxOffset.set(this.rightJoystickOffset);
                    break;
                }
                case TOP_RING: {
                    this.boxOffset.set(this.topJoystickOffset);
                    break;
                }
                case BOTTOM_RING: {
                    this.boxOffset.set(this.bottomJoystickOffset);
                }
            }
            this.radialMenuReferenceFrame.getReferenceFrame().getTransformToParent().getTranslation().set((Tuple3DReadOnly)this.boxOffset);
            this.radialMenuReferenceFrame.getReferenceFrame().update();
            this.radialMenuFramePose.setToZero(this.radialMenuReferenceFrame.getReferenceFrame());
            this.radialMenuFramePose.getTranslation().add((Tuple3DReadOnly)this.boxOffset);
            this.radialMenuFramePose.getTranslation().subY(0.03);
            if (this.side == RobotSide.RIGHT) {
                this.radialMenuFramePose.getTranslation().addX(0.01);
            }
            this.radialMenuFramePose.getRotation().setToYawOrientation(this.side.negateIfLeftSide(0.2));
            this.radialMenuFramePose.changeFrame(ReferenceFrame.getWorldFrame());
            this.radialMenuSelectionGraphic.setPoseInWorldFrame((Pose3DReadOnly)this.radialMenuFramePose);
            if (this.joystickPressActionData.bChanged() && !this.joystickPressActionData.bState()) {
                switch (this.radialMenuSelection) {
                    case TOP_RING: {
                        topRunnable.run();
                        break;
                    }
                    case BOTTOM_RING: {
                        bottomRunnable.run();
                        break;
                    }
                    case RIGHT_RING: {
                        rightRunnable.run();
                        break;
                    }
                    case LEFT_RING: {
                        leftRunnable.run();
                    }
                }
            }
        }
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.showSphere) {
            this.radialMenuSphere.getRenderables(renderables, pool);
        }
        if (this.showSelectionBox) {
            this.radialMenuSelectionGraphic.getRenderables(renderables, pool);
        }
        if (this.topJoystickLabel != null) {
            this.topJoystickLabel.getRenderables(renderables, pool);
        }
        if (this.bottomJoystickLabel != null) {
            this.bottomJoystickLabel.getRenderables(renderables, pool);
        }
        if (this.rightJoystickLabel != null) {
            this.rightJoystickLabel.getRenderables(renderables, pool);
        }
        if (this.leftJoystickLabel != null) {
            this.leftJoystickLabel.getRenderables(renderables, pool);
        }
    }
}

