/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;
import com.fasterxml.jackson.databind.JsonNode;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL41;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.Texture;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.openvr.VR;
import org.lwjgl.openvr.VRActiveActionSet;
import org.lwjgl.openvr.VRCompositor;
import org.lwjgl.openvr.VREvent;
import org.lwjgl.openvr.VRInput;
import org.lwjgl.openvr.VRSystem;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.sceneManager.RDX3DScene;
import us.ihmc.rdx.vr.RDXVRBaseStation;
import us.ihmc.rdx.vr.RDXVRController;
import us.ihmc.rdx.vr.RDXVRControllerModel;
import us.ihmc.rdx.vr.RDXVREye;
import us.ihmc.rdx.vr.RDXVRHeadset;
import us.ihmc.rdx.vr.RDXVRTracker;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.tools.io.JSONFileTools;
import us.ihmc.tools.io.JSONTools;
import us.ihmc.tools.io.WorkspaceResourceDirectory;
import us.ihmc.tools.io.WorkspaceResourceFile;

public class RDXVRContext {
    private static final Map<String, String> TRACKER_SERIAL_MAP = new HashMap<String, String>(){
        {
            this.put("LHR-6680BD50", "chest");
            this.put("LHR-743512BE", "leftForeArm");
            this.put("LHR-41A915A6", "rightForeArm");
        }
    };
    private final IntBuffer errorPointer = BufferUtils.newIntBuffer((int)1);
    private final IntBuffer widthPointer = BufferUtils.newIntBuffer((int)1);
    private final IntBuffer heightPointer = BufferUtils.newIntBuffer((int)1);
    private final SideDependentList<RDXVREye> eyes = new SideDependentList();
    private TrackedDevicePose.Buffer trackedDevicePoses;
    private TrackedDevicePose.Buffer trackedDeviceGamePoses;
    private final LongBuffer mainActionSetHandle = BufferUtils.newLongBuffer((int)1);
    private VRActiveActionSet.Buffer activeActionSets;
    private VREvent event;
    private int width;
    private int height;
    private final ArrayList<Consumer<RDXVRContext>> vrPickCalculators = new ArrayList();
    private final ArrayList<Consumer<RDXVRContext>> vrInputProcessors = new ArrayList();
    private final Map<Object, Consumer<RDXVRContext>> vrPickCalculatorOwnerKeyMap = new HashMap<Object, Consumer<RDXVRContext>>();
    private final Map<Object, Consumer<RDXVRContext>> vrInputProcessorOwnerKeyMap = new HashMap<Object, Consumer<RDXVRContext>>();
    public static final RigidBodyTransformReadOnly openVRYUpToIHMCZUpSpace = new RigidBodyTransform((Orientation3DReadOnly)new YawPitchRoll(Math.toRadians(-90.0), Math.toRadians(0.0), Math.toRadians(90.0)), (Tuple3DReadOnly)new Point3D());
    private final RigidBodyTransform teleportIHMCZUpToIHMCZUpWorld = new RigidBodyTransform();
    private final ReferenceFrame teleportFrameIHMCZUp = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)"teleportFrame", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)this.teleportIHMCZUpToIHMCZUpWorld);
    private final ReferenceFrame vrPlayAreaYUpZBackFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"vrPlayAreaFrame", (ReferenceFrame)this.teleportFrameIHMCZUp, (RigidBodyTransformReadOnly)openVRYUpToIHMCZUpSpace);
    private RDXVRControllerModel controllerModel = RDXVRControllerModel.UNKNOWN;
    private final RDXVRHeadset headset = new RDXVRHeadset(this.vrPlayAreaYUpZBackFrame);
    private final SideDependentList<RDXVRController> controllers = new SideDependentList((Object)new RDXVRController(RobotSide.LEFT, this.vrPlayAreaYUpZBackFrame), (Object)new RDXVRController(RobotSide.RIGHT, this.vrPlayAreaYUpZBackFrame));
    private final Map<Integer, RDXVRBaseStation> baseStations = new HashMap<Integer, RDXVRBaseStation>();
    private final Map<String, RDXVRTracker> trackers = new HashMap<String, RDXVRTracker>();

    public void initSystem() {
        LogTools.info((String)"Initializing");
        this.event = VREvent.create();
        this.trackedDevicePoses = TrackedDevicePose.create((int)64);
        this.trackedDeviceGamePoses = TrackedDevicePose.create((int)64);
        int token = VR.VR_InitInternal((IntBuffer)this.errorPointer, (int)1);
        this.checkInitError(this.errorPointer);
        OpenVR.create((int)token);
        VR.VR_GetGenericInterface((CharSequence)"IVRCompositor_027", (IntBuffer)this.errorPointer);
        this.checkInitError(this.errorPointer);
        VR.VR_GetGenericInterface((CharSequence)"IVRRenderModels_006", (IntBuffer)this.errorPointer);
        this.checkInitError(this.errorPointer);
        VRSystem.VRSystem_GetRecommendedRenderTargetSize((IntBuffer)this.widthPointer, (IntBuffer)this.heightPointer);
        float renderTargetMultiplier = 1.0f;
        this.width = (int)((float)this.widthPointer.get(0) * renderTargetMultiplier);
        this.height = (int)((float)this.heightPointer.get(0) * renderTargetMultiplier);
        WorkspaceResourceDirectory directory = new WorkspaceResourceDirectory(this.getClass(), "/vr");
        WorkspaceResourceFile actionManifestFile = new WorkspaceResourceFile(directory, "actions.json");
        JSONFileTools.load((WorkspaceResourceFile)actionManifestFile, node -> JSONTools.forEachArrayElement((JsonNode)node, (String)"default_bindings", objectNode -> {
            String controllerBindings = objectNode.get("binding_url").asText();
            this.controllerModel = controllerBindings.contains("focus3") ? RDXVRControllerModel.FOCUS3 : RDXVRControllerModel.INDEX;
        }));
        LogTools.info((String)"Using VR controller model: {}", (Object)((Object)this.controllerModel));
        VRInput.VRInput_SetActionManifestPath((CharSequence)actionManifestFile.getFilesystemFile().toString());
        VRInput.VRInput_GetActionSetHandle((CharSequence)"/actions/main", (LongBuffer)this.mainActionSetHandle);
        this.headset.initSystem();
        for (RobotSide side : RobotSide.values) {
            ((RDXVRController)this.controllers.get((Enum)side)).initSystem();
        }
        int[] deviceIndices = new int[TRACKER_SERIAL_MAP.size()];
        IntBuffer trackerIndices = IntBuffer.wrap(deviceIndices);
        int numberOfTrackers = VRSystem.VRSystem_GetSortedTrackedDeviceIndicesOfClass((int)3, (IntBuffer)trackerIndices, (int)-1);
        for (int i = 0; i < numberOfTrackers; ++i) {
            int deviceIndex = trackerIndices.get(i);
            if (this.trackers.containsKey(this.getTrackedBodySegment(this.getSerialNumber(deviceIndex)))) continue;
            this.trackers.put(this.getTrackedBodySegment(this.getSerialNumber(deviceIndex)), new RDXVRTracker(this.vrPlayAreaYUpZBackFrame, deviceIndex));
        }
        this.activeActionSets = VRActiveActionSet.create((int)1);
        this.activeActionSets.ulActionSet(this.mainActionSetHandle.get(0));
        this.activeActionSets.ulRestrictedToDevice(0L);
    }

    public void setupEyes() {
        LogTools.info((String)"VR per eye render size: {} x {}", (Object)this.width, (Object)this.height);
        for (RobotSide side : RobotSide.values) {
            this.eyes.set((Enum)side, (Object)new RDXVREye(side, this.headset, this.width, this.height));
        }
    }

    private void checkInitError(IntBuffer errorBuffer) {
        if (errorBuffer.get(0) != 0) {
            int error = errorBuffer.get(0);
            throw new GdxRuntimeException("VR Initialization error: " + VR.VR_GetVRInitErrorAsEnglishDescription((int)error));
        }
    }

    public void waitGetPoses() {
        VRCompositor.VRCompositor_WaitGetPoses((TrackedDevicePose.Buffer)this.trackedDevicePoses, (TrackedDevicePose.Buffer)this.trackedDeviceGamePoses);
    }

    public void pollEvents() {
        VRInput.VRInput_UpdateActionState((VRActiveActionSet.Buffer)this.activeActionSets, (int)VRActiveActionSet.SIZEOF);
        this.headset.update(this.trackedDevicePoses);
        for (Object side : RobotSide.values) {
            ((RDXVRController)this.controllers.get((Enum)side)).update(this.trackedDevicePoses);
        }
        while (VRSystem.VRSystem_PollNextEvent((VREvent)this.event)) {
            int n;
            int deviceIndex = this.event.trackedDeviceIndex();
            if (this.trackers.containsKey(this.getTrackedBodySegment(this.getSerialNumber(deviceIndex))) || (n = VRSystem.VRSystem_GetTrackedDeviceClass((int)deviceIndex)) != 3) continue;
            this.trackers.put(this.getTrackedBodySegment(this.getSerialNumber(deviceIndex)), new RDXVRTracker(this.vrPlayAreaYUpZBackFrame, deviceIndex));
        }
        for (Map.Entry entry : this.trackers.entrySet()) {
            ((RDXVRTracker)entry.getValue()).update(this.trackedDevicePoses);
        }
        for (Consumer consumer : this.vrPickCalculators) {
            consumer.accept(this);
        }
        for (Object side : RobotSide.values) {
            ((RDXVRController)this.controllers.get((Enum)side)).updatePickResults();
        }
        for (Consumer consumer : this.vrInputProcessors) {
            consumer.accept(this);
        }
    }

    private String getSerialNumber(int index) {
        String serialNumber = VRSystem.VRSystem_GetStringTrackedDeviceProperty((int)index, (int)1002, null);
        return serialNumber;
    }

    private String getTrackedBodySegment(String serialNumber) {
        return TRACKER_SERIAL_MAP.get(serialNumber);
    }

    public void renderEyes(RDX3DScene scene) {
        for (RobotSide side : RobotSide.values) {
            ((RDXVREye)((Object)this.eyes.get((Enum)side))).render(scene);
        }
        VRCompositor.VRCompositor_Submit((int)0, (Texture)((RDXVREye)((Object)this.eyes.get((Enum)RobotSide.LEFT))).getOpenVRTexture(), null, (int)0);
        VRCompositor.VRCompositor_Submit((int)1, (Texture)((RDXVREye)((Object)this.eyes.get((Enum)RobotSide.RIGHT))).getOpenVRTexture(), null, (int)0);
        GL41.glFlush();
    }

    public void dispose() {
        for (RDXVREye eyeData : this.eyes) {
            eyeData.getFrameBuffer().dispose();
        }
        VR.VR_ShutdownInternal();
    }

    public void teleport(Consumer<RigidBodyTransform> teleportIHMCZUpToIHMCZUpWorldConsumer) {
        teleportIHMCZUpToIHMCZUpWorldConsumer.accept(this.teleportIHMCZUpToIHMCZUpWorld);
        this.teleportFrameIHMCZUp.update();
    }

    public void addVRPickCalculator(Consumer<RDXVRContext> calculateVRPick) {
        this.vrPickCalculators.add(calculateVRPick);
    }

    public void addVRInputProcessor(Consumer<RDXVRContext> processVRInput) {
        this.vrInputProcessors.add(processVRInput);
    }

    public void addVRPickCalculator(Object ownerKey, Consumer<RDXVRContext> calculateVRPick) {
        this.vrPickCalculatorOwnerKeyMap.put(ownerKey, calculateVRPick);
        this.vrPickCalculators.add(calculateVRPick);
    }

    public void addVRInputProcessor(Object ownerKey, Consumer<RDXVRContext> processVRInput) {
        this.vrInputProcessorOwnerKeyMap.put(ownerKey, processVRInput);
        this.vrInputProcessors.add(processVRInput);
    }

    public void removeVRPickCalculator(Object ownerKey) {
        this.vrPickCalculators.remove(this.vrPickCalculatorOwnerKeyMap.remove(ownerKey));
    }

    public void removeVRInputProcessor(Object ownerKey) {
        this.vrInputProcessors.remove(this.vrInputProcessorOwnerKeyMap.remove(ownerKey));
    }

    public void getHeadsetRenderable(Array<Renderable> renderables, Pool<Renderable> pool) {
        ModelInstance modelInstance;
        if (this.headset.isConnected() && (modelInstance = this.headset.getModelInstance()) != null) {
            modelInstance.getRenderables(renderables, pool);
        }
    }

    public void getControllerRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        for (RobotSide side : RobotSide.values) {
            RDXVRController controller = (RDXVRController)this.controllers.get((Enum)side);
            if (!controller.isConnected()) continue;
            controller.getRenderables(renderables, pool);
        }
    }

    public void getTrackerRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        for (RDXVRTracker tracker : this.trackers.values()) {
            ModelInstance modelInstance = tracker.getModelInstance();
            if (modelInstance == null) continue;
            modelInstance.getRenderables(renderables, pool);
        }
    }

    public void getBaseStationRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        for (RDXVRBaseStation baseStation : this.baseStations.values()) {
            ModelInstance modelInstance = baseStation.getModelInstance();
            if (modelInstance == null) continue;
            modelInstance.getRenderables(renderables, pool);
        }
    }

    public RDXVRController getController(RobotSide side) {
        return (RDXVRController)this.controllers.get((Enum)side);
    }

    public RDXVRHeadset getHeadset() {
        return this.headset;
    }

    public RDXVRTracker getTracker(String bodySegment) {
        return this.trackers.get(bodySegment);
    }

    public Set<String> getBodySegmentsWithTrackers() {
        return this.trackers.keySet();
    }

    public Collection<RDXVRBaseStation> getBaseStations() {
        return this.baseStations.values();
    }

    public SideDependentList<RDXVREye> getEyes() {
        return this.eyes;
    }

    public ReferenceFrame getOpenVRPlayAreaYUpFrame() {
        return this.vrPlayAreaYUpZBackFrame;
    }

    public ReferenceFrame getTeleportFrameIHMCZUp() {
        return this.teleportFrameIHMCZUp;
    }

    public RigidBodyTransform getTeleportIHMCZUpToIHMCZUpWorld() {
        return this.teleportIHMCZUpToIHMCZUpWorld;
    }

    public RDXVRControllerModel getControllerModel() {
        return this.controllerModel;
    }
}

