/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.visualizers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.RDXModelBuilder;
import us.ihmc.rdx.visualizers.RDXSplineBody;

public class RDXSplineGraphic
implements RenderableProvider {
    private static final float sphereRadius = 0.02f;
    private static final float lineWidth = 0.01f;
    private final RDXSplineBody line = new RDXSplineBody(0.01f);
    private ModelInstance sphereStartPoint;
    private ModelInstance sphereEndPoint;
    private boolean cleared = true;
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private Point3DReadOnly lastPoint;

    public void createStart(Point3DReadOnly point, Color color) {
        this.sphereStartPoint = RDXModelBuilder.createSphere(0.02f, color);
        Pose3D pose = new Pose3D(point.getX(), point.getY(), point.getZ(), 0.0, 0.0, 0.0);
        LibGDXTools.toLibGDX((Pose3DReadOnly)pose, this.tempTransform, this.sphereStartPoint.transform);
        this.cleared = false;
        this.lastPoint = point;
    }

    public void createEnd(Color color) {
        this.sphereEndPoint = RDXModelBuilder.createSphere(0.02f, color);
        Pose3D pose = new Pose3D(this.lastPoint.getX(), this.lastPoint.getY(), this.lastPoint.getZ(), 0.0, 0.0, 0.0);
        LibGDXTools.toLibGDX((Pose3DReadOnly)pose, this.tempTransform, this.sphereEndPoint.transform);
    }

    public void createAdditionalPoint(Point3DReadOnly point, Color color) {
        this.line.setColor(color);
        this.line.generateMeshes(this.lastPoint, point);
        this.lastPoint = point;
    }

    public void clear() {
        this.cleared = true;
        this.line.clear();
        this.sphereEndPoint = null;
        this.lastPoint = null;
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (!this.cleared) {
            this.sphereStartPoint.getRenderables(renderables, pool);
            this.line.getRenderables(renderables, pool);
            if (this.sphereEndPoint != null) {
                this.sphereEndPoint.getRenderables(renderables, pool);
            }
        }
    }
}

