/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.tools;

import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.model.data.ModelData;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMesh;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMeshPart;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNode;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodePart;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.util.ArrayList;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.RDXModelLoader;
import us.ihmc.robotics.referenceFrames.MutableReferenceFrame;

public class RDXModelInstanceScaler {
    private final ModelData modelData;
    private final Point3D32 wholeModelCentroid;
    private final ArrayList<PartRecord> partRecords = new ArrayList();
    private ModelInstance modelInstance;
    private final FramePoint3D scaledVertex = new FramePoint3D();
    private final Vector3D32 centroidToVertex = new Vector3D32();
    private final MutableReferenceFrame centroidFrame = new MutableReferenceFrame(ReferenceFrame.getWorldFrame());
    private final Stopwatch stopwatch = new Stopwatch();

    public RDXModelInstanceScaler(String modelFileName) {
        this(RDXModelLoader.loadModelData(modelFileName));
    }

    public RDXModelInstanceScaler(ModelData modelData) {
        this.modelData = modelData;
        this.stopwatch.start();
        this.wholeModelCentroid = new Point3D32();
        int totalNumberOfVertices = 0;
        for (int nodeIndex = 0; nodeIndex < modelData.nodes.size; ++nodeIndex) {
            ModelNode node = (ModelNode)modelData.nodes.get(nodeIndex);
            if (node.parts == null) continue;
            for (ModelNodePart part : node.parts) {
                String meshPartId = part.meshPartId;
                ModelMeshPart modelMeshPart = LibGDXTools.findModelMeshPart(modelData, meshPartId);
                ModelMesh modelMesh = LibGDXTools.findMeshContainingPart(modelData, meshPartId);
                int floatsPerVertex = LibGDXTools.calculateFloatsPerVertex(modelMesh);
                int numberOfVertices = modelMeshPart.indices.length;
                totalNumberOfVertices += numberOfVertices;
                RigidBodyTransform transform = new RigidBodyTransform();
                Quaternion quaternion = new Quaternion();
                if (node.translation != null) {
                    LibGDXTools.toEuclid(node.translation, transform.getTranslation());
                }
                if (node.rotation != null) {
                    LibGDXTools.toEuclid(node.rotation, quaternion);
                }
                transform.getRotation().set((Orientation3DReadOnly)quaternion);
                ArrayList<OriginalVertexRecord> originalPartVertices = new ArrayList<OriginalVertexRecord>();
                for (short index : modelMeshPart.indices) {
                    Point3D32 originalVertex = new Point3D32(modelMesh.vertices[floatsPerVertex * index], modelMesh.vertices[floatsPerVertex * index + 1], modelMesh.vertices[floatsPerVertex * index + 2]);
                    transform.transform((Point3DBasics)originalVertex);
                    originalPartVertices.add(new OriginalVertexRecord(originalVertex, index));
                    this.wholeModelCentroid.add((Tuple3DReadOnly)originalVertex);
                }
                this.partRecords.add(new PartRecord(modelMeshPart, modelMesh, transform, floatsPerVertex, numberOfVertices, originalPartVertices));
            }
        }
        if (this.stopwatch.totalElapsed() > 0.5) {
            LogTools.warn((String)"Took {} s to initialize, which is a little long.", (Object)this.stopwatch.lapElapsed());
        }
        this.wholeModelCentroid.scale(1.0 / (double)totalNumberOfVertices);
        this.centroidFrame.update(transformToParent -> transformToParent.getTranslation().set((Tuple3DReadOnly)this.wholeModelCentroid));
    }

    public void scale(double scaleFactor) {
        Model model = this.scaleForModel(scaleFactor);
        this.modelInstance = new ModelInstance(model);
    }

    public Model scaleForModel(double scaleFactor) {
        this.stopwatch.start();
        float scaleFactorFloat = (float)scaleFactor;
        for (PartRecord partRecord : this.partRecords) {
            for (int i = 0; i < partRecord.numberOfVertices(); ++i) {
                OriginalVertexRecord originalVertexRecord = partRecord.originalVertices().get(i);
                this.centroidToVertex.set((Tuple3DReadOnly)originalVertexRecord.originalVertex());
                this.centroidToVertex.sub((Tuple3DReadOnly)this.wholeModelCentroid);
                this.centroidToVertex.scale((double)scaleFactorFloat);
                this.scaledVertex.setIncludingFrame(this.centroidFrame.getReferenceFrame(), (Tuple3DReadOnly)this.centroidToVertex);
                this.scaledVertex.changeFrame(ReferenceFrame.getWorldFrame());
                partRecord.transform().inverseTransform((Point3DBasics)this.scaledVertex);
                LibGDXTools.setFloatVertexPosition(partRecord.modelMesh().vertices, partRecord.floatsPerVertex(), originalVertexRecord.index(), (Tuple3DReadOnly)this.scaledVertex);
            }
        }
        Model model = new Model(this.modelData);
        if (this.stopwatch.totalElapsed() > 0.1) {
            LogTools.warn((String)"Took {} s to scale, which is a little long.", (Object)this.stopwatch.lapElapsed());
        }
        return model;
    }

    public Point3D32 getWholeModelCentroid() {
        return this.wholeModelCentroid;
    }

    public Matrix4 getPoseTransform() {
        return this.modelInstance.transform;
    }

    public ModelInstance getModelInstance() {
        return this.modelInstance;
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        this.modelInstance.getRenderables(renderables, pool);
    }

    private record OriginalVertexRecord(Point3D32 originalVertex, short index) {
    }

    private record PartRecord(ModelMeshPart modelMeshPart, ModelMesh modelMesh, RigidBodyTransform transform, int floatsPerVertex, int numberOfVertices, ArrayList<OriginalVertexRecord> originalVertices) {
    }
}

