/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.tools;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import java.util.List;
import java.util.function.Consumer;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.rdx.mesh.RDXMultiColorMeshBuilder;

public class RDXModelBuilder {
    public static ModelInstance createCoordinateFrameInstance(double length) {
        return new ModelInstance(RDXModelBuilder.createCoordinateFrame(length));
    }

    public static ModelInstance createCoordinateFrameInstance(double length, Color color) {
        return new ModelInstance(RDXModelBuilder.createCoordinateFrame(length, color));
    }

    public static ModelInstance buildModelInstance(Consumer<RDXMultiColorMeshBuilder> buildModel, String nodeName) {
        return new ModelInstance(RDXModelBuilder.buildModel(buildModel, nodeName));
    }

    public static ModelInstance buildModelInstance(Consumer<RDXMultiColorMeshBuilder> buildModel) {
        return new ModelInstance(RDXModelBuilder.buildModel(buildModel));
    }

    public static Model buildModel(Consumer<RDXMultiColorMeshBuilder> buildModel) {
        return RDXModelBuilder.buildModel(buildModel, null);
    }

    public static Model buildModel(Consumer<RDXMultiColorMeshBuilder> buildModel, String nodeName) {
        RDXMultiColorMeshBuilder meshBuilder = new RDXMultiColorMeshBuilder();
        buildModel.accept(meshBuilder);
        return RDXModelBuilder.buildModelFromMesh(meshBuilder, nodeName);
    }

    public static Model buildModelFromMesh(RDXMultiColorMeshBuilder meshBuilder) {
        return RDXModelBuilder.buildModelFromMesh(meshBuilder, null);
    }

    public static Model buildModelFromMesh(RDXMultiColorMeshBuilder meshBuilder, String nodeName) {
        ModelBuilder modelBuilder = new ModelBuilder();
        return RDXModelBuilder.buildModelFromMesh(modelBuilder, meshBuilder);
    }

    public static Model buildModelFromMesh(ModelBuilder modelBuilder, RDXMultiColorMeshBuilder meshBuilder) {
        modelBuilder.begin();
        Mesh mesh = meshBuilder.generateMesh();
        MeshPart meshPart = new MeshPart("xyz", mesh, 0, mesh.getNumIndices(), 4);
        Material material = new Material();
        Texture paletteTexture = RDXMultiColorMeshBuilder.loadPaletteTexture();
        material.set((Attribute)TextureAttribute.createDiffuse((Texture)paletteTexture));
        material.set((Attribute)ColorAttribute.createDiffuse((Color)Color.WHITE));
        modelBuilder.part(meshPart, material);
        return modelBuilder.end();
    }

    public static void rebuildMesh(Node node, Consumer<RDXMultiColorMeshBuilder> buildModel) {
        NodePart oldNodePart = (NodePart)node.parts.removeIndex(0);
        oldNodePart.meshPart.mesh.dispose();
        RDXMultiColorMeshBuilder meshBuilder = new RDXMultiColorMeshBuilder();
        buildModel.accept(meshBuilder);
        Mesh mesh = meshBuilder.generateMesh();
        MeshPart meshPart = new MeshPart("xyz", mesh, 0, mesh.getNumIndices(), 4);
        Material material = new Material();
        Texture paletteTexture = RDXMultiColorMeshBuilder.loadPaletteTexture();
        material.set((Attribute)TextureAttribute.createDiffuse((Texture)paletteTexture));
        material.set((Attribute)ColorAttribute.createDiffuse((Color)Color.WHITE));
        node.parts.add((Object)new NodePart(meshPart, material));
    }

    public static Model createCoordinateFrame(double length) {
        return RDXModelBuilder.buildModel(meshBuilder -> {
            double radius = 0.02 * length;
            double coneHeight = 0.1 * length;
            double coneRadius = 0.05 * length;
            meshBuilder.addCylinder(length, radius, (Tuple3DReadOnly)new Point3D(), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), Color.RED);
            meshBuilder.addCone(coneHeight, coneRadius, (Tuple3DReadOnly)new Point3D(length, 0.0, 0.0), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), Color.RED);
            meshBuilder.addCylinder(length, radius, (Tuple3DReadOnly)new Point3D(), (Orientation3DReadOnly)new AxisAngle(1.0, 0.0, 0.0, -1.5707963267948966), Color.GREEN);
            meshBuilder.addCone(coneHeight, coneRadius, (Tuple3DReadOnly)new Point3D(0.0, length, 0.0), (Orientation3DReadOnly)new AxisAngle(1.0, 0.0, 0.0, -1.5707963267948966), Color.GREEN);
            meshBuilder.addCylinder(length, radius, (Tuple3DReadOnly)new Point3D(), (Orientation3DReadOnly)new AxisAngle(), Color.BLUE);
            meshBuilder.addCone(coneHeight, coneRadius, (Tuple3DReadOnly)new Point3D(0.0, 0.0, length), (Orientation3DReadOnly)new AxisAngle(), Color.BLUE);
        }, "coordinateFrame");
    }

    public static Model createCoordinateFrame(double length, Color color) {
        return RDXModelBuilder.buildModel(meshBuilder -> {
            double radius = 0.02 * length;
            double coneHeight = 0.1 * length;
            double coneRadius = 0.05 * length;
            meshBuilder.addCylinder(length, radius, (Tuple3DReadOnly)new Point3D(), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), color);
            meshBuilder.addCone(coneHeight, coneRadius, (Tuple3DReadOnly)new Point3D(length, 0.0, 0.0), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), Color.RED);
            meshBuilder.addCylinder(length, radius, (Tuple3DReadOnly)new Point3D(), (Orientation3DReadOnly)new AxisAngle(1.0, 0.0, 0.0, -1.5707963267948966), color);
            meshBuilder.addCone(coneHeight, coneRadius, (Tuple3DReadOnly)new Point3D(0.0, length, 0.0), (Orientation3DReadOnly)new AxisAngle(1.0, 0.0, 0.0, -1.5707963267948966), Color.GREEN);
            meshBuilder.addCylinder(length, radius, (Tuple3DReadOnly)new Point3D(), (Orientation3DReadOnly)new AxisAngle(), color);
            meshBuilder.addCone(coneHeight, coneRadius, (Tuple3DReadOnly)new Point3D(0.0, 0.0, length), (Orientation3DReadOnly)new AxisAngle(), Color.BLUE);
        }, "coordinateFrame");
    }

    public static ModelInstance createSphere(float radius, Color color) {
        return RDXModelBuilder.createSphere(radius, color, "sphere");
    }

    public static ModelInstance createSphere(float radius, Color color, String nodeName) {
        return RDXModelBuilder.buildModelInstance(meshBuilder -> meshBuilder.addSphere(radius, color), nodeName);
    }

    public static ModelInstance createBox(float lx, float ly, float lz, Color color) {
        return RDXModelBuilder.buildModelInstance(meshBuilder -> meshBuilder.addBox(lx, ly, lz, color), "box");
    }

    public static ModelInstance createCylinder(float height, float radius, Color color) {
        return RDXModelBuilder.buildModelInstance(meshBuilder -> meshBuilder.addCylinder(height, radius, (Tuple3DReadOnly)new Point3D(), color), "cylinder");
    }

    public static ModelInstance createEllipsoid(float xRadius, float yRadius, float zRadius, Color color) {
        return RDXModelBuilder.buildModelInstance(meshBuilder -> meshBuilder.addEllipsoid(xRadius, yRadius, zRadius, (Tuple3DReadOnly)new Point3D(), color), "ellipsoid");
    }

    public static ModelInstance createPrism(float triangleWidth, float prismThickness, float triangleHeight, Color color) {
        return RDXModelBuilder.buildModelInstance(meshBuilder -> meshBuilder.addIsoscelesTriangularPrism(triangleWidth, triangleHeight, prismThickness, (Tuple3DReadOnly)new Point3D(), color), "prism");
    }

    public static ModelInstance createCone(float height, float radius, Color color) {
        return RDXModelBuilder.buildModelInstance(meshBuilder -> meshBuilder.addCone(height, radius, (Tuple3DReadOnly)new Point3D(), color), "cone");
    }

    public static ModelInstance createArrow(double length, Color color) {
        return RDXModelBuilder.buildModelInstance(meshBuilder -> {
            double coneHeight = 0.1 * length;
            double cylinderLength = length - coneHeight;
            double cylinderRadius = cylinderLength / 20.0;
            double coneRadius = 1.5 * cylinderRadius;
            meshBuilder.addCylinder(cylinderLength, cylinderRadius, (Tuple3DReadOnly)new Point3D(), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), color);
            meshBuilder.addCone(coneHeight, coneRadius, (Tuple3DReadOnly)new Point3D(cylinderLength, 0.0, 0.0), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), color);
        }, "arrow");
    }

    public static ModelInstance createLine(Point3DReadOnly start, Point3DReadOnly end, double lineWidth, Color color) {
        return RDXModelBuilder.buildModelInstance(meshBuilder -> meshBuilder.addLine((Tuple3DReadOnly)start, (Tuple3DReadOnly)end, lineWidth, color), "line");
    }

    public static ModelInstance createPose(double radius, Color color) {
        return RDXModelBuilder.buildModelInstance(meshBuilder -> {
            double cylinderLength = radius * 6.0;
            double cylinderRadius = cylinderLength / 20.0;
            double coneHeight = 0.1 * cylinderLength;
            double coneRadius = 1.5 * cylinderRadius;
            meshBuilder.addCylinder(cylinderLength, cylinderRadius, (Tuple3DReadOnly)new Point3D(), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), color);
            meshBuilder.addCone(coneHeight, coneRadius, (Tuple3DReadOnly)new Point3D(cylinderLength, 0.0, 0.0), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 1.5707963267948966), color);
            meshBuilder.addSphere((float)radius, color);
        }, "arrow");
    }

    public static ModelInstance createStairs(double width, double stepHeight, double stepWidth, int numberOfSteps, Color color) {
        return RDXModelBuilder.buildModelInstance(meshBuilder -> {
            int i;
            for (i = 1; i < numberOfSteps + 1; ++i) {
                meshBuilder.addBox(stepWidth, width, stepHeight * (double)i, (Tuple3DReadOnly)new Point3D(stepWidth * (double)i, 0.0, stepHeight * (double)i / 2.0), color);
            }
            for (i = 1; i < numberOfSteps + 1; ++i) {
                meshBuilder.addCylinder(1.0, 0.02f, (Tuple3DReadOnly)new Point3D(stepWidth * (double)i, -width * (double)0.45f, stepHeight * (double)i), Color.BROWN);
                meshBuilder.addCylinder(1.0, 0.02f, (Tuple3DReadOnly)new Point3D(stepWidth * (double)i, width * (double)0.45f, stepHeight * (double)i), Color.BROWN);
            }
            meshBuilder.addCylinder(EuclidCoreTools.norm((double)((double)numberOfSteps * stepWidth), (double)((double)numberOfSteps * stepHeight)), 0.03f, (Tuple3DReadOnly)new Point3D(0.0, -width * (double)0.45f, 1.0), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 0.7853981633974483), Color.DARK_GRAY);
            meshBuilder.addCylinder(EuclidCoreTools.norm((double)((double)numberOfSteps * stepWidth), (double)((double)numberOfSteps * stepHeight)), 0.03f, (Tuple3DReadOnly)new Point3D(0.0, width * (double)0.45f, 1.0), (Orientation3DReadOnly)new AxisAngle(0.0, 1.0, 0.0, 0.7853981633974483), Color.DARK_GRAY);
        }, "stairs");
    }

    public static ModelInstance createMultiLine(RigidBodyTransformReadOnly transformToWorld, Point2DReadOnly[] points, double lineWidth, Color color, boolean close) {
        return RDXModelBuilder.buildModelInstance(meshBuilder -> meshBuilder.addMultiLine(transformToWorld, points, lineWidth, color, close));
    }

    public static ModelInstance createPolygon(RigidBodyTransformReadOnly transformToWorld, ConvexPolygon2DReadOnly polygon, Color color) {
        return RDXModelBuilder.buildModelInstance(meshBuilder -> meshBuilder.addPolygon(transformToWorld, polygon, color));
    }

    public static ModelInstance createLinedPolygon(List<? extends Point3DReadOnly> points, double lineWidth, Color color, boolean close) {
        return RDXModelBuilder.buildModelInstance(meshBuilder -> {
            meshBuilder.addMultiLine(points, lineWidth, color, close);
            meshBuilder.addPolygon(points, color);
        });
    }

    public static ModelInstance createLinedPolygon(RigidBodyTransformReadOnly transformToWorld, List<? extends Point2DReadOnly> points, double lineWidth, Color color, boolean close) {
        return RDXModelBuilder.buildModelInstance(meshBuilder -> {
            meshBuilder.addMultiLine(transformToWorld, points, lineWidth, color, close);
            meshBuilder.addPolygon(transformToWorld, points, color);
        });
    }
}

