/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.sceneManager;

import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DirectionalLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.PointLightsAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalShadowLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.utils.BufferUtils;
import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImFloat;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL41;

public class RDX3DSceneTools {
    public static final float CLEAR_COLOR = 0.5019608f;
    public static final String TUNING_WINDOW_NAME = "Lighting";
    private static final ImBoolean ambientEnabled = new ImBoolean(true);
    private static final ImFloat ambientColor = new ImFloat(1.0f);
    private static final ImBoolean pointEnabled = new ImBoolean(true);
    private static final ImFloat pointColor = new ImFloat(1.0f);
    private static final ImFloat pointDistance = new ImFloat(10.0f);
    private static final ImFloat pointIntensity = new ImFloat(43.28f);
    private static final ImBoolean directionEnabled = new ImBoolean(false);
    private static final ImFloat directionColor = new ImFloat(0.025f);
    private static final ImFloat directionDistance = new ImFloat(20.0f);

    public static void glClearGray() {
        RDX3DSceneTools.glClearGray(0.5019608f);
    }

    public static void glClearGray(float color) {
        GL41.glClearColor((float)color, (float)color, (float)color, (float)1.0f);
        GL41.glClear((int)16640);
    }

    public static int getFramebufferID() {
        IntBuffer buffer = BufferUtils.newIntBuffer((int)1);
        GL41.glGetIntegerv((int)36006, (IntBuffer)buffer);
        return buffer.get();
    }

    public static Environment createDefaultEnvironment() {
        Environment environment = new Environment();
        float ambientColor = RDX3DSceneTools.ambientColor.get();
        if (ambientEnabled.get()) {
            environment.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, ambientColor, ambientColor, ambientColor, 1.0f));
        }
        float pointColor = RDX3DSceneTools.pointColor.get();
        float pointDistance = RDX3DSceneTools.pointDistance.get();
        float pointIntensity = RDX3DSceneTools.pointIntensity.get();
        if (pointEnabled.get()) {
            PointLightsAttribute pointLights = new PointLightsAttribute();
            pointLights.lights.add((Object)new PointLight().set(pointColor, pointColor, pointColor, pointDistance, pointDistance, pointDistance, pointIntensity));
            pointLights.lights.add((Object)new PointLight().set(pointColor, pointColor, pointColor, -pointDistance, pointDistance, pointDistance, pointIntensity));
            pointLights.lights.add((Object)new PointLight().set(pointColor, pointColor, pointColor, -pointDistance, -pointDistance, pointDistance, pointIntensity));
            pointLights.lights.add((Object)new PointLight().set(pointColor, pointColor, pointColor, pointDistance, -pointDistance, pointDistance, pointIntensity));
            environment.set((Attribute)pointLights);
        }
        float directionColor = RDX3DSceneTools.directionColor.get();
        float directionDistance = RDX3DSceneTools.directionDistance.get();
        if (directionEnabled.get()) {
            DirectionalLightsAttribute directionalLights = new DirectionalLightsAttribute();
            directionalLights.lights.add((Object)new DirectionalLight().set(directionColor, directionColor, directionColor, -directionDistance, -directionDistance, -directionDistance));
            directionalLights.lights.add((Object)new DirectionalLight().set(directionColor, directionColor, directionColor, directionDistance, -directionDistance, -directionDistance));
            directionalLights.lights.add((Object)new DirectionalLight().set(directionColor, directionColor, directionColor, directionDistance, directionDistance, -directionDistance));
            directionalLights.lights.add((Object)new DirectionalLight().set(directionColor, directionColor, directionColor, -directionDistance, directionDistance, -directionDistance));
            environment.set((Attribute)directionalLights);
        }
        return environment;
    }

    public static PointLight createPointLight(float x, float y, float z) {
        float pointColor = RDX3DSceneTools.pointColor.get();
        float pointIntensity = RDX3DSceneTools.pointIntensity.get();
        return new PointLight().set(pointColor, pointColor, pointColor, x, y, z, pointIntensity);
    }

    public static DirectionalLight createDirectionalLight(float x, float y, float z) {
        float directionColor = RDX3DSceneTools.directionColor.get();
        return new DirectionalLight().set(directionColor, directionColor, directionColor, x, y, z);
    }

    private static DirectionalShadowLight newShadowLight() {
        return new DirectionalShadowLight(1024, 1024, 30.0f, 30.0f, 1.0f, 100.0f);
    }

    public static void renderTuningSliders() {
        ImGui.checkbox((String)"Ambient enabled", (ImBoolean)ambientEnabled);
        ImGui.sliderFloat((String)"Ambient color", (float[])ambientColor.getData(), (float)0.0f, (float)1.0f);
        ImGui.checkbox((String)"Point enabled", (ImBoolean)pointEnabled);
        ImGui.sliderFloat((String)"Point color", (float[])pointColor.getData(), (float)0.0f, (float)1.0f);
        ImGui.sliderFloat((String)"Point distance", (float[])pointDistance.getData(), (float)0.0f, (float)500.0f);
        ImGui.sliderFloat((String)"Point intensity", (float[])pointIntensity.getData(), (float)0.0f, (float)500.0f);
        ImGui.checkbox((String)"Direction enabled", (ImBoolean)directionEnabled);
        ImGui.sliderFloat((String)"Direction color", (float[])directionColor.getData(), (float)0.0f, (float)1.0f);
        ImGui.sliderFloat((String)"Direction distance", (float[])directionDistance.getData(), (float)0.0f, (float)20.0f);
    }
}

