/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.sceneManager;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelBatch;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DirectionalLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.PointLightsAttribute;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.utils.ShaderProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.Pair;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.rdx.lighting.RDXDirectionalLight;
import us.ihmc.rdx.lighting.RDXPointLight;
import us.ihmc.rdx.lighting.RDXShadowManager;
import us.ihmc.rdx.sceneManager.RDX3DSceneTools;
import us.ihmc.rdx.sceneManager.RDXRenderableAdapter;
import us.ihmc.rdx.sceneManager.RDXRenderableProvider;
import us.ihmc.rdx.sceneManager.RDXSceneLevel;
import us.ihmc.rdx.simulation.DepthSensorShaderProvider;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.RDXModelBuilder;

public class RDX3DScene {
    private final HashSet<ModelInstance> modelInstances = new HashSet();
    private final Set<RDXRenderableAdapter> renderables = new HashSet<RDXRenderableAdapter>();
    private final Map<Object, RDXRenderableAdapter> renderableOwnerKeyMap = new HashMap<Object, RDXRenderableAdapter>();
    private TreeSet<RDXSceneLevel> sceneLevelsToRender;
    private float ambientLight = 0.4f;
    private boolean shadowsEnabled = false;
    private RDXShadowManager shadowManager;
    private ModelBatch shadowsDisabledModelBatch;
    private Environment shadowsDisabledEnvironment;
    private final PointLightsAttribute shadowsDisabledPointLights = new PointLightsAttribute();
    private final DirectionalLightsAttribute shadowsDisabledDirectionalLights = new DirectionalLightsAttribute();

    public void create() {
        this.create(RDXSceneLevel.MODEL, RDXSceneLevel.VIRTUAL);
    }

    public void create(RDXSceneLevel ... sceneLevelsToRender) {
        this.sceneLevelsToRender = new TreeSet();
        Collections.addAll(this.sceneLevelsToRender, sceneLevelsToRender);
        Pair<String, String> shaderStrings = LibGDXTools.loadCombinedShader(this.getClass().getName().replace(".", "/") + ".glsl");
        String vertexShader = (String)shaderStrings.getLeft();
        String fragmentShader = (String)shaderStrings.getRight();
        this.shadowsDisabledModelBatch = new ModelBatch(null, (ShaderProvider)new DepthSensorShaderProvider(vertexShader, fragmentShader), null);
        this.shadowsDisabledEnvironment = new Environment();
        this.shadowsDisabledEnvironment.set((Attribute)ColorAttribute.createAmbientLight((float)this.ambientLight, (float)this.ambientLight, (float)this.ambientLight, (float)1.0f));
        this.shadowsDisabledEnvironment.set((Attribute)this.shadowsDisabledPointLights);
        this.shadowsDisabledEnvironment.set((Attribute)this.shadowsDisabledDirectionalLights);
        this.shadowManager = new RDXShadowManager(2.0f, this.ambientLight);
    }

    public void preRender(Camera camera) {
        if (this.shadowsEnabled) {
            this.shadowManager.preRender(camera);
        } else {
            this.shadowsDisabledModelBatch.begin(camera);
        }
    }

    public void render() {
        if (this.shadowsEnabled) {
            this.renderInternal(this.shadowManager.getShadowSceneBatch(), RDXSceneLevel.MODEL.SINGLETON_SET);
        } else {
            this.renderInternal(this.shadowsDisabledModelBatch, this.sceneLevelsToRender);
        }
    }

    public void render(RDXSceneLevel exclusiveSceneLevel) {
        this.renderInternal(this.shadowsDisabledModelBatch, exclusiveSceneLevel.SINGLETON_SET);
    }

    public void render(Set<RDXSceneLevel> sceneLevels) {
        this.renderInternal(this.shadowsDisabledModelBatch, sceneLevels);
    }

    public void renderShadowMap(Camera camera, int x, int y) {
        if (this.shadowsEnabled) {
            for (RDXRenderableAdapter renderable : this.renderables) {
                renderable.setSceneLevelsToRender(RDXSceneLevel.MODEL.SINGLETON_SET);
            }
            this.shadowManager.renderShadows(camera, this.renderables, x, y);
        }
    }

    public void renderExternalBatch(ModelBatch batch, Set<RDXSceneLevel> sceneLevel) {
        this.renderInternal(batch, sceneLevel);
    }

    public void renderToCamera(Camera camera) {
        if (this.shadowsEnabled) {
            this.shadowManager.preRender(camera);
            this.renderInternal(this.shadowManager.getShadowSceneBatch(), RDXSceneLevel.MODEL.SINGLETON_SET);
        } else {
            this.shadowsDisabledModelBatch.begin(camera);
            this.renderInternal(this.shadowsDisabledModelBatch, this.sceneLevelsToRender);
        }
        this.postRender(camera, RDXSceneLevel.VIRTUAL.SINGLETON_SET);
    }

    private void renderInternal(ModelBatch modelBatch, Set<RDXSceneLevel> sceneLevelsToRender) {
        for (RDXRenderableAdapter renderable : this.renderables) {
            renderable.setSceneLevelsToRender(sceneLevelsToRender);
            if (this.shadowsEnabled) {
                modelBatch.render((RenderableProvider)renderable);
                continue;
            }
            modelBatch.render((RenderableProvider)renderable, this.shadowsDisabledEnvironment);
        }
    }

    public void postRender(Camera camera, Set<RDXSceneLevel> sceneLevels) {
        if (this.shadowsEnabled) {
            this.shadowManager.postRender();
        } else {
            this.shadowsDisabledModelBatch.end();
        }
        if (this.shadowsEnabled && sceneLevels.contains((Object)RDXSceneLevel.VIRTUAL)) {
            this.shadowsDisabledModelBatch.begin(camera);
            for (RDXRenderableAdapter renderable : this.renderables) {
                renderable.setSceneLevelsToRender(RDXSceneLevel.VIRTUAL.SINGLETON_SET);
                this.shadowsDisabledModelBatch.render((RenderableProvider)renderable);
            }
            this.shadowsDisabledModelBatch.end();
        }
    }

    public void dispose() {
        for (ModelInstance modelInstance : this.modelInstances) {
            ExceptionTools.handle(() -> ((Model)modelInstance.model).dispose(), (ExceptionHandler)DefaultExceptionHandler.PRINT_MESSAGE);
        }
        this.shadowManager.dispose();
        this.shadowsDisabledModelBatch.dispose();
    }

    public RDXRenderableAdapter addModelInstance(ModelInstance modelInstance) {
        return this.addModelInstance(modelInstance, RDXSceneLevel.MODEL);
    }

    public RDXRenderableAdapter addModelInstance(ModelInstance modelInstance, RDXSceneLevel sceneLevel) {
        this.modelInstances.add(modelInstance);
        return this.addRenderableProvider((RenderableProvider)modelInstance, sceneLevel);
    }

    public RDXRenderableAdapter addCoordinateFrame(double size) {
        return this.addModelInstance(RDXModelBuilder.createCoordinateFrameInstance(size), RDXSceneLevel.VIRTUAL);
    }

    public RDXRenderableAdapter addRenderableProvider(RenderableProvider renderableProvider) {
        return this.addRenderableProvider(renderableProvider, RDXSceneLevel.MODEL);
    }

    public RDXRenderableAdapter addRenderableProvider(RenderableProvider renderableProvider, RDXSceneLevel sceneLevel) {
        RDXRenderableAdapter renderableAdapter = new RDXRenderableAdapter(renderableProvider, sceneLevel);
        this.renderables.add(renderableAdapter);
        return renderableAdapter;
    }

    public RDXRenderableAdapter addRenderableProvider(RDXRenderableProvider renderableProvider) {
        RDXRenderableAdapter renderableAdapter = new RDXRenderableAdapter(renderableProvider);
        this.renderables.add(renderableAdapter);
        return renderableAdapter;
    }

    public void addRenderableProvider(Object ownerKey, RDXRenderableProvider renderableProvider) {
        RDXRenderableAdapter renderableAdapter = new RDXRenderableAdapter(renderableProvider);
        this.renderableOwnerKeyMap.put(ownerKey, renderableAdapter);
        this.renderables.add(renderableAdapter);
    }

    public void addRenderableProvider(Object ownerKey, RenderableProvider renderableProvider) {
        this.addRenderableProvider(ownerKey, renderableProvider, RDXSceneLevel.MODEL);
    }

    public void addRenderableProvider(Object ownerKey, RenderableProvider renderableProvider, RDXSceneLevel sceneLevel) {
        RDXRenderableAdapter renderableAdapter = new RDXRenderableAdapter(renderableProvider, sceneLevel);
        this.renderableOwnerKeyMap.put(ownerKey, renderableAdapter);
        this.renderables.add(renderableAdapter);
    }

    public void addRenderableAdapter(RDXRenderableAdapter renderableAdapter) {
        this.renderables.add(renderableAdapter);
    }

    public void removeRenderable(Object ownerKey) {
        this.renderables.remove(this.renderableOwnerKeyMap.remove(ownerKey));
    }

    public void removeRenderableAdapter(RDXRenderableAdapter renderableAdapter) {
        this.renderables.remove(renderableAdapter);
    }

    public void addDefaultLighting() {
        this.setAmbientLight(0.914f);
        RDXPointLight pointLight = new RDXPointLight();
        pointLight.getPosition().set(10.0, 10.0, 10.0);
        this.addPointLight(pointLight);
        pointLight = new RDXPointLight();
        pointLight.getPosition().set(10.0, -10.0, 10.0);
        this.addPointLight(pointLight);
        pointLight = new RDXPointLight();
        pointLight.getPosition().set(-10.0, 10.0, 10.0);
        this.addPointLight(pointLight);
        pointLight = new RDXPointLight();
        pointLight.getPosition().set(-10.0, -10.0, 10.0);
        this.addPointLight(pointLight);
    }

    public void clearLights() {
        this.shadowsDisabledPointLights.lights.clear();
        this.shadowsDisabledDirectionalLights.lights.clear();
        this.shadowManager.getPointLights().clear();
        this.shadowManager.getDirectionalLights().clear();
    }

    public void addPointLight(RDXPointLight pointLight) {
        PointLight pointLightAttribute = RDX3DSceneTools.createPointLight(pointLight.getPosition().getX32(), pointLight.getPosition().getY32(), pointLight.getPosition().getZ32());
        pointLight.setAttribute(pointLightAttribute);
        this.shadowsDisabledPointLights.lights.add((Object)pointLightAttribute);
        this.shadowManager.getPointLights().add(pointLight);
    }

    public void addDirectionalLight(RDXDirectionalLight directionalLight) {
        DirectionalLight directionalLightAttribute = RDX3DSceneTools.createDirectionalLight(directionalLight.getDirection().getX32(), directionalLight.getDirection().getY32(), directionalLight.getDirection().getZ32());
        directionalLight.setAttribute(directionalLightAttribute);
        this.shadowsDisabledDirectionalLights.lights.add((Object)directionalLightAttribute);
        this.shadowManager.getDirectionalLights().add(directionalLight);
    }

    public void removePointLight(RDXPointLight pointLight) {
        this.shadowsDisabledPointLights.lights.removeValue((Object)pointLight.getAttribute(), true);
        this.shadowManager.getPointLights().remove(pointLight);
    }

    public void removeDirectionalLight(RDXDirectionalLight directionalLight) {
        this.shadowsDisabledDirectionalLights.lights.removeValue((Object)directionalLight.getAttribute(), true);
        this.shadowManager.getDirectionalLights().remove(directionalLight);
    }

    public void setAmbientLight(float ambientLight) {
        this.ambientLight = ambientLight;
        this.shadowsDisabledEnvironment.set((Attribute)ColorAttribute.createAmbientLight((float)ambientLight, (float)ambientLight, (float)ambientLight, (float)1.0f));
        this.shadowManager.setAmbientLight(ambientLight);
    }

    public void setShadowsEnabled(boolean shadowsEnabled) {
        this.shadowsEnabled = shadowsEnabled;
    }

    public float getAmbientLight() {
        return this.ambientLight;
    }

    public RDXShadowManager getShadowManager() {
        return this.shadowManager;
    }

    public TreeSet<RDXSceneLevel> getSceneLevelsToRender() {
        return this.sceneLevelsToRender;
    }
}

