/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.sceneManager;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import java.util.ArrayList;
import us.ihmc.rdx.sceneManager.RDX2DSpriteDrawable;

public class RDX2DSprite
implements RDX2DSpriteDrawable {
    private final Sprite sprite;
    private final Texture texture;
    private double orientation;
    private boolean visible = true;
    private boolean flipX = false;
    private boolean flipY = false;

    public RDX2DSprite(String imageName) {
        this(new Texture(Gdx.files.internal(imageName), Pixmap.Format.RGBA8888, false));
    }

    public RDX2DSprite(Pixmap pixmap) {
        this(new Texture(pixmap));
    }

    public RDX2DSprite(Texture texture) {
        this.texture = texture;
        this.sprite = new Sprite(texture);
        this.orientation = 0.0;
    }

    @Override
    public void draw(SpriteBatch spriteBatch) {
        float x = this.sprite.getX();
        float y = this.sprite.getY();
        float originX = this.sprite.getWidth() / 2.0f;
        float originY = this.sprite.getHeight() / 2.0f;
        float width = this.sprite.getWidth();
        float height = this.sprite.getHeight();
        float scaleX = this.sprite.getScaleX();
        float scaleY = this.sprite.getScaleY();
        float rotation = (float)Math.toDegrees(this.orientation);
        int srcX = 0;
        int srcY = 0;
        int srcWidth = this.texture.getWidth();
        int srcHeight = this.texture.getHeight();
        spriteBatch.draw(this.sprite.getTexture(), x, y, originX, originY, width, height, scaleX, scaleY, rotation, srcX, srcY, srcWidth, srcHeight, this.flipX, this.flipY);
    }

    public void setX(double x) {
        this.sprite.setCenterX((float)x);
    }

    public void setY(double y) {
        this.sprite.setCenterY((float)y);
    }

    public void setHeightPreserveScale(double height) {
        int textureHeight = this.texture.getHeight();
        int textureWidth = this.texture.getWidth();
        float heightToWidthRatio = (float)textureHeight / (float)textureWidth;
        float newWidth = (float)height / heightToWidthRatio;
        float newHeight = (float)height;
        this.sprite.setSize(newWidth, newHeight);
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public void getSpriteRenderables(ArrayList<RDX2DSpriteDrawable> sprites) {
        if (this.visible) {
            sprites.add(this);
        }
    }

    public double getPositionX() {
        return (double)this.sprite.getX() + (double)this.sprite.getWidth() / 2.0;
    }

    public double getPositionY() {
        return (double)this.sprite.getY() + (double)this.sprite.getHeight() / 2.0;
    }

    public void setOrientation(double orientation) {
        this.orientation = orientation;
    }

    public double getOrientation() {
        return this.orientation;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public void hide() {
        this.visible = false;
    }

    public void show() {
        this.visible = true;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean getFlipX() {
        return this.flipX;
    }

    public void setFlipX(boolean flipX) {
        this.flipX = flipX;
    }

    public boolean getFlipY() {
        return this.flipY;
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }
}

