/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.input;

import imgui.ImGui;

public class ImGuiMouseDragData {
    private final int button;
    private boolean dragging = false;
    private boolean dragJustStarted = false;
    private float lastMousePositionX;
    private float lastMousePositionY;
    private float mouseDraggedX = 0.0f;
    private float mouseDraggedY = 0.0f;
    private Object objectBeingDragged = null;

    public ImGuiMouseDragData(int button) {
        this.button = button;
    }

    public void update() {
        boolean mouseUp = !ImGui.isMouseDown((int)this.button);
        float mousePositionX = ImGui.getMousePosX();
        float mousePositionY = ImGui.getMousePosY();
        float mouseDragDeltaX = mousePositionX - this.lastMousePositionX;
        float mouseDragDeltaY = mousePositionY - this.lastMousePositionY;
        if (mouseUp) {
            this.dragging = false;
            this.dragJustStarted = false;
        } else {
            this.dragJustStarted = !this.dragging;
            this.dragging = true;
            this.mouseDraggedX = mouseDragDeltaX;
            this.mouseDraggedY = mouseDragDeltaY;
        }
        if (mouseUp || this.dragJustStarted) {
            this.objectBeingDragged = null;
        }
        this.lastMousePositionX = mousePositionX;
        this.lastMousePositionY = mousePositionY;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean isBeingDragged(Object objectInQuestion) {
        return this.objectBeingDragged == objectInQuestion && this.dragging;
    }

    public boolean getDragJustStarted() {
        return this.dragJustStarted;
    }

    public float getMouseDraggedX() {
        return this.mouseDraggedX;
    }

    public float getMouseDraggedY() {
        return this.mouseDraggedY;
    }

    public void setObjectBeingDragged(Object objectBeingDragged) {
        this.objectBeingDragged = objectBeingDragged;
    }
}

