/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.utils.MeshBuilder;
import com.badlogic.gdx.graphics.g3d.utils.ModelBuilder;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import imgui.ImFont;
import imgui.ImGui;
import imgui.ImGuiIO;
import imgui.ImGuiPlatformIO;
import imgui.gl3.ImGuiImplGl3;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameLine3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.RDXModelBuilder;
import us.ihmc.rdx.vr.RDXVRContext;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.robotSide.RobotSide;

public class RDXSingleContext3DSituatedImGuiPanel
implements RenderableProvider {
    private final boolean ENABLE_EXPERIMENTAL_TRACKING = false;
    private final AtomicLong INDEX = new AtomicLong(0L);
    private ModelInstance modelInstance = null;
    private ImGuiImplGl3 imGuiGl3;
    private int panelWidth;
    private int panelHeight;
    private Runnable renderImGuiWidgets;
    private RDXVRContext vrContext;
    private FrameBuffer frameBuffer;
    private float mousePosX;
    private float mousePosY;
    private boolean leftMouseDown;
    private ImFont font;
    private final int metersToPixels = 1000;
    private final float pixelsToMeters = 0.001f;
    private final RigidBodyTransform transform = new RigidBodyTransform();
    private final RigidBodyTransform graphicsXRightYDownToCenterXThroughZUpTransform = new RigidBodyTransform();
    private PlanarRegion planarRegion;
    private final ReferenceFrame centerXThroughZUpFrame = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)("centerXThroughZUpFrame" + this.INDEX.getAndIncrement()), (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)this.transform);
    private final FramePose3D desiredPose = new FramePose3D();
    private final RigidBodyTransform desiredTransformToHeadset = new RigidBodyTransform();
    private final FramePose3D currentPose = new FramePose3D();
    private final ReferenceFrame graphicsXRightYDownFrame = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)("graphicsXRightYDownFrame" + this.INDEX.getAndIncrement()), (ReferenceFrame)this.centerXThroughZUpFrame, (RigidBodyTransformReadOnly)this.graphicsXRightYDownToCenterXThroughZUpTransform);
    private final FrameLine3D pickRay = new FrameLine3D();
    private final FramePoint3D pickIntersection = new FramePoint3D();
    private final Plane3D plane = new Plane3D();
    private ModelInstance centerFrameCoordinateFrame;
    private ModelInstance graphicsFrameCoordinateFrame;
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private final FramePose3D centerFrameCoordinateFramePose = new FramePose3D();
    private final FramePose3D graphicsFrameCoordinateFramePose = new FramePose3D();
    private final RigidBodyTransform gripOffsetTransform = new RigidBodyTransform();
    private boolean grippedLastTime = false;
    private final Stopwatch timerForFollowSpeed = new Stopwatch().start();

    public void create(int panelWidth, int panelHeight, Runnable renderImGuiWidgets, RDXVRContext vrContext) {
        this.panelWidth = panelWidth;
        this.panelHeight = panelHeight;
        this.renderImGuiWidgets = renderImGuiWidgets;
        this.vrContext = vrContext;
        ImGui.createContext();
        ImGuiIO io = ImGui.getIO();
        io.setIniFilename(null);
        io.setMouseDrawCursor(true);
        this.font = ImGuiTools.setupFonts(io);
        ImGui.styleColorsLight();
        this.imGuiGl3 = new ImGuiImplGl3();
        this.imGuiGl3.init();
        this.centerFrameCoordinateFrame = RDXModelBuilder.createCoordinateFrameInstance(0.3);
        this.graphicsFrameCoordinateFrame = RDXModelBuilder.createCoordinateFrameInstance(0.3);
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.begin();
        MeshBuilder meshBuilder = new MeshBuilder();
        meshBuilder.begin(27L, 4);
        float halfWidth = (float)panelWidth / 2.0f;
        float halfHeight = (float)panelHeight / 2.0f;
        Vector3 topLeftPosition = new Vector3(0.0f, halfWidth, halfHeight).scl(0.001f);
        Vector3 bottomLeftPosition = new Vector3(0.0f, halfWidth, -halfHeight).scl(0.001f);
        Vector3 bottomRightPosition = new Vector3(0.0f, -halfWidth, -halfHeight).scl(0.001f);
        Vector3 topRightPosition = new Vector3(0.0f, -halfWidth, halfHeight).scl(0.001f);
        Vector3 topLeftNormal = new Vector3(0.0f, 0.0f, 1.0f);
        Vector3 bottomLeftNormal = new Vector3(0.0f, 0.0f, 1.0f);
        Vector3 bottomRightNormal = new Vector3(0.0f, 0.0f, 1.0f);
        Vector3 topRightNormal = new Vector3(0.0f, 0.0f, 1.0f);
        Vector2 topLeftUV = new Vector2(0.0f, 1.0f);
        Vector2 bottomLeftUV = new Vector2(0.0f, 0.0f);
        Vector2 bottomRightUV = new Vector2(1.0f, 0.0f);
        Vector2 topRightUV = new Vector2(1.0f, 1.0f);
        meshBuilder.vertex(topLeftPosition, topLeftNormal, Color.WHITE, topLeftUV);
        meshBuilder.vertex(bottomLeftPosition, bottomLeftNormal, Color.WHITE, bottomLeftUV);
        meshBuilder.vertex(bottomRightPosition, bottomRightNormal, Color.WHITE, bottomRightUV);
        meshBuilder.vertex(topRightPosition, topRightNormal, Color.WHITE, topRightUV);
        meshBuilder.triangle((short)3, (short)0, (short)1);
        meshBuilder.triangle((short)1, (short)0, (short)3);
        meshBuilder.triangle((short)1, (short)2, (short)3);
        meshBuilder.triangle((short)3, (short)2, (short)1);
        Mesh mesh = meshBuilder.end();
        MeshPart meshPart = new MeshPart("xyz", mesh, 0, mesh.getNumIndices(), 4);
        Material material = new Material();
        GLFrameBuffer.FrameBufferBuilder frameBufferBuilder = new GLFrameBuffer.FrameBufferBuilder(this.panelWidth, this.panelHeight);
        frameBufferBuilder.addBasicColorTextureAttachment(Pixmap.Format.RGBA8888);
        this.frameBuffer = frameBufferBuilder.build();
        Texture colorBufferTexture = (Texture)this.frameBuffer.getColorBufferTexture();
        material.set((Attribute)TextureAttribute.createDiffuse((Texture)colorBufferTexture));
        material.set((Attribute)ColorAttribute.createDiffuse((Color)Color.WHITE));
        modelBuilder.part(meshPart, material);
        Model model = modelBuilder.end();
        this.modelInstance = new ModelInstance(model);
        this.graphicsXRightYDownToCenterXThroughZUpTransform.appendYawRotation(-Math.toRadians(90.0));
        this.graphicsXRightYDownToCenterXThroughZUpTransform.appendPitchRotation(Math.toRadians(0.0));
        this.graphicsXRightYDownToCenterXThroughZUpTransform.appendRollRotation(-Math.toRadians(90.0));
        this.graphicsXRightYDownToCenterXThroughZUpTransform.appendTranslation((double)(-halfWidth * 0.001f), (double)(-halfHeight * 0.001f), 0.0);
        this.graphicsXRightYDownFrame.update();
        this.plane.getNormal().set((UnitVector3DReadOnly)Axis3D.X);
        this.updateDesiredPose(transform -> transform.getTranslation().set(1.0, 0.0, 1.0));
    }

    public void processVRInput(RDXVRContext vrContext) {
        vrContext.getController(RobotSide.RIGHT).runIfConnected(controller -> {
            this.pickRay.setToZero(controller.getXForwardZUpControllerFrame());
            this.pickRay.getDirection().set((UnitVector3DReadOnly)Axis3D.X);
            this.pickRay.changeFrame(ReferenceFrame.getWorldFrame());
            this.pickIntersection.setToZero(ReferenceFrame.getWorldFrame());
            this.plane.intersectionWith((Line3DReadOnly)this.pickRay, (Point3DBasics)this.pickIntersection);
            this.pickIntersection.changeFrame(this.graphicsXRightYDownFrame);
            float scaledX = Math.round((float)this.pickIntersection.getX() * 1000.0f);
            float scaledY = Math.round((float)this.pickIntersection.getY() * 1000.0f);
            if (scaledX > 0.0f && scaledX < (float)this.panelWidth && scaledY > 0.0f && scaledY < (float)this.panelHeight) {
                this.mousePosX = scaledX;
                this.mousePosY = scaledY;
                this.leftMouseDown = controller.getClickTriggerActionData().bState();
            } else {
                this.leftMouseDown = false;
            }
            if ((this.grippedLastTime || controller.getXForwardZUpPose().getPosition().distance((Point3DReadOnly)this.centerFrameCoordinateFramePose.getPosition()) < 0.05) && (double)controller.getGripActionData().x() > 0.9) {
                if (!this.grippedLastTime) {
                    this.centerFrameCoordinateFramePose.changeFrame(controller.getXForwardZUpControllerFrame());
                    this.centerFrameCoordinateFramePose.get((RigidBodyTransformBasics)this.gripOffsetTransform);
                    this.centerFrameCoordinateFramePose.changeFrame(ReferenceFrame.getWorldFrame());
                }
                this.updateDesiredPose(transform -> {
                    transform.set(this.gripOffsetTransform);
                    controller.getXForwardZUpControllerFrame().getTransformToWorldFrame().transform((RigidBodyTransformBasics)transform);
                });
                this.grippedLastTime = true;
            } else {
                this.grippedLastTime = false;
            }
            if (controller.getAButtonActionData().bChanged() && !controller.getAButtonActionData().bState()) {
                this.updateDesiredPose(transform -> {
                    this.desiredPose.setToZero(vrContext.getHeadset().getXForwardZUpHeadsetFrame());
                    this.desiredPose.getPosition().set(1.0, 0.0, 0.0);
                    this.desiredPose.changeFrame(ReferenceFrame.getWorldFrame());
                    this.desiredPose.get((RigidBodyTransformBasics)transform);
                });
            }
        });
        this.currentPose.setToZero(this.centerXThroughZUpFrame);
        this.currentPose.changeFrame(ReferenceFrame.getWorldFrame());
        this.desiredPose.setToZero(vrContext.getHeadset().getXForwardZUpHeadsetFrame());
        this.desiredPose.set((RigidBodyTransformReadOnly)this.desiredTransformToHeadset);
        this.desiredPose.changeFrame(ReferenceFrame.getWorldFrame());
        this.updateCurrentPose(transform -> {});
    }

    public void render() {
        ImGuiIO io = ImGui.getIO();
        io.setDisplaySize((float)this.panelWidth, (float)this.panelHeight);
        io.setDisplayFramebufferScale(1.0f, 1.0f);
        io.setMousePos(this.mousePosX, this.mousePosY);
        io.setMouseDown(0, this.leftMouseDown);
        ImGuiPlatformIO platformIO = ImGui.getPlatformIO();
        platformIO.resizeMonitors(0);
        platformIO.pushMonitors(0.0f, 0.0f, (float)this.panelWidth, (float)this.panelHeight, 0.0f, 0.0f, (float)this.panelWidth, (float)this.panelHeight, 1.0f);
        float deltaTime = Gdx.app.getGraphics().getDeltaTime();
        io.setDeltaTime(deltaTime > 0.0f ? deltaTime : 0.016666668f);
        ImGui.newFrame();
        ImGui.pushFont((ImFont)this.font);
        ImGui.setNextWindowPos((float)0.0f, (float)0.0f);
        ImGui.setNextWindowSize((float)this.panelWidth, (float)this.panelHeight);
        ImGui.begin((String)"Main Panel");
        this.renderImGuiWidgets.run();
        ImGui.end();
        ImGui.popFont();
        ImGui.render();
        this.frameBuffer.begin();
        ImGuiTools.glClearDarkGray();
        this.imGuiGl3.renderDrawData(ImGui.getDrawData());
        this.frameBuffer.end();
        this.centerFrameCoordinateFramePose.setToZero(this.centerXThroughZUpFrame);
        this.centerFrameCoordinateFramePose.changeFrame(ReferenceFrame.getWorldFrame());
        this.centerFrameCoordinateFramePose.get((RigidBodyTransformBasics)this.tempTransform);
        LibGDXTools.toLibGDX(this.tempTransform, this.centerFrameCoordinateFrame.transform);
        this.graphicsFrameCoordinateFramePose.setToZero(this.graphicsXRightYDownFrame);
        this.graphicsFrameCoordinateFramePose.changeFrame(ReferenceFrame.getWorldFrame());
        this.graphicsFrameCoordinateFramePose.get((RigidBodyTransformBasics)this.tempTransform);
        LibGDXTools.toLibGDX(this.tempTransform, this.graphicsFrameCoordinateFrame.transform);
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        this.modelInstance.getRenderables(renderables, pool);
    }

    public void updateDesiredPose(Consumer<RigidBodyTransform> transformUpdater) {
        this.updateCurrentPose(transformUpdater);
        this.desiredPose.setToZero(this.centerXThroughZUpFrame);
        this.desiredPose.changeFrame(this.vrContext.getHeadset().getXForwardZUpHeadsetFrame());
        this.desiredPose.get((RigidBodyTransformBasics)this.desiredTransformToHeadset);
    }

    private void updateCurrentPose(Consumer<RigidBodyTransform> transformUpdater) {
        this.transform.setToZero();
        transformUpdater.accept(this.transform);
        this.plane.setToZero();
        this.plane.getNormal().set((UnitVector3DReadOnly)Axis3D.X);
        this.plane.applyTransform((Transform)this.transform);
        LibGDXTools.toLibGDX(this.transform, this.modelInstance.transform);
        this.centerXThroughZUpFrame.update();
        this.desiredPose.setToZero(this.centerXThroughZUpFrame);
        this.desiredPose.changeFrame(this.vrContext.getHeadset().getXForwardZUpHeadsetFrame());
    }

    public Plane3D getPlane() {
        return this.plane;
    }

    public void dispose() {
        this.frameBuffer.dispose();
    }
}

