/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import gnu.trove.map.hash.TIntObjectHashMap;
import imgui.ImFont;
import imgui.ImGui;
import imgui.ImGuiIO;
import imgui.ImGuiStyle;
import imgui.ImGuiViewport;
import imgui.gl3.ImGuiImplGl3;
import imgui.glfw.ImGuiImplGlfw;
import imgui.type.ImString;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.system.Callback;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.imgui.ImGuiPanelManager;
import us.ihmc.rdx.imgui.ImGuiPosition;
import us.ihmc.rdx.imgui.ImGuiSize;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.RDXDockspacePanel;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.ui.ImGuiConfigurationLocation;
import us.ihmc.rdx.ui.RDXImGuiLayoutManager;
import us.ihmc.tools.io.HybridResourceDirectory;
import us.ihmc.tools.io.HybridResourceFile;
import us.ihmc.tools.io.JSONFileTools;
import us.ihmc.tools.io.resources.ResourceTools;

public class RDXImGuiWindowAndDockSystem {
    public static final String IMGUI_SETTINGS_INI_FILE_NAME = "ImGuiSettings.ini";
    private final RDXImGuiLayoutManager layoutManager;
    private final ImGuiImplGlfw imGuiGlfw = new ImGuiImplGlfw();
    private final ImGuiImplGl3 imGuiGl3 = new ImGuiImplGl3();
    private long context;
    private String glslVersion;
    private long windowHandle;
    private int fontSizeLevel = 1;
    private ImFont imFont;
    private int dockspaceId;
    private final ImString newDockPanelName = new ImString("", 100);
    private final TreeSet<RDXDockspacePanel> dockPanelSet = new TreeSet<RDXDockspacePanel>(Comparator.comparing(RDXDockspacePanel::getName));
    private final TIntObjectHashMap<RDXDockspacePanel> dockIDMap = new TIntObjectHashMap();
    private final ImGuiPanelManager panelManager;
    private HybridResourceFile imGuiSettingsFile;
    private HybridResourceFile panelsFile;
    private Callback debugMessageCallback;
    private final ImGuiSize calculatedPrimaryWindowSize = new ImGuiSize(800, 600);
    private final ImGuiPosition primaryWindowContentAreaPosition = new ImGuiPosition(0, 0);

    public RDXImGuiWindowAndDockSystem(RDXImGuiLayoutManager layoutManager) {
        this.layoutManager = layoutManager;
        this.panelManager = new ImGuiPanelManager();
    }

    public void setDirectory(HybridResourceDirectory configurationDirectory) {
        this.imGuiSettingsFile = new HybridResourceFile(configurationDirectory, IMGUI_SETTINGS_INI_FILE_NAME);
        this.panelsFile = new HybridResourceFile(configurationDirectory, "ImGuiPanels.json");
    }

    public void create(long windowHandle) {
        this.windowHandle = windowHandle;
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        if (LibGDXTools.ENABLE_OPENGL_DEBUGGER) {
            GLFW.glfwWindowHint((int)139271, (int)1);
        }
        this.context = ImGuiTools.createContext();
        ImGuiTools.setCurrentContext(this.context);
        if (LibGDXTools.ENABLE_OPENGL_DEBUGGER) {
            this.debugMessageCallback = LibGDXTools.setupDebugMessageCallback(37190);
        }
        ImGuiIO io = ImGui.getIO();
        io.setIniFilename(null);
        io.addConfigFlags(64);
        io.addConfigFlags(1024);
        io.setConfigViewportsNoTaskBarIcon(true);
        io.setConfigWindowsMoveFromTitleBarOnly(true);
        io.setConfigViewportsNoDecoration(false);
        io.setConfigDockingTransparentPayload(false);
        ImGuiTools.initializeColorStyle();
        this.imFont = ImGuiTools.setupFonts(io, this.fontSizeLevel);
        ImGuiStyle style = ImGui.getStyle();
        style.setFrameBorderSize(1.0f);
        if (io.hasConfigFlags(1024)) {
            style.setWindowRounding(0.0f);
            style.setColor(2, ImGui.getColorU32((int)2, (float)1.0f));
        }
        this.imGuiGlfw.init(windowHandle, true);
        this.imGuiGl3.init(this.glslVersion);
    }

    public void beforeWindowManagement() {
        ImGuiTools.setCurrentContext(this.context);
        ImGuiTools.glClearDarkGray();
        this.imGuiGlfw.newFrame();
        ImGui.newFrame();
        this.layoutManager.loadInitialLayout();
        ImGui.pushFont((ImFont)this.imFont);
        int flags = 0;
        this.dockspaceId = ImGui.dockSpaceOverViewport((ImGuiViewport)ImGui.getMainViewport(), (int)(flags += 8));
        for (RDXDockspacePanel dockspacePanel : this.dockPanelSet) {
            dockspacePanel.renderPanel();
            this.dockIDMap.put(dockspacePanel.getDockspaceID(), (Object)dockspacePanel);
        }
        this.panelManager.renderPanels(this.dockIDMap);
    }

    public void renderMenuDockPanelItems() {
        ImGui.text((String)"New dock panel:");
        ImGui.sameLine();
        ImGui.pushItemWidth((float)90.0f);
        ImGui.inputText((String)"###newDockPanelName", (ImString)this.newDockPanelName, (int)262144);
        ImGui.popItemWidth();
        ImGui.sameLine();
        if (ImGui.button((String)"Create###createNewDockPanelButton") && !this.newDockPanelName.get().isEmpty()) {
            this.dockPanelSet.add(new RDXDockspacePanel(this.newDockPanelName.get()));
        }
        RDXDockspacePanel dockspacePanelToRemove = null;
        for (RDXDockspacePanel dockspacePanel : this.dockPanelSet) {
            dockspacePanel.renderMenuItem();
            ImGui.sameLine();
            if (!ImGui.button((String)("X###X" + dockspacePanel.getName()))) continue;
            dockspacePanelToRemove = dockspacePanel;
        }
        if (dockspacePanelToRemove != null) {
            this.dockPanelSet.remove(dockspacePanelToRemove);
        }
        ImGui.separator();
        this.panelManager.renderPanelMenu();
    }

    private void loadUserConfigurationWithDefaultFallback() {
        boolean loaded = this.loadConfiguration(ImGuiConfigurationLocation.USER_HOME);
        if (!loaded) {
            LogTools.info((String)"{} not found", (Object)this.imGuiSettingsFile.getExternalFile().toString());
            if (!this.loadConfiguration(ImGuiConfigurationLocation.VERSION_CONTROL)) {
                LogTools.warn((String)"No saved settings found");
            }
        }
    }

    public boolean loadConfiguration(ImGuiConfigurationLocation configurationLocation) {
        this.imGuiSettingsFile.setMode(configurationLocation.toHybridResourceMode());
        LogTools.info((String)"Loading ImGui settings from {}", (Object)this.imGuiSettingsFile.getLocationOfResourceForReading());
        boolean settingsSuccess = this.imGuiSettingsFile.getInputStream(inputStream -> {
            String settingsINIAsString = ResourceTools.readResourceToString((InputStream)inputStream);
            ImGuiTools.parsePrimaryWindowSizeFromSettingsINI(settingsINIAsString, this.calculatedPrimaryWindowSize);
            int widthFromINI = this.calculatedPrimaryWindowSize.getWidth();
            int heightFromINI = this.calculatedPrimaryWindowSize.getHeight();
            int menuBarHeight = (int)ImGui.getFrameHeight();
            this.calculatedPrimaryWindowSize.setWidth(widthFromINI);
            this.calculatedPrimaryWindowSize.setHeight(heightFromINI + menuBarHeight);
            ImGuiTools.parsePrimaryWindowPositionFromSettingsINI(settingsINIAsString, this.primaryWindowContentAreaPosition);
            int loadedX = this.primaryWindowContentAreaPosition.getX();
            int loadedY = this.primaryWindowContentAreaPosition.getY();
            this.primaryWindowContentAreaPosition.setX(loadedX);
            this.primaryWindowContentAreaPosition.setY(loadedY - menuBarHeight);
            ImGui.loadIniSettingsFromMemory((String)settingsINIAsString);
        });
        this.panelsFile.setMode(configurationLocation.toHybridResourceMode());
        LogTools.info((String)"Loading ImGui panels settings from {}", (Object)this.panelsFile.getLocationOfResourceForReading());
        boolean panelSettingsSuccess = this.panelsFile.getInputStream(inputStream -> JSONFileTools.load((InputStream)inputStream, this::loadPanelsJSON));
        return settingsSuccess && panelSettingsSuccess;
    }

    private void loadPanelsJSON(JsonNode jsonNode) {
        JsonNode dockspacePanelsNode = jsonNode.get("dockspacePanels");
        if (dockspacePanelsNode != null) {
            RDXDockspacePanel[] priorDockpanelSet = this.dockPanelSet.toArray(new RDXDockspacePanel[0]);
            this.dockPanelSet.clear();
            Iterator it = dockspacePanelsNode.fields();
            while (it.hasNext()) {
                Map.Entry dockspacePanelEntry = (Map.Entry)it.next();
                RDXDockspacePanel dockspacePanel = null;
                for (RDXDockspacePanel otherDockspacePanel : priorDockpanelSet) {
                    if (!otherDockspacePanel.getName().equals(dockspacePanelEntry.getKey())) continue;
                    dockspacePanel = otherDockspacePanel;
                }
                if (dockspacePanel == null) {
                    dockspacePanel = new RDXDockspacePanel((String)dockspacePanelEntry.getKey());
                }
                this.dockPanelSet.add(dockspacePanel);
                dockspacePanel.getIsShowing().set(((JsonNode)dockspacePanelEntry.getValue()).asBoolean());
            }
        }
        this.panelManager.loadConfiguration(jsonNode);
    }

    public void saveConfiguration(ImGuiConfigurationLocation saveConfigurationLocation) {
        this.imGuiSettingsFile.setMode(saveConfigurationLocation.toHybridResourceMode());
        Path saveFile = this.imGuiSettingsFile.getFileForWriting();
        String settingsPathString = saveFile.toString();
        LogTools.info((String)"Saving ImGui settings to {}", (Object)settingsPathString);
        FileTools.ensureDirectoryExists((Path)saveFile.getParent(), (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        ImGui.saveIniSettingsToDisk((String)settingsPathString);
        Consumer<ObjectNode> rootConsumer = root -> {
            ObjectNode anchorJSON = root.putObject("dockspacePanels");
            for (RDXDockspacePanel dockspacePanel : this.dockPanelSet) {
                anchorJSON.put(dockspacePanel.getName(), dockspacePanel.getIsShowing().get());
            }
            this.panelManager.saveConfiguration((ObjectNode)root);
        };
        this.panelsFile.setMode(saveConfigurationLocation.toHybridResourceMode());
        LogTools.info((String)"Saving ImGui panel settings to {}", (Object)this.panelsFile.getFileForWriting().toString());
        JSONFileTools.save((Path)this.panelsFile.getFileForWriting(), rootConsumer);
    }

    public void afterWindowManagement() {
        ImGui.popFont();
        ImGui.render();
        this.imGuiGl3.renderDrawData(ImGui.getDrawData());
        if (ImGui.getIO().hasConfigFlags(1024)) {
            long backupWindowPtr = GLFW.glfwGetCurrentContext();
            ImGui.updatePlatformWindows();
            ImGui.renderPlatformWindowsDefault();
            GLFW.glfwMakeContextCurrent((long)backupWindowPtr);
        }
    }

    public void dispose() {
        this.imGuiGl3.dispose();
        this.imGuiGlfw.dispose();
        ImGui.destroyContext();
        if (this.debugMessageCallback != null) {
            this.debugMessageCallback.free();
        }
    }

    public ImGuiImplGl3 getImGuiGl3() {
        return this.imGuiGl3;
    }

    public ImGuiPanelManager getPanelManager() {
        return this.panelManager;
    }

    public void setFontSizeLevel(int fontSizeLevel) {
        this.fontSizeLevel = fontSizeLevel;
    }

    public ImFont getImFont() {
        return this.imFont;
    }

    public ImGuiSize getCalculatedPrimaryWindowSize() {
        return this.calculatedPrimaryWindowSize;
    }

    public ImGuiPosition getPrimaryWindowContentAreaPosition() {
        return this.primaryWindowContentAreaPosition;
    }
}

