/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.extension.implot.ImPlot;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.rdx.imgui.ImPlotPlotLine;
import us.ihmc.rdx.imgui.ImPlotPlotLineSwapBuffer;
import us.ihmc.rdx.imgui.ImPlotTools;

public abstract class ImPlotWallTimeScrollingPlotLine
implements ImPlotPlotLine {
    private Runnable legendPopupImGuiRenderer;
    private final String variableNameBase;
    private final String variableNamePostfix;
    private final String variableName;
    private String labelID;
    private ImPlotPlotLineSwapBuffer swapBuffer;
    private double history = 3.0;
    private final Stopwatch stopwatch = new Stopwatch();
    private final int bufferSize;
    private double timeForOneBufferEntry;
    private long lastTickIndex = 0L;
    private long tickIndex = 0L;
    private final double[] xValues;
    private boolean isA = true;
    private int filledIndex = 0;

    public ImPlotWallTimeScrollingPlotLine(String variableName, String initialValueString, int bufferSize, double history) {
        this.variableName = variableName;
        this.bufferSize = bufferSize;
        this.timeForOneBufferEntry = history / (double)bufferSize;
        this.variableNameBase = variableName + " ";
        this.variableNamePostfix = "###" + variableName;
        this.labelID = this.variableNameBase + initialValueString + this.variableNamePostfix;
        this.xValues = ImPlotTools.createIndex(bufferSize);
    }

    public void setSwapBuffer(ImPlotPlotLineSwapBuffer swapBuffer) {
        this.swapBuffer = swapBuffer;
        swapBuffer.initialize(this.bufferSize);
    }

    public void addValue(String valueString) {
        int i;
        this.labelID = this.variableNameBase + valueString + this.variableNamePostfix;
        int numberOfTicksToAdvance = 0;
        double totalElapsed = this.stopwatch.totalElapsed();
        if (Double.isNaN(totalElapsed)) {
            this.stopwatch.start();
        } else {
            this.tickIndex = (long)(totalElapsed / this.timeForOneBufferEntry);
            numberOfTicksToAdvance = (int)(this.tickIndex - this.lastTickIndex);
            this.lastTickIndex = this.tickIndex;
        }
        int numberOfTicksToAdvanceBeforeFilling = Math.min(this.bufferSize, this.filledIndex + numberOfTicksToAdvance) - this.filledIndex;
        int numberOfTicksToAdvanceAfterFilling = Math.min(this.bufferSize, numberOfTicksToAdvance - numberOfTicksToAdvanceBeforeFilling);
        if (this.filledIndex < this.bufferSize) {
            if (numberOfTicksToAdvanceBeforeFilling == 0) {
                this.swapBuffer.setAValue(this.filledIndex);
            } else {
                for (i = 0; i < numberOfTicksToAdvanceBeforeFilling && this.filledIndex < this.bufferSize; ++i) {
                    ++this.filledIndex;
                    if (this.filledIndex >= this.bufferSize) continue;
                    this.swapBuffer.setAValue(this.filledIndex);
                }
                if (this.filledIndex == this.bufferSize) {
                    this.swapBuffer.copyAToB();
                }
            }
        }
        if (this.filledIndex == this.bufferSize) {
            if (numberOfTicksToAdvanceAfterFilling > 0) {
                this.swapBuffer.copyPreviousToUpdated(numberOfTicksToAdvanceAfterFilling, 0, this.bufferSize - numberOfTicksToAdvanceAfterFilling);
                this.isA = !this.isA;
                for (i = 0; i < numberOfTicksToAdvanceAfterFilling; ++i) {
                    this.swapBuffer.setUpdatedValue(this.bufferSize - 1 - i);
                }
            } else {
                this.swapBuffer.setPreviousValue(this.bufferSize - 1);
            }
        }
    }

    @Override
    public boolean render() {
        int offset = 0;
        this.swapBuffer.plot(this.labelID, this.xValues, offset);
        boolean showingLegendPopup = false;
        if (this.legendPopupImGuiRenderer != null && ImPlot.beginLegendPopup((String)this.labelID)) {
            showingLegendPopup = true;
            this.legendPopupImGuiRenderer.run();
            ImPlot.endLegendPopup();
        }
        return showingLegendPopup;
    }

    public void setLegendPopupImGuiRenderer(Runnable legendPopupImGuiRenderer) {
        this.legendPopupImGuiRenderer = legendPopupImGuiRenderer;
    }

    @Override
    public String getVariableName() {
        return this.variableName;
    }
}

