/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import com.badlogic.gdx.graphics.Color;
import imgui.ImFont;
import imgui.ImFontAtlas;
import imgui.ImFontConfig;
import imgui.ImFontGlyphRangesBuilder;
import imgui.ImGui;
import imgui.ImGuiIO;
import imgui.internal.ImGuiContext;
import imgui.type.ImDouble;
import imgui.type.ImFloat;
import imgui.type.ImInt;
import imgui.type.ImLong;
import imgui.type.ImString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.SystemUtils;
import org.lwjgl.opengl.GL41;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.rdx.imgui.ImGuiPosition;
import us.ihmc.rdx.imgui.ImGuiSize;
import us.ihmc.tools.string.StringTools;

public class ImGuiTools {
    private static final AtomicInteger GLOBAL_WIDGET_INDEX = new AtomicInteger();
    public static float TAB_BAR_HEIGHT = 20.0f;
    public static final int GDX_TO_IMGUI_KEY_CODE_OFFSET = 36;
    public static final float FLOAT_MIN = -1.7014117E38f;
    public static final float FLOAT_MAX = 1.7014117E38f;
    public static final float REASONABLE_HEIGHT_FOR_A_SCROLL_AREA = 150.0f;
    public static final int MAX_STRING_SIZE_FOR_PATH = 1024;
    private static ImFont consoleFont;
    private static ImFont smallFont;
    private static ImFont smallBoldFont;
    private static ImFont mediumFont;
    private static ImFont bigFont;
    private static ImFont nodeFont;
    private static boolean userKeysHaveBeenMapped;
    private static int spaceKey;
    private static int deleteKey;
    private static int escapeKey;
    private static int enterKey;
    private static int upArrowKey;
    private static int downArrowKey;
    private static int leftArrowKey;
    private static int rightArrowKey;
    private static ImFontAtlas fontAtlas;
    public static int BLACK;
    public static int WHITE;
    public static int RED;
    public static int GREEN;
    public static int DARK_GREEN;
    public static int LIGHT_BLUE;

    public static long createContext() {
        return ImGui.createContext().ptr;
    }

    public static long createContext(ImFontAtlas fontAtlas) {
        return ImGui.createContext((ImFontAtlas)fontAtlas).ptr;
    }

    public static long getCurrentContext() {
        return ImGui.getCurrentContext().ptr;
    }

    public static void setCurrentContext(long context) {
        ImGuiContext contextHolder = ImGui.getCurrentContext();
        contextHolder.ptr = context;
        ImGui.setCurrentContext((ImGuiContext)contextHolder);
    }

    public static void parsePrimaryWindowSizeFromSettingsINI(String settingsINIAsString, ImGuiSize sizeToPack) {
        settingsINIAsString = StringTools.filterOutCRLFLineEndings((String)settingsINIAsString);
        int indexOfDockingSection = settingsINIAsString.indexOf("[Docking]");
        int indexOfDockspace = settingsINIAsString.indexOf("DockSpace", indexOfDockingSection);
        int indexOfSize = settingsINIAsString.indexOf("Size", indexOfDockspace);
        int indexOfWidth = indexOfSize + 5;
        int indexOfComma = settingsINIAsString.indexOf(",", indexOfWidth);
        int width = Integer.parseInt(settingsINIAsString.substring(indexOfWidth, indexOfComma));
        int indexOfHeight = indexOfComma + 1;
        int indexOfSpace = settingsINIAsString.indexOf(" ", indexOfComma);
        int height = Integer.parseInt(settingsINIAsString.substring(indexOfHeight, indexOfSpace));
        sizeToPack.setWidth(width);
        sizeToPack.setHeight(height);
    }

    public static void parsePrimaryWindowPositionFromSettingsINI(String settingsINIAsString, ImGuiPosition positionToPack) {
        settingsINIAsString = StringTools.filterOutCRLFLineEndings((String)settingsINIAsString);
        int indexOfDockingSection = settingsINIAsString.indexOf("[Docking]");
        int indexOfDockspace = settingsINIAsString.indexOf("DockSpace", indexOfDockingSection);
        int indexOfPosition = settingsINIAsString.indexOf("Pos", indexOfDockspace);
        int indexOfX = indexOfPosition + 4;
        int indexOfComma = settingsINIAsString.indexOf(",", indexOfX);
        int x = Integer.parseInt(settingsINIAsString.substring(indexOfX, indexOfComma));
        int indexOfY = indexOfComma + 1;
        int indexOfSpace = settingsINIAsString.indexOf(" ", indexOfComma);
        int y = Integer.parseInt(settingsINIAsString.substring(indexOfY, indexOfSpace));
        positionToPack.setX(x);
        positionToPack.setY(y);
    }

    public static void initializeColorStyle() {
        if (!Boolean.parseBoolean(System.getProperty("imgui.dark"))) {
            ImGui.styleColorsLight();
        }
    }

    public static int greenToRedGradiatedColor(double value, double ... colorSwitchValues) {
        float redValue = 0.0f;
        float greenValue = 1.0f;
        for (double switchValue : colorSwitchValues) {
            if (value < switchValue) break;
            redValue = 1.0f;
            greenValue = (float)((double)greenValue - 1.0 / (double)colorSwitchValues.length);
        }
        return new Color(redValue, greenValue, 0.0f, 0.5f).toIntBits();
    }

    public static int nextWidgetIndex() {
        return GLOBAL_WIDGET_INDEX.getAndIncrement();
    }

    public static void glClearDarkGray() {
        GL41.glClearColor((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
        GL41.glClear((int)16384);
    }

    public static boolean volatileInputInt(String label, ImInt imInt) {
        return ImGuiTools.volatileInputInt(label, imInt, 1);
    }

    public static boolean volatileInputInt(String label, ImInt imInt, int step) {
        int inputTextFlags = 0;
        return ImGui.inputInt((String)label, (ImInt)imInt, (int)step, (int)100, (int)(inputTextFlags += 32));
    }

    public static boolean volatileInputLong(String label, ImLong imLong) {
        return ImGuiTools.volatileInputLong(label, imLong, 1L);
    }

    public static boolean volatileInputLong(String label, ImLong imLong, long step) {
        int inputTextFlags = 0;
        return ImGui.inputScalar((String)label, (int)5, (ImLong)imLong, (long)step, (long)100L, (String)"%d", (int)(inputTextFlags += 32));
    }

    public static boolean volatileInputFloat(String label, ImFloat imFloat) {
        int inputTextFlags = 0;
        return ImGui.inputFloat((String)label, (ImFloat)imFloat, (float)0.0f, (float)0.0f, (String)"%.3f", (int)(inputTextFlags += 32));
    }

    public static boolean volatileInputFloat(String label, ImFloat imFloat, float step) {
        int inputTextFlags = 0;
        return ImGui.inputFloat((String)label, (ImFloat)imFloat, (float)step, (float)0.0f, (String)"%.3f", (int)(inputTextFlags += 32));
    }

    public static boolean volatileInputDouble(String label, ImDouble imDouble) {
        return ImGuiTools.volatileInputDouble(label, imDouble, 0.0, 0.0);
    }

    public static boolean volatileInputDouble(String label, ImDouble imDouble, double step, double stepFast) {
        return ImGuiTools.volatileInputDouble(label, imDouble, step, stepFast, "%.6f");
    }

    public static boolean volatileInputDouble(String label, ImDouble imDouble, double step, double stepFast, String format) {
        int inputTextFlags = 0;
        return ImGui.inputDouble((String)label, (ImDouble)imDouble, (double)step, (double)stepFast, (String)format, (int)(inputTextFlags += 32));
    }

    public static boolean sliderDouble(String label, ImDouble imDouble, double minValue, double maxValue) {
        return ImGui.sliderScalar((String)label, (int)9, (ImDouble)imDouble, (double)minValue, (double)maxValue);
    }

    public static boolean sliderDouble(String label, ImDouble imDouble, double minValue, double maxValue, String format) {
        return ImGui.sliderScalar((String)label, (int)9, (ImDouble)imDouble, (double)minValue, (double)maxValue, (String)format);
    }

    public static boolean sliderDouble(String label, ImDouble imDouble, double minValue, double maxValue, String format, int imGuiSliderFlags) {
        return ImGui.sliderScalar((String)label, (int)9, (ImDouble)imDouble, (double)minValue, (double)maxValue, (String)format, (int)imGuiSliderFlags);
    }

    public static boolean sliderInt(String label, ImInt imInt, int minValue, int maxValue) {
        return ImGui.sliderScalar((String)label, (int)5, (ImInt)imInt, (int)minValue, (int)maxValue);
    }

    public static boolean sliderInt(String label, ImInt imInt, int minValue, int maxValue, String format) {
        return ImGui.sliderScalar((String)label, (int)5, (ImInt)imInt, (int)minValue, (int)maxValue, (String)format);
    }

    public static boolean sliderInt(String label, ImInt imInt, int minValue, int maxValue, String format, int imGuiSliderFlags) {
        return ImGui.sliderScalar((String)label, (int)5, (ImInt)imInt, (int)minValue, (int)maxValue, (String)format, (int)imGuiSliderFlags);
    }

    public static boolean inputText(String label, ImString text) {
        ImGui.inputText((String)label, (ImString)text);
        return ImGui.isItemFocused() && ImGui.isKeyReleased((int)ImGuiTools.getEnterKey());
    }

    public static void textColored(Color color, String text) {
        ImGui.textColored((float)color.r, (float)color.g, (float)color.b, (float)color.a, (String)text);
    }

    public static void textBold(String text) {
        ImGui.pushFont((ImFont)ImGuiTools.getSmallBoldFont());
        ImGui.text((String)text);
        ImGui.popFont();
    }

    public static void previousWidgetTooltip(String tooltipText) {
        if (ImGui.isItemHovered()) {
            ImGui.setTooltip((String)tooltipText);
        }
    }

    public static void markedProgressBar(float barHeight, float barWidth, int color, double percent, double markPercent, String text) {
        float markPosition = (float)((double)barWidth * markPercent);
        float windowPositionX = ImGui.getWindowPosX();
        float windowPositionY = ImGui.getWindowPosY();
        float verticalExtents = 3.0f;
        ImGui.getWindowDrawList().addRectFilled(windowPositionX + ImGui.getCursorPosX() + markPosition, windowPositionY + ImGui.getCursorPosY() - verticalExtents, windowPositionX + ImGui.getCursorPosX() + markPosition + 2.0f, windowPositionY + ImGui.getCursorPosY() + barHeight + verticalExtents, BLACK, 1.0f);
        ImGui.pushStyleColor((int)42, (int)color);
        ImGui.progressBar((float)((float)percent), (float)barWidth, (float)barHeight, (String)text);
        ImGui.popStyleColor();
    }

    public static String uniqueLabel(String label) {
        return label + "###GlobalWidgetIndex:" + ImGuiTools.nextWidgetIndex() + ":" + label;
    }

    public static String uniqueLabel(String id, String label) {
        return label + "###" + id + ":" + label;
    }

    public static String uniqueLabel(Object thisObject, String label) {
        return label + "###" + thisObject.getClass().getName() + ":" + label;
    }

    public static String uniqueIDOnly(Object thisObject, String label) {
        return "###" + thisObject.getClass().getName() + ":" + label;
    }

    public static ImFont setupFonts(ImGuiIO io) {
        return ImGuiTools.setupFonts(io, 1);
    }

    public static ImFont setupFonts(ImGuiIO io, int fontSizeLevel) {
        ImFontConfig smallFontConfig = new ImFontConfig();
        ImFontConfig smallBoldFontConfig = new ImFontConfig();
        ImFontConfig consoleFontConfig = new ImFontConfig();
        ImFontConfig mediumFontConfig = new ImFontConfig();
        ImFontConfig bigFontConfig = new ImFontConfig();
        ImFontConfig nodeFontConfig = new ImFontConfig();
        float size = 14.0f;
        int fontsFlags = 0;
        smallFontConfig.setFontBuilderFlags(fontsFlags += 8);
        smallBoldFontConfig.setFontBuilderFlags(fontsFlags + 32);
        consoleFontConfig.setFontBuilderFlags(fontsFlags);
        mediumFontConfig.setFontBuilderFlags(fontsFlags);
        bigFontConfig.setFontBuilderFlags(fontsFlags);
        nodeFontConfig.setFontBuilderFlags(fontsFlags);
        Object fontDirectory = SystemUtils.IS_OS_WINDOWS ? System.getenv("WINDIR") + "/Fonts" : "/usr/share/fonts/TTF/";
        Path segoeui = Paths.get((String)fontDirectory, "segoeui.ttf");
        if (Files.exists(segoeui, new LinkOption[0])) {
            smallFontConfig.setName("segoeui.ttf, 16px");
            smallFont = io.getFonts().addFontFromFileTTF(segoeui.toAbsolutePath().toString(), 16.0f, smallFontConfig);
            smallBoldFont = io.getFonts().addFontFromFileTTF(segoeui.toAbsolutePath().toString(), 16.0f, smallBoldFontConfig);
            mediumFontConfig.setName("segoeui.ttf, 20px");
            mediumFont = io.getFonts().addFontFromFileTTF(segoeui.toAbsolutePath().toString(), 20.0f, mediumFontConfig);
            bigFontConfig.setName("segoeui.ttf, 38px");
            bigFont = io.getFonts().addFontFromFileTTF(segoeui.toAbsolutePath().toString(), 38.0f, bigFontConfig);
            nodeFontConfig.setName("segoeui.ttf, 32px 1/2");
            nodeFont = io.getFonts().addFontFromFileTTF(segoeui.toAbsolutePath().toString(), 32.0f, nodeFontConfig);
        } else {
            smallFontConfig.setName("DejaVuSans.ttf, 13px");
            smallFont = io.getFonts().addFontFromMemoryTTF(ImGuiTools.loadFromResources("dejaVu/DejaVuSans.ttf"), 13.0f, smallFontConfig);
            smallBoldFont = io.getFonts().addFontFromMemoryTTF(ImGuiTools.loadFromResources("dejaVu/DejaVuSans.ttf"), 13.0f, smallBoldFontConfig);
            mediumFontConfig.setName("DejaVuSans.ttf, 17px");
            mediumFont = io.getFonts().addFontFromMemoryTTF(ImGuiTools.loadFromResources("dejaVu/DejaVuSans.ttf"), 17.0f, mediumFontConfig);
            bigFontConfig.setName("DejaVuSans.ttf, 32px");
            bigFont = io.getFonts().addFontFromMemoryTTF(ImGuiTools.loadFromResources("dejaVu/DejaVuSans.ttf"), 32.0f, bigFontConfig);
            nodeFontConfig.setName("DejaVuSans.ttf, 26px 1/2");
            nodeFont = io.getFonts().addFontFromMemoryTTF(ImGuiTools.loadFromResources("dejaVu/DejaVuSans.ttf"), 26.0f, nodeFontConfig);
            ImGui.getStyle().setFramePadding(ImGui.getStyle().getFramePaddingX(), 4.5f);
        }
        Path lucidaConsole = Paths.get((String)fontDirectory, "lucon.ttf");
        ImFontGlyphRangesBuilder glyphRangesBuilder = new ImFontGlyphRangesBuilder();
        glyphRangesBuilder.addRanges(ImGui.getIO().getFonts().getGlyphRangesDefault());
        glyphRangesBuilder.addRanges(new short[]{9472, 9599, 0});
        glyphRangesBuilder.addRanges(new short[]{9600, 9631, 0});
        glyphRangesBuilder.addRanges(new short[]{9632, 9727, 0});
        short[] glyphRanges = glyphRangesBuilder.buildRanges();
        if (Files.exists(lucidaConsole, new LinkOption[0])) {
            consoleFontConfig.setName("lucon.ttf, 12px");
            consoleFont = io.getFonts().addFontFromFileTTF(lucidaConsole.toAbsolutePath().toString(), 12.0f, consoleFontConfig, glyphRanges);
        } else {
            consoleFontConfig.setName("dejaVu/DejaVuSansMono.ttf, 12px");
            consoleFont = io.getFonts().addFontFromMemoryTTF(ImGuiTools.loadFromResources("dejaVu/DejaVuSansMono.ttf"), 12.0f, consoleFontConfig, glyphRanges);
        }
        nodeFont.setScale(0.5f);
        fontAtlas = ImGui.getIO().getFonts();
        fontAtlas.build();
        smallFontConfig.destroy();
        consoleFontConfig.destroy();
        mediumFontConfig.destroy();
        bigFontConfig.destroy();
        nodeFontConfig.destroy();
        if (fontSizeLevel == 2) {
            return mediumFont;
        }
        if (fontSizeLevel == 3) {
            return bigFont;
        }
        return smallFont;
    }

    public static ImFont getBigFont() {
        return bigFont;
    }

    public static ImFont getMediumFont() {
        return mediumFont;
    }

    public static ImFont getSmallFont() {
        return smallFont;
    }

    public static ImFont getSmallBoldFont() {
        return smallBoldFont;
    }

    public static ImFont getNodeFont() {
        return nodeFont;
    }

    public static ImFont getConsoleFont() {
        return consoleFont;
    }

    public static ImFontAtlas getFontAtlas() {
        return fontAtlas;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadFromResources(String fileName) {
        try (InputStream is = Objects.requireNonNull(ImGuiTools.class.getClassLoader().getResourceAsStream(fileName));){
            byte[] byArray;
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                int nRead;
                byte[] data = new byte[16384];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                byArray = buffer.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static BoundingBox2D windowBoundingBox() {
        BoundingBox2D box = new BoundingBox2D();
        int posX = (int)ImGui.getWindowPosX();
        int posY = (int)ImGui.getWindowPosY();
        box.setMin((double)posX, (double)posY);
        box.setMax((double)((float)posX + ImGui.getWindowSizeX()), (double)(posY + (int)ImGui.getWindowSizeX()));
        return box;
    }

    public static float getUsableWindowWidth() {
        return ImGui.getWindowWidth() - 32.0f;
    }

    private static void initializeUserMappedKeys() {
        spaceKey = ImGui.getKeyIndex((int)12);
        deleteKey = ImGui.getKeyIndex((int)10);
        escapeKey = ImGui.getKeyIndex((int)14);
        enterKey = ImGui.getKeyIndex((int)13);
        upArrowKey = ImGui.getKeyIndex((int)3);
        downArrowKey = ImGui.getKeyIndex((int)4);
        leftArrowKey = ImGui.getKeyIndex((int)1);
        rightArrowKey = ImGui.getKeyIndex((int)2);
    }

    public static int getSpaceKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return spaceKey;
    }

    public static int getDeleteKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return deleteKey;
    }

    public static int getEscapeKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return escapeKey;
    }

    public static int getEnterKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return enterKey;
    }

    public static int getUpArrowKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return upArrowKey;
    }

    public static int getDownArrowKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return downArrowKey;
    }

    public static int getLeftArrowKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return leftArrowKey;
    }

    public static int getRightArrowKey() {
        if (!userKeysHaveBeenMapped) {
            ImGuiTools.initializeUserMappedKeys();
        }
        return rightArrowKey;
    }

    static {
        userKeysHaveBeenMapped = false;
        BLACK = Color.BLACK.toIntBits();
        WHITE = Color.WHITE.toIntBits();
        RED = Color.RED.toIntBits();
        GREEN = Color.GREEN.toIntBits();
        DARK_GREEN = new Color(0.0f, 0.7f, 0.0f, 1.0f).toIntBits();
        LIGHT_BLUE = new Color(0.4f, 0.4f, 0.8f, 1.0f).toIntBits();
    }
}

