/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import us.ihmc.rdx.imgui.RDXDockspacePanel;
import us.ihmc.rdx.imgui.RDXPanel;

public class ImGuiPanelManager {
    private final TreeSet<RDXPanel> panels = new TreeSet<RDXPanel>(Comparator.comparing(RDXPanel::getPanelName));
    private final ConcurrentLinkedQueue<RDXPanel> removalQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<RDXPanel> addQueue = new ConcurrentLinkedQueue();

    public void addPanel(RDXPanel panel) {
        this.panels.add(panel);
    }

    public void addPanel(String windowName, Runnable render) {
        this.panels.add(new RDXPanel(windowName, render));
    }

    public void addSelfManagedPanel(String windowName) {
        this.panels.add(new RDXPanel(windowName));
    }

    public void queueRemovePanel(RDXPanel panel) {
        this.removalQueue.add(panel);
    }

    public void queueAddPanel(RDXPanel panel) {
        this.addQueue.add(panel);
    }

    public void renderPanelMenu() {
        for (RDXPanel panel : this.panels) {
            panel.renderMenuItem();
        }
    }

    public void renderPanels(TIntObjectHashMap<RDXDockspacePanel> dockIDMap) {
        while (!this.removalQueue.isEmpty()) {
            this.panels.remove(this.removalQueue.poll());
        }
        while (!this.addQueue.isEmpty()) {
            this.panels.add(this.addQueue.poll());
        }
        for (RDXPanel panel : this.panels) {
            panel.renderPanelAndChildren(dockIDMap);
        }
    }

    public void loadConfiguration(JsonNode jsonNode) {
        JsonNode windowsNode = jsonNode.get("windows");
        Iterator it = windowsNode.fields();
        while (it.hasNext()) {
            Map.Entry panelEntry = (Map.Entry)it.next();
            for (RDXPanel panel : this.panels) {
                panel.load(panelEntry);
            }
        }
    }

    public void saveConfiguration(ObjectNode root) {
        ObjectNode anchorJSON = root.putObject("windows");
        for (RDXPanel panel : this.panels) {
            panel.save(anchorJSON);
        }
    }
}

