/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.ImGui;
import imgui.ImGuiStyle;
import imgui.ImVec2;
import imgui.type.ImDouble;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;

public class ImGuiInputDoubleForRotations {
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final String label;
    private final String minusButtonLabel = this.labels.get("-");
    private final String plusButtonLabel = this.labels.get("+");
    private final String format;
    private final String prefixLabel;
    private float prefixTextWidth;
    private boolean textWidthCalculated = false;
    private final ImDouble imDouble;
    private boolean inputChanged = false;
    private boolean stepButtonClicked = false;
    private double steppedAmount = 0.0;
    private ImGuiStyle style;

    public ImGuiInputDoubleForRotations(String label, String format) {
        this(label, format, 0.0);
    }

    public ImGuiInputDoubleForRotations(String label, String format, double initialValue) {
        this.prefixLabel = label;
        this.label = this.labels.getHidden(label);
        this.format = format;
        this.imDouble = new ImDouble(initialValue);
        this.style = ImGui.getStyle();
    }

    public void render(double step, double stepFast) {
        if (!this.textWidthCalculated) {
            this.textWidthCalculated = true;
            ImVec2 size = new ImVec2();
            ImGui.calcTextSize((ImVec2)size, (String)this.prefixLabel);
            this.prefixTextWidth = size.x;
        }
        ImGui.text((String)this.prefixLabel);
        ImGui.sameLine();
        float spaceForButtons = 46.0f;
        ImGui.pushItemWidth((float)(ImGuiTools.getUsableWindowWidth() - this.prefixTextWidth - spaceForButtons));
        this.inputChanged = ImGuiTools.volatileInputDouble(this.label, this.imDouble, 0.0, 0.0, this.format);
        ImGui.popItemWidth();
        float backupFramePaddingX = this.style.getFramePaddingX();
        float framePaddingY = this.style.getFramePaddingY();
        this.style.setFramePadding(framePaddingY, framePaddingY);
        float frameHeight = ImGui.getFrameHeight();
        this.steppedAmount = 0.0;
        this.stepButtonClicked = false;
        boolean ctrlHeld = ImGui.getIO().getKeyCtrl();
        ImGui.sameLine((float)0.0f, (float)this.style.getItemInnerSpacingX());
        boolean minusClicked = ImGui.button((String)this.minusButtonLabel, (float)frameHeight, (float)frameHeight);
        ImGui.sameLine((float)0.0f, (float)this.style.getItemInnerSpacingX());
        boolean plusClicked = ImGui.button((String)this.plusButtonLabel, (float)frameHeight, (float)frameHeight);
        this.style.setFramePadding(backupFramePaddingX, framePaddingY);
        if (minusClicked) {
            this.steppedAmount -= ctrlHeld ? stepFast : step;
        }
        if (plusClicked) {
            this.steppedAmount += ctrlHeld ? stepFast : step;
        }
        this.stepButtonClicked = minusClicked || plusClicked;
    }

    public boolean getInputChanged() {
        return this.inputChanged;
    }

    public boolean getStepButtonClicked() {
        return this.stepButtonClicked;
    }

    public double getSteppedAmount() {
        return this.steppedAmount;
    }

    public void setDoubleValue(double value) {
        this.imDouble.set(value);
    }

    public double getDoubleValue() {
        return this.imDouble.get();
    }

    public ImDouble getImDouble() {
        return this.imDouble;
    }
}

