/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.ImGui;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;

public abstract class ImGuiFancyWidget {
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    protected final String label;
    protected final String format;
    private final String prefixLabel;
    private float widgetWidth = -1.0f;
    private boolean widgetTextColoring = false;
    private int widgetTextColor = 0;

    protected ImGuiFancyWidget(String label) {
        this.prefixLabel = label;
        this.label = this.labels.getHidden(label);
        this.format = null;
    }

    protected ImGuiFancyWidget(String label, String format) {
        this.prefixLabel = label;
        this.label = this.labels.getHidden(label);
        this.format = format;
    }

    protected void beforeWidgetRender() {
        ImGui.text((String)this.prefixLabel);
        ImGui.sameLine();
        ImGui.pushItemWidth((float)((double)this.widgetWidth >= 0.0 ? this.widgetWidth : ImGui.getColumnWidth()));
        if (this.widgetTextColoring) {
            ImGui.pushStyleColor((int)0, (int)this.widgetTextColor);
        }
    }

    protected void afterWidgetRender() {
        ImGui.popItemWidth();
        if (this.widgetTextColoring) {
            ImGui.popStyleColor();
        }
    }

    public void setWidgetTextColor(int intColor) {
        this.widgetTextColoring = true;
        this.widgetTextColor = intColor;
    }

    public void clearWidgetTextColor() {
        this.widgetTextColoring = false;
    }

    public void setWidgetWidth(float widgetWidth) {
        this.widgetWidth = widgetWidth;
    }
}

