/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.imgui;

import imgui.internal.ImGui;
import java.util.Arrays;
import us.ihmc.rdx.imgui.ImGuiFancyWidget;

public class ImGuiEnumPlot
extends ImGuiFancyWidget {
    public static final int TYPICAL_BUFFER_SIZE = 1000;
    public static final int TYPICAL_PLOT_HEIGHT = 20;
    public static final int AUTO_SIZE_WIDTH = 0;
    private final int bufferSize;
    private final float[] values;
    private final int height;
    private int index = 0;

    public ImGuiEnumPlot() {
        this(1000, 0, 20);
    }

    public ImGuiEnumPlot(String label) {
        this(label, 1000, 0, 20);
    }

    public ImGuiEnumPlot(String label, int bufferSize, int height) {
        this(label, bufferSize, 0, height);
    }

    public ImGuiEnumPlot(int bufferSize, int width, int height) {
        this("", bufferSize, width, height);
    }

    public ImGuiEnumPlot(String label, int bufferSize, int width, int height) {
        super(label);
        this.bufferSize = bufferSize;
        this.values = new float[bufferSize];
        this.height = height;
        Arrays.fill(this.values, Float.NaN);
    }

    public void render(int ordinal, String overlayText) {
        this.beforeWidgetRender();
        this.values[this.index] = ordinal < 0 ? Float.NaN : (float)ordinal;
        ImGui.pushItemWidth((float)ImGui.getColumnWidth());
        ImGui.plotLines((String)this.label, (float[])this.values, (int)this.bufferSize, (int)0, (String)overlayText, (float)Float.MAX_VALUE, (float)Float.MAX_VALUE, (float)0.0f, (float)this.height);
        ImGui.popItemWidth();
        ++this.index;
        if (this.index >= this.bufferSize - 1) {
            this.index = 0;
        }
        this.values[this.index] = Float.NaN;
        this.afterWidgetRender();
    }
}

