/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import java.nio.FloatBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.lwjgl.opengl.GL41;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.shader.RDXShader;
import us.ihmc.rdx.shader.RDXUniform;

public class RDXHeightMapRenderer
implements RenderableProvider {
    private Renderable renderable;
    public static final int FLOATS_PER_CELL = 8;
    public static final int BYTES_PER_VERTEX = 32;
    private final VertexAttributes vertexAttributes = new VertexAttributes(new VertexAttribute[]{new VertexAttribute(1, 3, "a_position"), new VertexAttribute(2, 4, "a_color"), new VertexAttribute(32, 1, 5126, false, "a_size")});
    private final RDXUniform screenWidthUniform = RDXUniform.createGlobalUniform("u_screenWidth", (shader, inputID, renderable, combinedAttributes) -> shader.set(inputID, shader.camera.viewportWidth));
    private int multiColor = 0;
    private final RDXUniform multiColorUniform = RDXUniform.createGlobalUniform("u_multiColor", (shader, inputID, renderable, combinedAttributes) -> shader.set(inputID, this.multiColor));
    private float[] intermediateVertexBuffer;
    private int totalCells;

    public void create(int numberOfCells) {
        GL41.glEnable((int)34370);
        this.renderable = new Renderable();
        this.renderable.meshPart.primitiveType = 0;
        this.renderable.meshPart.offset = 0;
        this.renderable.material = new Material(new Attribute[]{ColorAttribute.createDiffuse((Color)Color.WHITE)});
        this.totalCells = numberOfCells;
        if (this.renderable.meshPart.mesh != null) {
            this.renderable.meshPart.mesh.dispose();
        }
        boolean isStatic = false;
        int maxIndices = 0;
        this.renderable.meshPart.mesh = new Mesh(isStatic, this.totalCells, maxIndices, this.vertexAttributes);
        RDXShader shader = new RDXShader(this.getClass());
        shader.create();
        shader.getBaseShader().register(DefaultShader.Inputs.viewTrans, DefaultShader.Setters.viewTrans);
        shader.getBaseShader().register(DefaultShader.Inputs.projTrans, DefaultShader.Setters.projTrans);
        shader.registerUniform(this.screenWidthUniform);
        shader.registerUniform(this.multiColorUniform);
        shader.init(this.renderable);
        this.renderable.shader = shader.getBaseShader();
        LogTools.info((String)"Vertex Buffer Size: {}", (Object)(this.totalCells * 8));
        this.intermediateVertexBuffer = new float[this.totalCells * 8];
    }

    public void update(RigidBodyTransform zUpFrameToWorld, BytePointer heightMapPointer, float gridCenterX, float gridCenterY, int centerIndex, float cellSizeXYInMeters, float heightScalingFactor) {
        zUpFrameToWorld.getTranslation().setZ(0.0);
        int cellsPerAxis = 2 * centerIndex + 1;
        float maxHeight = 2.0f;
        float minHeight = 0.0f;
        Point3D spritePoint = new Point3D();
        for (int xIndex = 0; xIndex < cellsPerAxis; ++xIndex) {
            for (int yIndex = 0; yIndex < cellsPerAxis; ++yIndex) {
                spritePoint.setToZero();
                double xPosition = RDXHeightMapRenderer.indexToCoordinate(xIndex, gridCenterX, cellSizeXYInMeters, centerIndex);
                double yPosition = RDXHeightMapRenderer.indexToCoordinate(yIndex, gridCenterY, cellSizeXYInMeters, centerIndex);
                int heightIndex = xIndex * cellsPerAxis + yIndex;
                int vertexIndex = heightIndex * 8;
                float zPosition = (float)heightMapPointer.getShort((long)heightIndex * 2L) / heightScalingFactor;
                zPosition = (float)MathTools.clamp((double)zPosition, (double)minHeight, (double)maxHeight);
                if (zPosition > maxHeight - 0.01f) {
                    zPosition = 0.0f;
                }
                spritePoint.set(xPosition, yPosition, (double)zPosition);
                this.intermediateVertexBuffer[vertexIndex] = (float)spritePoint.getX();
                this.intermediateVertexBuffer[vertexIndex + 1] = (float)spritePoint.getY();
                this.intermediateVertexBuffer[vertexIndex + 2] = (float)spritePoint.getZ();
                Color color = RDXHeightMapRenderer.computeColorFromHeight(zPosition);
                this.intermediateVertexBuffer[vertexIndex + 3] = color.r;
                this.intermediateVertexBuffer[vertexIndex + 4] = color.g;
                this.intermediateVertexBuffer[vertexIndex + 5] = color.b;
                this.intermediateVertexBuffer[vertexIndex + 6] = color.a;
                this.intermediateVertexBuffer[vertexIndex + 7] = 0.02f;
            }
        }
        this.renderable.meshPart.size = this.totalCells;
        this.renderable.meshPart.mesh.setVertices(this.intermediateVertexBuffer, 0, this.totalCells * 8);
    }

    public static Color computeColorFromHeight(double height) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        double redR = 1.0;
        double redG = 0.0;
        double redB = 0.0;
        double magentaR = 1.0;
        double magentaG = 0.0;
        double magentaB = 1.0;
        double orangeR = 1.0;
        double orangeG = 0.7843137254901961;
        double orangeB = 0.0;
        double yellowR = 1.0;
        double yellowG = 1.0;
        double yellowB = 0.0;
        double blueR = 0.0;
        double blueG = 0.0;
        double blueB = 1.0;
        double greenR = 0.0;
        double greenG = 1.0;
        double greenB = 0.0;
        double gradientSize = 0.2;
        double gradientLength = 1.0;
        double alpha = height % gradientLength;
        if (alpha < 0.0) {
            alpha = 1.0 + alpha;
        }
        while (alpha > 5.0 * gradientSize) {
            alpha -= 5.0 * gradientSize;
        }
        if (alpha <= gradientSize * 1.0) {
            r = InterpolationTools.linearInterpolate((double)magentaR, (double)blueR, (double)(alpha / gradientSize));
            g = InterpolationTools.linearInterpolate((double)magentaG, (double)blueG, (double)(alpha / gradientSize));
            b = InterpolationTools.linearInterpolate((double)magentaB, (double)blueB, (double)(alpha / gradientSize));
        } else if (alpha <= gradientSize * 2.0) {
            r = InterpolationTools.linearInterpolate((double)blueR, (double)greenR, (double)((alpha - gradientSize * 1.0) / gradientSize));
            g = InterpolationTools.linearInterpolate((double)blueG, (double)greenG, (double)((alpha - gradientSize * 1.0) / gradientSize));
            b = InterpolationTools.linearInterpolate((double)blueB, (double)greenB, (double)((alpha - gradientSize * 1.0) / gradientSize));
        } else if (alpha <= gradientSize * 3.0) {
            r = InterpolationTools.linearInterpolate((double)greenR, (double)yellowR, (double)((alpha - gradientSize * 2.0) / gradientSize));
            g = InterpolationTools.linearInterpolate((double)greenG, (double)yellowG, (double)((alpha - gradientSize * 2.0) / gradientSize));
            b = InterpolationTools.linearInterpolate((double)greenB, (double)yellowB, (double)((alpha - gradientSize * 2.0) / gradientSize));
        } else if (alpha <= gradientSize * 4.0) {
            r = InterpolationTools.linearInterpolate((double)yellowR, (double)orangeR, (double)((alpha - gradientSize * 3.0) / gradientSize));
            g = InterpolationTools.linearInterpolate((double)yellowG, (double)orangeG, (double)((alpha - gradientSize * 3.0) / gradientSize));
            b = InterpolationTools.linearInterpolate((double)yellowB, (double)orangeB, (double)((alpha - gradientSize * 3.0) / gradientSize));
        } else if (alpha <= gradientSize * 5.0) {
            r = InterpolationTools.linearInterpolate((double)orangeR, (double)redR, (double)((alpha - gradientSize * 4.0) / gradientSize));
            g = InterpolationTools.linearInterpolate((double)orangeG, (double)redG, (double)((alpha - gradientSize * 4.0) / gradientSize));
            b = InterpolationTools.linearInterpolate((double)orangeB, (double)redB, (double)((alpha - gradientSize * 4.0) / gradientSize));
        } else {
            throw new RuntimeException("no valid color");
        }
        if (r == 0.0 && g == 0.0 && b == 0.0) {
            throw new RuntimeException("Shouldn't return black.)");
        }
        return new Color((float)r, (float)g, (float)b, 1.0f);
    }

    public static double indexToCoordinate(int index, double gridCenter, double resolution, int centerIndex) {
        return (double)(index - centerIndex) * resolution + gridCenter;
    }

    public FloatBuffer getVertexBuffer() {
        return this.renderable.meshPart.mesh.getVerticesBuffer();
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        renderables.add((Object)this.renderable);
    }

    public void dispose() {
        if (this.renderable.meshPart.mesh != null) {
            this.renderable.meshPart.mesh.dispose();
        }
    }
}

