/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tests.g3d.shadows.system.classical;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.tests.g3d.shadows.system.BaseShadowSystem;
import com.badlogic.gdx.tests.g3d.shadows.system.FirstPassBaseShadowSystem;
import com.badlogic.gdx.tests.g3d.shadows.system.classical.MainShader;
import com.badlogic.gdx.tests.g3d.shadows.system.classical.MainShaderProvider;
import com.badlogic.gdx.tests.g3d.shadows.system.classical.Pass1ShaderProvider;
import com.badlogic.gdx.tests.g3d.shadows.system.classical.Pass2Shader;
import com.badlogic.gdx.tests.g3d.shadows.system.classical.Pass2ShaderProvider;
import com.badlogic.gdx.tests.g3d.shadows.utils.DirectionalAnalyzer;
import com.badlogic.gdx.tests.g3d.shadows.utils.LightFilter;
import com.badlogic.gdx.tests.g3d.shadows.utils.NearFarAnalyzer;
import com.badlogic.gdx.tests.g3d.shadows.utils.ShadowMapAllocator;
import com.badlogic.gdx.utils.ScreenUtils;

public class ClassicalShadowSystem
extends FirstPassBaseShadowSystem {
    public static final int PASS_QUANTITY = 2;
    public static final int SECOND_PASS = 1;
    protected boolean firstCallPass2;
    protected int nbCall = 0;

    public ClassicalShadowSystem() {
    }

    public ClassicalShadowSystem(NearFarAnalyzer nearFarAnalyzer, ShadowMapAllocator allocator, DirectionalAnalyzer directionalAnalyzer, LightFilter lightFilter) {
        super(nearFarAnalyzer, allocator, directionalAnalyzer, lightFilter);
    }

    @Override
    public int getPassQuantity() {
        return 2;
    }

    @Override
    public void init(int n) {
        super.init(n);
        this.mainShaderProvider = new MainShaderProvider(new MainShader.Config(this));
        if (n == 1) {
            this.init2();
        }
    }

    @Override
    protected void init1() {
        super.init1();
        this.passShaderProviders[ClassicalShadowSystem.FIRST_PASS] = new Pass1ShaderProvider();
    }

    protected void init2() {
        this.frameBuffers[1] = new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.graphics.getBackBufferWidth(), Gdx.graphics.getBackBufferHeight(), true);
        this.passShaderProviders[1] = new Pass2ShaderProvider(new Pass2Shader.Config(this));
    }

    @Override
    protected void beginPass(int n) {
        super.beginPass(n);
        if (n == 1) {
            this.beginPass2();
        }
    }

    protected void beginPass2() {
        ScreenUtils.clear((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (boolean)true);
        this.firstCallPass2 = true;
        this.nbCall = 0;
    }

    @Override
    public Camera next() {
        if (this.currentPass == 1 && this.nbCall > 0) {
            this.firstCallPass2 = false;
        }
        ++this.nbCall;
        return super.next();
    }

    @Override
    protected Camera interceptCamera(BaseShadowSystem.LightProperties lp) {
        if (this.currentPass == 1) {
            return this.camera;
        }
        return lp.camera;
    }

    @Override
    protected void processViewport(BaseShadowSystem.LightProperties lp, boolean cameraViewport) {
        if (this.currentPass != 1) {
            super.processViewport(lp, cameraViewport);
        }
    }

    public Texture getMainTexture() {
        return this.getTexture(1);
    }

    public boolean isFirstCallPass2() {
        return this.firstCallPass2;
    }

    public String toString() {
        return "ClassicalShadowSystem";
    }
}

