/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import org.lwjgl.openvr.InputDigitalActionData;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameLine3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.rdx.mesh.RDXMultiColorMeshBuilder;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.RDXModelBuilder;
import us.ihmc.rdx.vr.ClickDelayCalculator;
import us.ihmc.rdx.vr.RDXVRContext;
import us.ihmc.robotics.robotSide.RobotSide;

public class RDXVRTeleporter {
    private boolean preparingToTeleport = false;
    private ModelInstance lineModel;
    private ModelInstance ring;
    private ModelInstance arrow;
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private final FramePose3D pickRayPose = new FramePose3D();
    private final FrameLine3D pickRay = new FrameLine3D();
    private final FramePose3D currentPlayArea = new FramePose3D();
    private final Plane3D currentPlayAreaPlane = new Plane3D();
    private final FrameVector3D controllerZAxisVector = new FrameVector3D();
    private final Point3D controllerZAxisProjectedToPlanePoint = new Point3D();
    private final Point3D planeRayIntesection = new Point3D();
    private final Vector3D orientationDeterminationVector = new Vector3D();
    private final FramePose3D proposedTeleportPose = new FramePose3D();
    private final RigidBodyTransform xyYawHeadsetToTeleportTransform = new RigidBodyTransform();
    private double lineLength = 1.0;
    private final Color color = Color.WHITE;
    private double lastTouchpadY = Double.NaN;
    private ReferenceFrame robotMidFeetZUpReferenceFrame = null;
    private final ClickDelayCalculator bButtonClickDelayCalculator = new ClickDelayCalculator();

    public void create(RDXVRContext context) {
        double ringThickness = 0.005;
        double innerRadius = 0.4;
        double outerRadius = 0.5;
        this.lineModel = RDXModelBuilder.buildModelInstance(this::buildLineMesh, "line");
        this.ring = RDXModelBuilder.buildModelInstance(meshBuilder -> meshBuilder.addHollowCylinder(ringThickness, outerRadius, innerRadius, (Tuple3DReadOnly)new Point3D(), this.color), "ring");
        this.arrow = RDXModelBuilder.buildModelInstance(meshBuilder -> {
            Point3D offset = new Point3D();
            offset.setX(outerRadius + 0.05);
            YawPitchRoll orientation = new YawPitchRoll();
            orientation.setYaw(Math.toRadians(-90.0));
            orientation.setPitch(Math.toRadians(0.0));
            orientation.setRoll(Math.toRadians(-90.0));
            meshBuilder.addIsoscelesTriangularPrism(0.2, 0.2, ringThickness, (Tuple3DReadOnly)offset, (Orientation3DReadOnly)orientation, this.color);
        }, "arrow");
        context.addVRInputProcessor(this::processVRInput);
    }

    private void buildLineMesh(RDXMultiColorMeshBuilder meshBuilder) {
        meshBuilder.addLine(0.0, 0.0, 0.0, this.lineLength, 0.0, 0.0, 0.005, this.color);
    }

    private void processVRInput(RDXVRContext vrContext) {
        vrContext.getController(RobotSide.RIGHT).runIfConnected(controller -> {
            boolean bJustPushed;
            this.preparingToTeleport = false;
            InputDigitalActionData bButton = controller.getBButtonActionData();
            InputDigitalActionData bButtonDoubleClick = controller.getBButtonDoubleClickActionData();
            boolean bButtonDown = bButton.bState() && this.bButtonClickDelayCalculator.resume();
            boolean released = !bButtonDown && bButton.bChanged();
            boolean bl = bJustPushed = bButtonDown && bButton.bChanged();
            if (bJustPushed) {
                this.bButtonClickDelayCalculator.delay();
            }
            if (this.robotMidFeetZUpReferenceFrame != null && bButtonDoubleClick.bChanged() && !bButtonDoubleClick.bState()) {
                this.snapToMidFeetZUp(vrContext);
            } else if (bButtonDown && this.bButtonClickDelayCalculator.resume()) {
                this.preparingToTeleport = true;
                this.pickRay.setToZero(controller.getXForwardZUpControllerFrame());
                this.pickRay.getDirection().set((UnitVector3DReadOnly)Axis3D.X);
                this.pickRay.changeFrame(ReferenceFrame.getWorldFrame());
                this.pickRayPose.setToZero(controller.getXForwardZUpControllerFrame());
                this.pickRayPose.changeFrame(ReferenceFrame.getWorldFrame());
                this.currentPlayArea.setToZero(vrContext.getTeleportFrameIHMCZUp());
                this.currentPlayArea.changeFrame(ReferenceFrame.getWorldFrame());
                this.currentPlayAreaPlane.getNormal().set((UnitVector3DReadOnly)Axis3D.Z);
                this.currentPlayAreaPlane.getPoint().set((Tuple3DReadOnly)this.currentPlayArea.getPosition());
                this.currentPlayAreaPlane.intersectionWith((Line3DReadOnly)this.pickRay, (Point3DBasics)this.planeRayIntesection);
                this.controllerZAxisVector.setIncludingFrame(controller.getXForwardZUpControllerFrame(), (Tuple3DReadOnly)Axis3D.Z);
                this.controllerZAxisVector.changeFrame(ReferenceFrame.getWorldFrame());
                this.controllerZAxisProjectedToPlanePoint.set(this.planeRayIntesection);
                this.controllerZAxisProjectedToPlanePoint.add((Tuple3DReadOnly)this.controllerZAxisVector);
                this.currentPlayAreaPlane.orthogonalProjection((Point3DBasics)this.controllerZAxisProjectedToPlanePoint);
                this.orientationDeterminationVector.sub((Tuple3DReadOnly)this.controllerZAxisProjectedToPlanePoint, (Tuple3DReadOnly)this.planeRayIntesection);
                this.proposedTeleportPose.setToZero(ReferenceFrame.getWorldFrame());
                this.proposedTeleportPose.getPosition().set((Tuple3DReadOnly)this.planeRayIntesection);
                EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)Axis3D.X, (Vector3DReadOnly)this.orientationDeterminationVector, (Orientation3DBasics)this.proposedTeleportPose.getOrientation());
                this.lineLength = this.pickRayPose.getPosition().distance((FramePoint3DReadOnly)this.proposedTeleportPose.getPosition());
                RDXModelBuilder.rebuildMesh((Node)this.lineModel.nodes.get(0), this::buildLineMesh);
                this.pickRayPose.get((RigidBodyTransformBasics)this.tempTransform);
                LibGDXTools.toLibGDX(this.tempTransform, this.lineModel.transform);
                this.proposedTeleportPose.get((RigidBodyTransformBasics)this.tempTransform);
                LibGDXTools.toLibGDX(this.tempTransform, this.ring.transform);
                LibGDXTools.toLibGDX(this.tempTransform, this.arrow.transform);
            } else if (released && this.bButtonClickDelayCalculator.resume()) {
                vrContext.teleport(teleportIHMCZUpToIHMCZUpWorld -> {
                    this.xyYawHeadsetToTeleportTransform.setIdentity();
                    vrContext.getHeadset().runIfConnected(headset -> {
                        headset.getXForwardZUpHeadsetFrame().getTransformToDesiredFrame(this.xyYawHeadsetToTeleportTransform, vrContext.getTeleportFrameIHMCZUp());
                        this.xyYawHeadsetToTeleportTransform.getTranslation().setZ(0.0);
                        this.xyYawHeadsetToTeleportTransform.getRotation().setYawPitchRoll(this.xyYawHeadsetToTeleportTransform.getRotation().getYaw(), 0.0, 0.0);
                    });
                    teleportIHMCZUpToIHMCZUpWorld.set(this.xyYawHeadsetToTeleportTransform);
                    teleportIHMCZUpToIHMCZUpWorld.invert();
                    this.proposedTeleportPose.get((RigidBodyTransformBasics)this.tempTransform);
                    this.tempTransform.transform((RigidBodyTransformBasics)teleportIHMCZUpToIHMCZUpWorld);
                });
            }
            if (controller.getTouchpadTouchedActionData().bState()) {
                double y = controller.getTouchpadActionData().y();
                if (!Double.isNaN(this.lastTouchpadY)) {
                    double delta = y - this.lastTouchpadY;
                    vrContext.teleport(teleportIHMCZUpToIHMCZUpWorld -> teleportIHMCZUpToIHMCZUpWorld.getTranslation().addZ(delta * 0.3));
                }
                this.lastTouchpadY = y;
            } else {
                this.lastTouchpadY = Double.NaN;
            }
        });
    }

    private void snapToMidFeetZUp(RDXVRContext vrContext) {
        vrContext.teleport(teleportIHMCZUpToIHMCZUpWorld -> {
            this.xyYawHeadsetToTeleportTransform.setIdentity();
            vrContext.getHeadset().runIfConnected(headset -> {
                headset.getXForwardZUpHeadsetFrame().getTransformToDesiredFrame(this.xyYawHeadsetToTeleportTransform, vrContext.getTeleportFrameIHMCZUp());
                this.xyYawHeadsetToTeleportTransform.getTranslation().setZ(0.0);
                this.xyYawHeadsetToTeleportTransform.getRotation().setYawPitchRoll(this.xyYawHeadsetToTeleportTransform.getRotation().getYaw(), 0.0, 0.0);
            });
            teleportIHMCZUpToIHMCZUpWorld.set(this.xyYawHeadsetToTeleportTransform);
            teleportIHMCZUpToIHMCZUpWorld.invert();
            this.tempTransform.set(this.robotMidFeetZUpReferenceFrame.getTransformToWorldFrame());
            this.tempTransform.transform((RigidBodyTransformBasics)teleportIHMCZUpToIHMCZUpWorld);
        });
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.preparingToTeleport) {
            this.lineModel.getRenderables(renderables, pool);
            this.ring.getRenderables(renderables, pool);
            this.arrow.getRenderables(renderables, pool);
        }
    }

    public void setRobotMidFeetZUpReferenceFrame(ReferenceFrame robotMidFeetZUpReferenceFrame) {
        this.robotMidFeetZUpReferenceFrame = robotMidFeetZUpReferenceFrame;
    }
}

