/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.LongBuffer;
import java.util.function.Consumer;
import org.lwjgl.openvr.InputAnalogActionData;
import org.lwjgl.openvr.InputDigitalActionData;
import org.lwjgl.openvr.InputOriginInfo;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.openvr.VRInput;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.rdx.imgui.ImGuiRigidBodyTransformTuner;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.RDXModelBuilder;
import us.ihmc.rdx.tools.RDXModelInstance;
import us.ihmc.rdx.vr.RDXVRTrackedDevice;
import us.ihmc.robotics.referenceFrames.ModifiableReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;

public class RDXVRController
extends RDXVRTrackedDevice {
    private final RobotSide side;
    private final LongBuffer inputSourceHandle = BufferUtils.newLongBuffer((int)1);
    private InputOriginInfo.Buffer inputOriginInfo;
    private final LongBuffer clickTriggerActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData clickTriggerActionData;
    private final LongBuffer triggerTouchedActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData triggerTouchedActionData;
    private final LongBuffer triggerActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputAnalogActionData triggerActionData;
    private final LongBuffer aButtonActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData aButtonActionData;
    private final LongBuffer aTouchedActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData aTouchedActionData;
    private final LongBuffer bButtonActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData bButtonActionData;
    private final LongBuffer bButtonDoubleClickActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData bButtonDoubleClickActionData;
    private final LongBuffer bTouchedActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData bTouchedActionData;
    private final LongBuffer joystickPressActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData joystickPressActionData;
    private final LongBuffer touchpadTouchedActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputDigitalActionData touchpadTouchedActionData;
    private final LongBuffer touchpadActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputAnalogActionData touchpadActionData;
    private final LongBuffer joystickActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputAnalogActionData joystickActionData;
    private final LongBuffer gripActionHandle = BufferUtils.newLongBuffer((int)1);
    private InputAnalogActionData gripActionData;
    private static final RigidBodyTransformReadOnly controllerYBackZLeftXRightToXForwardZUp = new RigidBodyTransform((Orientation3DReadOnly)new YawPitchRoll(Math.toRadians(90.0), Math.toRadians(135.0), Math.toRadians(0.0)), (Tuple3DReadOnly)new Point3D());
    private final ReferenceFrame xForwardZUpControllerFrame;
    private final FramePose3D tempFramePose = new FramePose3D();
    private final RigidBodyTransform tempRigidBodyTransform = new RigidBodyTransform();
    private final FramePose3D pickPoseFramePose = new FramePose3D();
    private final ModifiableReferenceFrame pickPoseFrame;
    private final ImGuiRigidBodyTransformTuner pickPoseTransformTuner;
    private RDXModelInstance pickPoseSphere;

    public RDXVRController(RobotSide side, ReferenceFrame vrPlayAreaYUpZBackFrame) {
        super(vrPlayAreaYUpZBackFrame);
        this.side = side;
        this.xForwardZUpControllerFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)(side.getLowerCaseName() + "_xForwardZUpControllerFrame"), (ReferenceFrame)this.getDeviceYUpZBackFrame(), (RigidBodyTransformReadOnly)controllerYBackZLeftXRightToXForwardZUp);
        this.pickPoseFrame = new ModifiableReferenceFrame(this.xForwardZUpControllerFrame);
        this.pickPoseFrame.getTransformToParent().getTranslation().setX(0.029);
        this.pickPoseFrame.getTransformToParent().getTranslation().setY(side.negateIfLeftSide(0.02));
        this.pickPoseFrame.getTransformToParent().getTranslation().setZ(-0.017);
        this.pickPoseFrame.getReferenceFrame().update();
        this.pickPoseTransformTuner = new ImGuiRigidBodyTransformTuner(this.pickPoseFrame.getTransformToParent());
    }

    public void initSystem() {
        this.inputOriginInfo = InputOriginInfo.create((int)1);
        VRInput.VRInput_GetInputSourceHandle((CharSequence)("/user/hand/" + this.side.getLowerCaseName()), (LongBuffer)this.inputSourceHandle);
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_clicktrigger"), (LongBuffer)this.clickTriggerActionHandle);
        this.clickTriggerActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_triggertouched"), (LongBuffer)this.triggerTouchedActionHandle);
        this.triggerTouchedActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_trigger"), (LongBuffer)this.triggerActionHandle);
        this.triggerActionData = InputAnalogActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_abutton"), (LongBuffer)this.aButtonActionHandle);
        this.aButtonActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_atouched"), (LongBuffer)this.aTouchedActionHandle);
        this.aTouchedActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_bbutton"), (LongBuffer)this.bButtonActionHandle);
        this.bButtonActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_bbuttondoubleclick"), (LongBuffer)this.bButtonDoubleClickActionHandle);
        this.bButtonDoubleClickActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_btouched"), (LongBuffer)this.bTouchedActionHandle);
        this.bTouchedActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_joystickpress"), (LongBuffer)this.joystickPressActionHandle);
        this.joystickPressActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_touchpadtouched"), (LongBuffer)this.touchpadTouchedActionHandle);
        this.touchpadTouchedActionData = InputDigitalActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_touchpad"), (LongBuffer)this.touchpadActionHandle);
        this.touchpadActionData = InputAnalogActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_joystick"), (LongBuffer)this.joystickActionHandle);
        this.joystickActionData = InputAnalogActionData.create();
        VRInput.VRInput_GetActionHandle((CharSequence)("/actions/main/in/" + this.side.getLowerCaseName() + "_grip"), (LongBuffer)this.gripActionHandle);
        this.gripActionData = InputAnalogActionData.create();
    }

    @Override
    public void update(TrackedDevicePose.Buffer trackedDevicePoses) {
        VRInput.VRInput_GetOriginTrackedDeviceInfo((long)this.inputSourceHandle.get(0), (InputOriginInfo)((InputOriginInfo)this.inputOriginInfo.get(0)));
        this.setDeviceIndex(this.inputOriginInfo.trackedDeviceIndex());
        this.setConnected(this.getDeviceIndex() != -1);
        super.update(trackedDevicePoses);
        if (this.isConnected()) {
            if (this.pickPoseSphere == null) {
                this.pickPoseSphere = new RDXModelInstance(RDXModelBuilder.createSphere(0.0025f, new Color(-2029582337)));
            }
            this.pickPoseFrame.getReferenceFrame().update();
            this.pickPoseFramePose.setToZero(this.pickPoseFrame.getReferenceFrame());
            this.pickPoseFramePose.changeFrame(ReferenceFrame.getWorldFrame());
            this.pickPoseSphere.setPoseInWorldFrame((Pose3DReadOnly)this.pickPoseFramePose);
        }
        VRInput.VRInput_GetDigitalActionData((long)this.clickTriggerActionHandle.get(0), (InputDigitalActionData)this.clickTriggerActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.triggerTouchedActionHandle.get(0), (InputDigitalActionData)this.triggerTouchedActionData, (long)0L);
        VRInput.VRInput_GetAnalogActionData((long)this.triggerActionHandle.get(0), (InputAnalogActionData)this.triggerActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.aButtonActionHandle.get(0), (InputDigitalActionData)this.aButtonActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.aTouchedActionHandle.get(0), (InputDigitalActionData)this.aTouchedActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.bButtonActionHandle.get(0), (InputDigitalActionData)this.bButtonActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.bButtonDoubleClickActionHandle.get(0), (InputDigitalActionData)this.bButtonDoubleClickActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.bTouchedActionHandle.get(0), (InputDigitalActionData)this.bTouchedActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.joystickPressActionHandle.get(0), (InputDigitalActionData)this.joystickPressActionData, (long)0L);
        VRInput.VRInput_GetAnalogActionData((long)this.touchpadActionHandle.get(0), (InputAnalogActionData)this.touchpadActionData, (long)0L);
        VRInput.VRInput_GetDigitalActionData((long)this.touchpadTouchedActionHandle.get(0), (InputDigitalActionData)this.touchpadTouchedActionData, (long)0L);
        VRInput.VRInput_GetAnalogActionData((long)this.joystickActionHandle.get(0), (InputAnalogActionData)this.joystickActionData, (long)0L);
        VRInput.VRInput_GetAnalogActionData((long)this.gripActionHandle.get(0), (InputAnalogActionData)this.gripActionData, (long)0L);
    }

    public void renderImGuiTunerWidgets() {
        this.pickPoseTransformTuner.renderTunerWithYawPitchRoll(0.001);
    }

    public RDXModelInstance getPickPoseSphere() {
        return this.pickPoseSphere;
    }

    public InputDigitalActionData getClickTriggerActionData() {
        return this.clickTriggerActionData;
    }

    public InputDigitalActionData getTriggerTouchedActionData() {
        return this.triggerTouchedActionData;
    }

    public InputAnalogActionData getTriggerActionData() {
        return this.triggerActionData;
    }

    public InputDigitalActionData getAButtonActionData() {
        return this.aButtonActionData;
    }

    public InputDigitalActionData getATouchedActionData() {
        return this.aTouchedActionData;
    }

    public InputDigitalActionData getBButtonActionData() {
        return this.bButtonActionData;
    }

    public InputDigitalActionData getBButtonDoubleClickActionData() {
        return this.bButtonDoubleClickActionData;
    }

    public InputDigitalActionData getBTouchedActionData() {
        return this.bTouchedActionData;
    }

    public InputDigitalActionData getJoystickPressActionData() {
        return this.joystickPressActionData;
    }

    public InputAnalogActionData getTouchpadActionData() {
        return this.touchpadActionData;
    }

    public InputDigitalActionData getTouchpadTouchedActionData() {
        return this.touchpadTouchedActionData;
    }

    public InputAnalogActionData getJoystickActionData() {
        return this.joystickActionData;
    }

    public InputAnalogActionData getGripActionData() {
        return this.gripActionData;
    }

    public ReferenceFrame getXForwardZUpControllerFrame() {
        return this.xForwardZUpControllerFrame;
    }

    public void getTransformZUpToWorld(Matrix4 transform) {
        this.xForwardZUpControllerFrame.getTransformToDesiredFrame(this.tempRigidBodyTransform, ReferenceFrame.getWorldFrame());
        LibGDXTools.toLibGDX(this.tempRigidBodyTransform, transform);
    }

    public Pose3DReadOnly getXForwardZUpPose() {
        this.tempFramePose.setToZero(this.getXForwardZUpControllerFrame());
        this.tempFramePose.changeFrame(ReferenceFrame.getWorldFrame());
        return this.tempFramePose;
    }

    public void runIfConnected(Consumer<RDXVRController> runIfConnected) {
        if (this.isConnected()) {
            runIfConnected.accept(this);
        }
    }

    public FramePose3DReadOnly getPickPointPose() {
        return this.pickPoseFramePose;
    }

    public ReferenceFrame getPickPoseFrame() {
        return this.pickPoseFrame.getReferenceFrame();
    }
}

