/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.vr;

import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Pool;
import com.fasterxml.jackson.databind.JsonNode;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL41;
import org.lwjgl.openvr.OpenVR;
import org.lwjgl.openvr.Texture;
import org.lwjgl.openvr.TrackedDevicePose;
import org.lwjgl.openvr.VR;
import org.lwjgl.openvr.VRActiveActionSet;
import org.lwjgl.openvr.VRCompositor;
import org.lwjgl.openvr.VREvent;
import org.lwjgl.openvr.VRInput;
import org.lwjgl.openvr.VRSystem;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.sceneManager.RDX3DScene;
import us.ihmc.rdx.vr.RDXVRBaseStation;
import us.ihmc.rdx.vr.RDXVRController;
import us.ihmc.rdx.vr.RDXVRControllerModel;
import us.ihmc.rdx.vr.RDXVREye;
import us.ihmc.rdx.vr.RDXVRHeadset;
import us.ihmc.rdx.vr.RDXVRPickResult;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.tools.io.JSONFileTools;
import us.ihmc.tools.io.WorkspaceDirectory;
import us.ihmc.tools.io.WorkspaceFile;

public class RDXVRContext {
    private final IntBuffer errorPointer = BufferUtils.newIntBuffer((int)1);
    private final IntBuffer widthPointer = BufferUtils.newIntBuffer((int)1);
    private final IntBuffer heightPointer = BufferUtils.newIntBuffer((int)1);
    private final SideDependentList<RDXVREye> eyes = new SideDependentList();
    private TrackedDevicePose.Buffer trackedDevicePoses;
    private TrackedDevicePose.Buffer trackedDeviceGamePoses;
    private final LongBuffer mainActionSetHandle = BufferUtils.newLongBuffer((int)1);
    private VRActiveActionSet.Buffer activeActionSets;
    private VREvent event;
    private int width;
    private int height;
    private final ArrayList<Consumer<RDXVRContext>> vrPickCalculators = new ArrayList();
    private final ArrayList<Consumer<RDXVRContext>> vrInputProcessors = new ArrayList();
    public static final RigidBodyTransformReadOnly openVRYUpToIHMCZUpSpace = new RigidBodyTransform((Orientation3DReadOnly)new YawPitchRoll(Math.toRadians(-90.0), Math.toRadians(0.0), Math.toRadians(90.0)), (Tuple3DReadOnly)new Point3D());
    private final RigidBodyTransform teleportIHMCZUpToIHMCZUpWorld = new RigidBodyTransform();
    private final ReferenceFrame teleportFrameIHMCZUp = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)"teleportFrame", (ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)this.teleportIHMCZUpToIHMCZUpWorld);
    private final ReferenceFrame vrPlayAreaYUpZBackFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"vrPlayAreaFrame", (ReferenceFrame)this.teleportFrameIHMCZUp, (RigidBodyTransformReadOnly)openVRYUpToIHMCZUpSpace);
    private RDXVRControllerModel controllerModel = RDXVRControllerModel.UNKNOWN;
    private final RDXVRHeadset headset = new RDXVRHeadset(this.vrPlayAreaYUpZBackFrame);
    private final SideDependentList<RDXVRController> controllers = new SideDependentList((Object)new RDXVRController(RobotSide.LEFT, this.vrPlayAreaYUpZBackFrame), (Object)new RDXVRController(RobotSide.RIGHT, this.vrPlayAreaYUpZBackFrame));
    private final HashMap<Integer, RDXVRBaseStation> baseStations = new HashMap();
    private final SideDependentList<ArrayList<RDXVRPickResult>> pickResults = new SideDependentList(new ArrayList(), new ArrayList());
    private SideDependentList<RDXVRPickResult> selectedPick = new SideDependentList(null, null);

    public void initSystem() {
        LogTools.info((String)"Initializing");
        this.event = VREvent.create();
        this.trackedDevicePoses = TrackedDevicePose.create((int)64);
        this.trackedDeviceGamePoses = TrackedDevicePose.create((int)64);
        int token = VR.VR_InitInternal((IntBuffer)this.errorPointer, (int)1);
        this.checkInitError(this.errorPointer);
        OpenVR.create((int)token);
        VR.VR_GetGenericInterface((CharSequence)"IVRCompositor_027", (IntBuffer)this.errorPointer);
        this.checkInitError(this.errorPointer);
        VR.VR_GetGenericInterface((CharSequence)"IVRRenderModels_006", (IntBuffer)this.errorPointer);
        this.checkInitError(this.errorPointer);
        VRSystem.VRSystem_GetRecommendedRenderTargetSize((IntBuffer)this.widthPointer, (IntBuffer)this.heightPointer);
        float renderTargetMultiplier = 1.0f;
        this.width = (int)((float)this.widthPointer.get(0) * renderTargetMultiplier);
        this.height = (int)((float)this.heightPointer.get(0) * renderTargetMultiplier);
        WorkspaceDirectory directory = new WorkspaceDirectory("ihmc-open-robotics-software", "ihmc-graphics/src/libgdx/resources", this.getClass(), "/vr");
        WorkspaceFile actionManifestFile = new WorkspaceFile(directory, "actions.json");
        JSONFileTools.load((WorkspaceFile)actionManifestFile, node -> {
            Iterator it = node.withArray("default_bindings").elements();
            while (it.hasNext()) {
                JsonNode objectNode = (JsonNode)it.next();
                String controllerBindings = objectNode.get("binding_url").asText();
                if (controllerBindings.contains("focus3")) {
                    this.controllerModel = RDXVRControllerModel.FOCUS3;
                    continue;
                }
                this.controllerModel = RDXVRControllerModel.INDEX;
            }
        });
        LogTools.info((String)"Using VR controller model: {}", (Object)((Object)this.controllerModel));
        VRInput.VRInput_SetActionManifestPath((CharSequence)actionManifestFile.getFilePath().toString());
        VRInput.VRInput_GetActionSetHandle((CharSequence)"/actions/main", (LongBuffer)this.mainActionSetHandle);
        this.headset.initSystem();
        for (RobotSide side : RobotSide.values) {
            ((RDXVRController)this.controllers.get((Enum)side)).initSystem();
        }
        this.activeActionSets = VRActiveActionSet.create((int)1);
        this.activeActionSets.ulActionSet(this.mainActionSetHandle.get(0));
        this.activeActionSets.ulRestrictedToDevice(0L);
    }

    public void setupEyes() {
        LogTools.info((String)"VR per eye render size: {} x {}", (Object)this.width, (Object)this.height);
        for (RobotSide side : RobotSide.values) {
            this.eyes.set((Enum)side, (Object)new RDXVREye(side, this.headset, this.width, this.height));
        }
    }

    private void checkInitError(IntBuffer errorBuffer) {
        if (errorBuffer.get(0) != 0) {
            int error = errorBuffer.get(0);
            throw new GdxRuntimeException("VR Initialization error: " + VR.VR_GetVRInitErrorAsEnglishDescription((int)error));
        }
    }

    public void waitGetPoses() {
        VRCompositor.VRCompositor_WaitGetPoses((TrackedDevicePose.Buffer)this.trackedDevicePoses, (TrackedDevicePose.Buffer)this.trackedDeviceGamePoses);
    }

    public void pollEvents() {
        VRInput.VRInput_UpdateActionState((VRActiveActionSet.Buffer)this.activeActionSets, (int)VRActiveActionSet.SIZEOF);
        this.headset.update(this.trackedDevicePoses);
        for (RobotSide side : RobotSide.values) {
            ((RDXVRController)this.controllers.get((Enum)side)).update(this.trackedDevicePoses);
        }
        while (VRSystem.VRSystem_PollNextEvent((VREvent)this.event)) {
            int n;
            int deviceIndex = this.event.trackedDeviceIndex();
            if (this.event.eventType() == 100) {
                n = VRSystem.VRSystem_GetTrackedDeviceClass((int)deviceIndex);
                if (n != 4) continue;
                this.baseStations.put(deviceIndex, new RDXVRBaseStation(this.vrPlayAreaYUpZBackFrame, deviceIndex));
                continue;
            }
            if (this.event.eventType() != 101 || (n = VRSystem.VRSystem_GetTrackedDeviceClass((int)deviceIndex)) != 4) continue;
            this.baseStations.remove(deviceIndex);
        }
        for (RobotSide side : RobotSide.values) {
            ((ArrayList)this.pickResults.get((Enum)side)).clear();
        }
        for (Consumer consumer : this.vrPickCalculators) {
            consumer.accept(this);
        }
        this.calculateSelectedPick();
        for (Consumer consumer : this.vrInputProcessors) {
            consumer.accept(this);
        }
    }

    private void calculateSelectedPick() {
        for (RobotSide side : RobotSide.values) {
            this.selectedPick.set((Enum)side, null);
            for (RDXVRPickResult pickResult : (ArrayList)this.pickResults.get((Enum)side)) {
                if (this.selectedPick.get((Enum)side) == null) {
                    this.selectedPick.set((Enum)side, (Object)pickResult);
                    continue;
                }
                if (!(pickResult.getDistanceToControllerPickPoint() < ((RDXVRPickResult)this.selectedPick.get((Enum)side)).getDistanceToControllerPickPoint())) continue;
                this.selectedPick.set((Enum)side, (Object)pickResult);
            }
        }
    }

    public void renderEyes(RDX3DScene scene) {
        for (RobotSide side : RobotSide.values) {
            ((RDXVREye)((Object)this.eyes.get((Enum)side))).render(scene);
        }
        VRCompositor.VRCompositor_Submit((int)0, (Texture)((RDXVREye)((Object)this.eyes.get((Enum)RobotSide.LEFT))).getOpenVRTexture(), null, (int)0);
        VRCompositor.VRCompositor_Submit((int)1, (Texture)((RDXVREye)((Object)this.eyes.get((Enum)RobotSide.RIGHT))).getOpenVRTexture(), null, (int)0);
        GL41.glFlush();
    }

    public void dispose() {
        for (RDXVREye eyeData : this.eyes) {
            eyeData.getFrameBuffer().dispose();
        }
        VR.VR_ShutdownInternal();
    }

    public void teleport(Consumer<RigidBodyTransform> teleportIHMCZUpToIHMCZUpWorldConsumer) {
        teleportIHMCZUpToIHMCZUpWorldConsumer.accept(this.teleportIHMCZUpToIHMCZUpWorld);
        this.teleportFrameIHMCZUp.update();
    }

    public void addVRPickCalculator(Consumer<RDXVRContext> calculateVRPick) {
        this.vrPickCalculators.add(calculateVRPick);
    }

    public void addVRInputProcessor(Consumer<RDXVRContext> processVRInput) {
        this.vrInputProcessors.add(processVRInput);
    }

    public void getHeadsetRenderable(Array<Renderable> renderables, Pool<Renderable> pool) {
        ModelInstance modelInstance;
        if (this.headset.isConnected() && (modelInstance = this.headset.getModelInstance()) != null) {
            modelInstance.getRenderables(renderables, pool);
        }
    }

    public void getControllerRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        for (RobotSide side : RobotSide.values) {
            ModelInstance modelInstance;
            RDXVRController controller = (RDXVRController)this.controllers.get((Enum)side);
            if (!controller.isConnected() || (modelInstance = controller.getModelInstance()) == null) continue;
            modelInstance.getRenderables(renderables, pool);
            controller.getPickPoseSphere().getRenderables(renderables, pool);
        }
    }

    public void getBaseStationRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        for (RDXVRBaseStation baseStation : this.baseStations.values()) {
            ModelInstance modelInstance = baseStation.getModelInstance();
            if (modelInstance == null) continue;
            modelInstance.getRenderables(renderables, pool);
        }
    }

    public RDXVRController getController(RobotSide side) {
        return (RDXVRController)this.controllers.get((Enum)side);
    }

    public RDXVRHeadset getHeadset() {
        return this.headset;
    }

    public Collection<RDXVRBaseStation> getBaseStations() {
        return this.baseStations.values();
    }

    public SideDependentList<RDXVREye> getEyes() {
        return this.eyes;
    }

    public ReferenceFrame getOpenVRPlayAreaYUpFrame() {
        return this.vrPlayAreaYUpZBackFrame;
    }

    public ReferenceFrame getTeleportFrameIHMCZUp() {
        return this.teleportFrameIHMCZUp;
    }

    public RigidBodyTransform getTeleportIHMCZUpToIHMCZUpWorld() {
        return this.teleportIHMCZUpToIHMCZUpWorld;
    }

    public void addPickResult(RobotSide side, RDXVRPickResult pickResult) {
        ((ArrayList)this.pickResults.get((Enum)side)).add(pickResult);
    }

    public SideDependentList<RDXVRPickResult> getSelectedPick() {
        return this.selectedPick;
    }

    public RDXVRControllerModel getControllerModel() {
        return this.controllerModel;
    }
}

