/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.visualizers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.math.Frustum;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.RDXModelBuilder;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;

public class RDXFrustumVisualizer
implements RenderableProvider {
    private final ResettableExceptionHandlingExecutorService executorService = MissingThreadTools.newSingleThreadExecutor((String)this.getClass().getSimpleName(), (boolean)true, (int)1);
    private ModelInstance modelInstance;
    private Model lastModel;
    private volatile Runnable buildMeshAndCreateModelInstance = null;
    private final Point3D[] vertices = new Point3D[16];
    private final Color color = new Color(0.7f, 0.7f, 0.7f, 1.0f);

    public RDXFrustumVisualizer() {
        for (int i = 0; i < this.vertices.length; ++i) {
            this.vertices[i] = new Point3D();
        }
    }

    public void update() {
        if (this.buildMeshAndCreateModelInstance != null) {
            this.buildMeshAndCreateModelInstance.run();
            this.buildMeshAndCreateModelInstance = null;
        }
    }

    public void setColor(Color color) {
        this.color.set(color);
    }

    public void generateMeshAsync(Frustum frustum) {
        this.executorService.clearQueueAndExecute(() -> this.generateMesh(frustum));
    }

    public synchronized void generateMesh(Frustum frustum) {
        LibGDXTools.toEuclid(frustum.planePoints[0], (Point3DBasics)this.vertices[0]);
        LibGDXTools.toEuclid(frustum.planePoints[1], (Point3DBasics)this.vertices[1]);
        LibGDXTools.toEuclid(frustum.planePoints[2], (Point3DBasics)this.vertices[2]);
        LibGDXTools.toEuclid(frustum.planePoints[3], (Point3DBasics)this.vertices[3]);
        LibGDXTools.toEuclid(frustum.planePoints[0], (Point3DBasics)this.vertices[4]);
        LibGDXTools.toEuclid(frustum.planePoints[4], (Point3DBasics)this.vertices[5]);
        LibGDXTools.toEuclid(frustum.planePoints[7], (Point3DBasics)this.vertices[6]);
        LibGDXTools.toEuclid(frustum.planePoints[3], (Point3DBasics)this.vertices[7]);
        LibGDXTools.toEuclid(frustum.planePoints[7], (Point3DBasics)this.vertices[8]);
        LibGDXTools.toEuclid(frustum.planePoints[6], (Point3DBasics)this.vertices[9]);
        LibGDXTools.toEuclid(frustum.planePoints[2], (Point3DBasics)this.vertices[10]);
        LibGDXTools.toEuclid(frustum.planePoints[6], (Point3DBasics)this.vertices[11]);
        LibGDXTools.toEuclid(frustum.planePoints[5], (Point3DBasics)this.vertices[12]);
        LibGDXTools.toEuclid(frustum.planePoints[1], (Point3DBasics)this.vertices[13]);
        LibGDXTools.toEuclid(frustum.planePoints[5], (Point3DBasics)this.vertices[14]);
        LibGDXTools.toEuclid(frustum.planePoints[4], (Point3DBasics)this.vertices[15]);
        this.buildMeshAndCreateModelInstance = () -> {
            if (this.lastModel != null) {
                this.lastModel.dispose();
            }
            this.lastModel = RDXModelBuilder.buildModel(meshBuilder -> {
                double lineWidth = 0.01;
                meshBuilder.addMultiLine((Point3DReadOnly[])this.vertices, lineWidth, this.color, false);
            }, "box");
            this.modelInstance = new ModelInstance(this.lastModel);
        };
    }

    public void dispose() {
        this.executorService.destroy();
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        if (this.modelInstance != null) {
            this.modelInstance.getRenderables(renderables, pool);
        }
    }
}

