/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import imgui.internal.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImFloat;
import java.util.Random;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.graphicsDescription.MeshDataGenerator;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.rdx.RDXFocusBasedCamera;
import us.ihmc.rdx.imgui.ImGuiPanel;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;
import us.ihmc.rdx.input.ImGui3DViewInput;
import us.ihmc.rdx.input.ImGui3DViewPickResult;
import us.ihmc.rdx.input.ImGuiMouseDragData;
import us.ihmc.rdx.mesh.RDXMeshBuilder;
import us.ihmc.rdx.mesh.RDXMeshDataInterpreter;
import us.ihmc.rdx.mesh.RDXMultiColorMeshBuilder;
import us.ihmc.rdx.sceneManager.RDXSceneLevel;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.ui.RDX3DPanel;
import us.ihmc.rdx.ui.gizmo.Axis3DRotations;
import us.ihmc.rdx.ui.gizmo.ClockFaceRotation3DMouseDragAlgorithm;
import us.ihmc.rdx.ui.gizmo.DiscreteArrowRayIntersection;
import us.ihmc.rdx.ui.gizmo.DiscreteTorusRayIntersection;
import us.ihmc.rdx.ui.gizmo.DynamicLibGDXModel;
import us.ihmc.rdx.ui.gizmo.Line3DMouseDragAlgorithm;
import us.ihmc.rdx.ui.gizmo.RDXGizmoTools;
import us.ihmc.rdx.ui.gizmo.SixDoFSelection;
import us.ihmc.rdx.ui.gizmo.SphereRayIntersection;
import us.ihmc.robotics.referenceFrames.ModifiableReferenceFrame;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;
import us.ihmc.robotics.robotSide.RobotSide;

public class RDXPose3DGizmo
implements RenderableProvider {
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final ImFloat torusRadius = new ImFloat(0.5f);
    private final ImFloat torusCameraSize = new ImFloat(0.067f);
    private final ImFloat torusTubeRadiusRatio = new ImFloat(0.074f);
    private final ImFloat arrowLengthRatio = new ImFloat(0.431f);
    private final ImFloat arrowHeadBodyLengthRatio = new ImFloat(0.48f);
    private final ImFloat arrowHeadBodyRadiusRatio = new ImFloat(2.0f);
    private final ImFloat arrowSpacingFactor = new ImFloat(2.22f);
    private final ImBoolean resizeAutomatically = new ImBoolean(true);
    private double arrowBodyRadius;
    private double arrowLength;
    private double arrowBodyLength;
    private double arrowHeadRadius;
    private double arrowHeadLength;
    private double arrowSpacing;
    private final Material[] normalMaterials = new Material[3];
    private final Material[] highlightedMaterials = new Material[3];
    private final Axis3DRotations axisRotations = new Axis3DRotations();
    private final DynamicLibGDXModel[] arrowModels = new DynamicLibGDXModel[3];
    private final DynamicLibGDXModel[] torusModels = new DynamicLibGDXModel[3];
    private final Point3D closestCollision = new Point3D();
    private SixDoFSelection closestCollisionSelection;
    private double closestCollisionDistance;
    private final ImGui3DViewPickResult pickResult = new ImGui3DViewPickResult();
    private boolean isGizmoHovered = false;
    private boolean isBeingManipulated = false;
    private final SphereRayIntersection boundingSphereIntersection = new SphereRayIntersection();
    private final DiscreteTorusRayIntersection torusIntersection = new DiscreteTorusRayIntersection();
    private final DiscreteArrowRayIntersection arrowIntersection = new DiscreteArrowRayIntersection();
    private final FramePose3D framePose3D = new FramePose3D();
    private final FramePose3D tempFramePose3D = new FramePose3D();
    private RigidBodyTransform transformToParent;
    private ReferenceFrame parentReferenceFrame;
    private ReferenceFrame gizmoFrame;
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private final RigidBodyTransform transformToWorld = new RigidBodyTransform();
    private static final YawPitchRoll FLIP_180 = new YawPitchRoll(0.0, Math.PI, 0.0);
    private final Line3DMouseDragAlgorithm lineDragAlgorithm = new Line3DMouseDragAlgorithm();
    private final ClockFaceRotation3DMouseDragAlgorithm clockFaceDragAlgorithm = new ClockFaceRotation3DMouseDragAlgorithm();
    private RDXFocusBasedCamera camera3D;
    private final FramePose3D keyboardAdjustmentPose3D = new FramePose3D();
    private ModifiableReferenceFrame keyboardTransformationFrameInWorld;
    private final Point3D cameraPosition = new Point3D();
    private double distanceToCamera;
    private double lastDistanceToCamera = -1.0;
    private final double translateSpeedFactor = 0.5;
    private boolean queuePopupToOpen = false;
    private final Random random = new Random();

    public RDXPose3DGizmo() {
        this(ReferenceFrame.getWorldFrame());
    }

    public RDXPose3DGizmo(ReferenceFrame parentReferenceFrame) {
        RigidBodyTransform transformToParent = new RigidBodyTransform();
        ReferenceFrame gizmoFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((ReferenceFrame)parentReferenceFrame, (RigidBodyTransform)transformToParent);
        this.initialize(gizmoFrame, transformToParent);
    }

    public RDXPose3DGizmo(ReferenceFrame gizmoFrame, RigidBodyTransform gizmoTransformToParentFrameToModify) {
        this.initialize(gizmoFrame, gizmoTransformToParentFrameToModify);
    }

    private void initialize(ReferenceFrame gizmoFrame, RigidBodyTransform gizmoTransformToParentFrameToModify) {
        this.parentReferenceFrame = gizmoFrame.getParent();
        this.transformToParent = gizmoTransformToParentFrameToModify;
        this.gizmoFrame = gizmoFrame;
        this.keyboardTransformationFrameInWorld = new ModifiableReferenceFrame(ReferenceFrame.getWorldFrame());
    }

    public void setParentFrame(ReferenceFrame parentReferenceFrame) {
        this.parentReferenceFrame = parentReferenceFrame;
        this.gizmoFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((ReferenceFrame)parentReferenceFrame, (RigidBodyTransform)this.transformToParent);
    }

    public void createAndSetupDefault(RDX3DPanel panel3D) {
        this.create(panel3D);
        panel3D.addImGui3DViewPickCalculator(this::calculate3DViewPick);
        panel3D.addImGui3DViewInputProcessor(this::process3DViewInput);
        panel3D.getScene().addRenderableProvider(this, RDXSceneLevel.VIRTUAL);
    }

    public void create(RDX3DPanel panel3D) {
        this.camera3D = panel3D.getCamera3D();
        panel3D.addImGuiOverlayAddition(this::renderTooltipAndContextMenu);
        for (Axis3D axis : Axis3D.values) {
            Color color = RDXGizmoTools.AXIS_COLORS[axis.ordinal()];
            this.normalMaterials[axis.ordinal()] = new Material();
            this.normalMaterials[axis.ordinal()].set((Attribute)TextureAttribute.createDiffuse((Texture)RDXMultiColorMeshBuilder.loadPaletteTexture()));
            this.normalMaterials[axis.ordinal()].set((Attribute)new BlendingAttribute(true, color.a));
            this.highlightedMaterials[axis.ordinal()] = new Material();
            this.highlightedMaterials[axis.ordinal()].set((Attribute)TextureAttribute.createDiffuse((Texture)RDXMultiColorMeshBuilder.loadPaletteTexture()));
            this.highlightedMaterials[axis.ordinal()].set((Attribute)new BlendingAttribute(true, RDXGizmoTools.AXIS_SELECTED_COLORS[axis.ordinal()].a));
            this.arrowModels[axis.ordinal()] = new DynamicLibGDXModel();
            this.arrowModels[axis.ordinal()].setMesh(meshBuilder -> {
                meshBuilder.addCylinder(this.arrowBodyLength, this.arrowBodyRadius, (Tuple3DReadOnly)new Point3D(0.0, 0.0, 0.5 * this.arrowSpacing), color);
                meshBuilder.addCone(this.arrowHeadLength, this.arrowHeadRadius, (Tuple3DReadOnly)new Point3D(0.0, 0.0, 0.5 * this.arrowSpacing + this.arrowBodyLength), color);
                meshBuilder.addCylinder(this.arrowBodyLength, this.arrowBodyRadius, (Tuple3DReadOnly)new Point3D(0.0, 0.0, -0.5 * this.arrowSpacing), (Orientation3DReadOnly)FLIP_180, color);
            });
            this.torusModels[axis.ordinal()] = new DynamicLibGDXModel();
            int resolution = 25;
            this.torusModels[axis.ordinal()].setMesh(meshBuilder -> meshBuilder.addArcTorus(0.0, Math.PI * 2, this.torusRadius.get(), this.torusTubeRadiusRatio.get() * this.torusRadius.get(), resolution, color));
        }
        this.recreateGraphics();
    }

    public void calculate3DViewPick(ImGui3DViewInput input) {
        this.updateTransforms();
        boolean isWindowHovered = ImGui.isWindowHovered();
        ImGuiMouseDragData manipulationDragData = input.getMouseDragData(0);
        if (isWindowHovered && (!manipulationDragData.isDragging() || manipulationDragData.getDragJustStarted())) {
            Line3DReadOnly pickRay = input.getPickRayInWorld();
            this.determineCurrentSelectionFromPickRay(pickRay);
            if (this.closestCollisionSelection != null) {
                this.pickResult.setDistanceToCamera(this.closestCollisionDistance);
                input.addPickResult(this.pickResult);
            }
        }
    }

    public void process3DViewInput(ImGui3DViewInput input) {
        boolean anyArrowHeld;
        this.updateTransforms();
        ImGuiMouseDragData manipulationDragData = input.getMouseDragData(0);
        boolean bl = this.isGizmoHovered = input.isWindowHovered() && this.pickResult == input.getClosestPick();
        if (this.isGizmoHovered && ImGui.getMouseClickedCount((int)1) == 1) {
            this.queuePopupToOpen = true;
        }
        this.updateMaterialHighlighting();
        if (this.isGizmoHovered && manipulationDragData.getDragJustStarted()) {
            this.clockFaceDragAlgorithm.reset();
            manipulationDragData.setObjectBeingDragged(this);
        }
        boolean bl2 = this.isBeingManipulated = manipulationDragData.getObjectBeingDragged() == this;
        if (this.isBeingManipulated) {
            Line3DReadOnly pickRay = input.getPickRayInWorld();
            if (this.closestCollisionSelection.isLinear()) {
                Vector3DReadOnly linearMotion = this.lineDragAlgorithm.calculate(pickRay, this.closestCollision, this.axisRotations.get(this.closestCollisionSelection.toAxis3D()), (RigidBodyTransformReadOnly)this.transformToWorld);
                this.tempFramePose3D.setToZero(this.gizmoFrame);
                this.tempFramePose3D.changeFrame(ReferenceFrame.getWorldFrame());
                this.tempFramePose3D.getPosition().add((Tuple3DReadOnly)linearMotion);
                this.tempFramePose3D.changeFrame(this.parentReferenceFrame);
                this.tempFramePose3D.get((RigidBodyTransformBasics)this.transformToParent);
                this.closestCollision.add((Tuple3DReadOnly)linearMotion);
            } else if (this.closestCollisionSelection.isAngular() && this.clockFaceDragAlgorithm.calculate(pickRay, this.closestCollision, (RotationMatrixReadOnly)this.axisRotations.get(this.closestCollisionSelection.toAxis3D()), (RigidBodyTransformReadOnly)this.transformToWorld)) {
                this.tempFramePose3D.setToZero(this.gizmoFrame);
                this.tempFramePose3D.changeFrame(ReferenceFrame.getWorldFrame());
                this.clockFaceDragAlgorithm.getMotion().transform((Orientation3DBasics)this.tempFramePose3D.getOrientation());
                this.tempFramePose3D.changeFrame(this.parentReferenceFrame);
                this.tempFramePose3D.get((RigidBodyTransformBasics)this.transformToParent);
            }
        }
        if (ImGui.getIO().getKeyCtrl() && input.getMouseWheelDelta() != 0.0f) {
            float deltaScroll = input.getMouseWheelDelta();
            this.tempFramePose3D.setToZero(this.gizmoFrame);
            this.tempFramePose3D.changeFrame(ReferenceFrame.getWorldFrame());
            double noise = this.random.nextDouble() * 0.005;
            double speed = 0.012 + noise;
            this.tempFramePose3D.getOrientation().appendYawRotation((double)Math.signum(deltaScroll) * speed * Math.PI);
            this.tempFramePose3D.changeFrame(this.parentReferenceFrame);
            this.tempFramePose3D.get((RigidBodyTransformBasics)this.transformToParent);
        }
        boolean upArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getUpArrowKey());
        boolean downArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getDownArrowKey());
        boolean leftArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getLeftArrowKey());
        boolean rightArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getRightArrowKey());
        boolean bl3 = anyArrowHeld = upArrowHeld || downArrowHeld || leftArrowHeld || rightArrowHeld;
        if (anyArrowHeld) {
            this.keyboardTransformationFrameInWorld.getTransformToParent().setToZero();
            this.keyboardTransformationFrameInWorld.getTransformToParent().getRotation().setToYawOrientation(this.camera3D.getFocusPointPose().getYaw());
            this.keyboardTransformationFrameInWorld.getReferenceFrame().update();
            this.keyboardAdjustmentPose3D.setToZero(this.gizmoFrame);
            this.keyboardAdjustmentPose3D.changeFrame(this.keyboardTransformationFrameInWorld.getReferenceFrame());
            boolean ctrlHeld = ImGui.getIO().getKeyCtrl();
            boolean altHeld = ImGui.getIO().getKeyAlt();
            boolean shiftHeld = ImGui.getIO().getKeyShift();
            double deltaTime = Gdx.graphics.getDeltaTime();
            if (altHeld) {
                double amount = deltaTime * (shiftHeld ? 0.2 : 1.0);
                if (upArrowHeld) {
                    this.keyboardAdjustmentPose3D.getOrientation().appendPitchRotation(amount);
                }
                if (downArrowHeld) {
                    this.keyboardAdjustmentPose3D.getOrientation().appendPitchRotation(-amount);
                }
                if (rightArrowHeld && !ctrlHeld) {
                    this.keyboardAdjustmentPose3D.getOrientation().appendRollRotation(amount);
                }
                if (leftArrowHeld && !ctrlHeld) {
                    this.keyboardAdjustmentPose3D.getOrientation().appendRollRotation(-amount);
                }
                if (leftArrowHeld && ctrlHeld) {
                    this.keyboardAdjustmentPose3D.getOrientation().appendYawRotation(amount);
                }
                if (rightArrowHeld && ctrlHeld) {
                    this.keyboardAdjustmentPose3D.getOrientation().appendYawRotation(-amount);
                }
            } else {
                double amount = deltaTime * (shiftHeld ? 0.05 : 0.4);
                this.distanceToCamera = this.cameraPosition.distance((Point3DReadOnly)this.framePose3D.getPosition());
                if (upArrowHeld && !ctrlHeld) {
                    this.keyboardAdjustmentPose3D.getPosition().addX(this.getTranslateSpeedFactor() * amount);
                }
                if (downArrowHeld && !ctrlHeld) {
                    this.keyboardAdjustmentPose3D.getPosition().subX(this.getTranslateSpeedFactor() * amount);
                }
                if (leftArrowHeld) {
                    this.keyboardAdjustmentPose3D.getPosition().addY(this.getTranslateSpeedFactor() * amount);
                }
                if (rightArrowHeld) {
                    this.keyboardAdjustmentPose3D.getPosition().subY(this.getTranslateSpeedFactor() * amount);
                }
                if (upArrowHeld && ctrlHeld) {
                    this.keyboardAdjustmentPose3D.getPosition().addZ(this.getTranslateSpeedFactor() * amount);
                }
                if (downArrowHeld && ctrlHeld) {
                    this.keyboardAdjustmentPose3D.getPosition().subZ(this.getTranslateSpeedFactor() * amount);
                }
            }
            this.keyboardAdjustmentPose3D.changeFrame(this.parentReferenceFrame);
            this.keyboardAdjustmentPose3D.get((RigidBodyTransformBasics)this.transformToParent);
        }
        this.updateTransforms();
        if (this.resizeAutomatically.get()) {
            LibGDXTools.toEuclid(this.camera3D.position, (Point3DBasics)this.cameraPosition);
            this.distanceToCamera = this.cameraPosition.distance((Point3DReadOnly)this.framePose3D.getPosition());
            if (this.lastDistanceToCamera != this.distanceToCamera) {
                this.lastDistanceToCamera = this.distanceToCamera;
                this.recreateGraphics();
                this.updateTransforms();
            }
        }
    }

    private void renderTooltipAndContextMenu() {
        if (this.queuePopupToOpen) {
            this.queuePopupToOpen = false;
            ImGui.openPopup((String)this.labels.get("Popup"));
        }
        if (ImGui.beginPopup((String)this.labels.get("Popup"))) {
            this.renderImGuiTuner();
            if (ImGui.menuItem((String)"Cancel")) {
                ImGui.closeCurrentPopup();
            }
            ImGui.endPopup();
        }
    }

    public void updateTransforms() {
        this.gizmoFrame.update();
        for (Axis3D axis : Axis3D.values) {
            this.framePose3D.setToZero(this.gizmoFrame);
            this.framePose3D.getOrientation().setAndNormalize((Orientation3DReadOnly)this.axisRotations.get(axis));
            this.framePose3D.changeFrame(ReferenceFrame.getWorldFrame());
            this.framePose3D.get((RigidBodyTransformBasics)this.tempTransform);
            LibGDXTools.toLibGDX(this.tempTransform, this.arrowModels[axis.ordinal()].getOrCreateModelInstance().transform);
            LibGDXTools.toLibGDX(this.tempTransform, this.torusModels[axis.ordinal()].getOrCreateModelInstance().transform);
        }
        this.tempFramePose3D.setToZero(this.gizmoFrame);
        this.tempFramePose3D.changeFrame(ReferenceFrame.getWorldFrame());
        this.tempFramePose3D.get((RigidBodyTransformBasics)this.transformToWorld);
    }

    private void determineCurrentSelectionFromPickRay(Line3DReadOnly pickRay) {
        this.closestCollisionSelection = null;
        this.closestCollisionDistance = Double.POSITIVE_INFINITY;
        this.boundingSphereIntersection.update(1.5 * (double)this.torusRadius.get(), (RigidBodyTransformReadOnly)this.transformToWorld);
        if (this.boundingSphereIntersection.intersect(pickRay)) {
            for (Axis3D axis : Axis3D.values) {
                LibGDXTools.toEuclid(this.torusModels[axis.ordinal()].getOrCreateModelInstance().transform, this.tempTransform);
                this.torusIntersection.update(this.torusRadius.get(), this.torusTubeRadiusRatio.get() * this.torusRadius.get(), (RigidBodyTransformReadOnly)this.tempTransform);
                double distance = this.torusIntersection.intersect(pickRay, 100);
                if (Double.isNaN(distance) || !(distance < this.closestCollisionDistance)) continue;
                this.closestCollisionDistance = distance;
                this.closestCollisionSelection = SixDoFSelection.toAngularSelection(axis);
                this.closestCollision.set(this.torusIntersection.getClosestIntersection());
            }
            for (Axis3D axis : Axis3D.values) {
                LibGDXTools.toEuclid(this.arrowModels[axis.ordinal()].getOrCreateModelInstance().transform, this.tempTransform);
                for (RobotSide side : RobotSide.values) {
                    double zOffset = side.negateIfRightSide(0.5 * this.arrowSpacing + 0.5 * this.arrowBodyLength);
                    this.arrowIntersection.update(this.arrowBodyLength, this.arrowBodyRadius, this.arrowHeadRadius, this.arrowHeadLength, zOffset, (RigidBodyTransformReadOnly)this.tempTransform);
                    double distance = this.arrowIntersection.intersect(pickRay, 100, side == RobotSide.LEFT);
                    if (Double.isNaN(distance) || !(distance < this.closestCollisionDistance)) continue;
                    this.closestCollisionDistance = distance;
                    this.closestCollisionSelection = SixDoFSelection.toLinearSelection(axis);
                    this.closestCollision.set(this.arrowIntersection.getIntersection());
                }
            }
        }
    }

    private void updateMaterialHighlighting() {
        boolean prior = (this.isGizmoHovered || this.isBeingManipulated) && this.closestCollisionSelection != null;
        for (Axis3D axis : Axis3D.values) {
            if (prior && this.closestCollisionSelection.isAngular() && this.closestCollisionSelection.toAxis3D() == axis) {
                this.torusModels[axis.ordinal()].setMaterial(this.highlightedMaterials[axis.ordinal()]);
            } else {
                this.torusModels[axis.ordinal()].setMaterial(this.normalMaterials[axis.ordinal()]);
            }
            if (prior && this.closestCollisionSelection.isLinear() && this.closestCollisionSelection.toAxis3D() == axis) {
                this.arrowModels[axis.ordinal()].setMaterial(this.highlightedMaterials[axis.ordinal()]);
                continue;
            }
            this.arrowModels[axis.ordinal()].setMaterial(this.normalMaterials[axis.ordinal()]);
        }
    }

    public ImGuiPanel createTunerPanel(String name) {
        return new ImGuiPanel("Pose3D Gizmo Tuner (" + name + ")", this::renderImGuiTuner);
    }

    public void renderImGuiTuner() {
        ImGui.text((String)("Parent frame: " + this.parentReferenceFrame.getName()));
        ImGui.checkbox((String)"Resize based on camera distance", (ImBoolean)this.resizeAutomatically);
        boolean proportionsChanged = false;
        ImGui.pushItemWidth((float)100.0f);
        proportionsChanged = this.resizeAutomatically.get() ? (proportionsChanged |= ImGui.dragFloat((String)this.labels.get("Torus camera size"), (float[])this.torusCameraSize.getData(), (float)0.001f)) : (proportionsChanged |= ImGui.dragFloat((String)this.labels.get("Torus radius"), (float[])this.torusRadius.getData(), (float)0.001f));
        ImGui.popItemWidth();
        if (ImGui.collapsingHeader((String)this.labels.get("Advanced"))) {
            if (ImGui.button((String)"Set to zero in parent frame")) {
                this.transformToParent.setToZero();
            }
            ImGui.pushItemWidth((float)100.0f);
            proportionsChanged |= ImGui.dragFloat((String)this.labels.get("Torus tube radius ratio"), (float[])this.torusTubeRadiusRatio.getData(), (float)0.001f);
            proportionsChanged |= ImGui.dragFloat((String)this.labels.get("Arrow length ratio"), (float[])this.arrowLengthRatio.getData(), (float)0.05f);
            proportionsChanged |= ImGui.dragFloat((String)this.labels.get("Arrow head body length ratio"), (float[])this.arrowHeadBodyLengthRatio.getData(), (float)0.05f);
            proportionsChanged |= ImGui.dragFloat((String)this.labels.get("Arrow head body radius ratio"), (float[])this.arrowHeadBodyRadiusRatio.getData(), (float)0.05f);
            proportionsChanged |= ImGui.dragFloat((String)this.labels.get("Arrow spacing factor"), (float[])this.arrowSpacingFactor.getData(), (float)0.05f);
            ImGui.popItemWidth();
        }
        if (proportionsChanged) {
            this.recreateGraphics();
        }
        ImGui.text((String)"Drag using the left mouse button to manipulate the gizmo.");
        this.updateTransforms();
    }

    private void recreateGraphics() {
        if (this.resizeAutomatically.get()) {
            if (this.lastDistanceToCamera > 0.0) {
                this.torusRadius.set(this.torusCameraSize.get() * (float)this.lastDistanceToCamera);
            } else {
                this.torusRadius.set(this.torusCameraSize.get());
            }
        }
        this.arrowBodyRadius = this.torusTubeRadiusRatio.get() * this.torusRadius.get();
        this.arrowLength = this.arrowLengthRatio.get() * this.torusRadius.get();
        this.arrowBodyLength = (1.0 - (double)this.arrowHeadBodyLengthRatio.get()) * this.arrowLength;
        this.arrowHeadRadius = (double)this.arrowHeadBodyRadiusRatio.get() * this.arrowBodyRadius;
        this.arrowHeadLength = (double)this.arrowHeadBodyLengthRatio.get() * this.arrowLength;
        this.arrowSpacing = this.arrowSpacingFactor.get() * (this.torusRadius.get() + this.torusTubeRadiusRatio.get() * this.torusRadius.get());
        this.updateMaterialHighlighting();
        for (Axis3D axis : Axis3D.values) {
            this.arrowModels[axis.ordinal()].invalidateMesh();
            this.torusModels[axis.ordinal()].invalidateMesh();
        }
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        for (Axis3D axis : Axis3D.values) {
            this.arrowModels[axis.ordinal()].getOrCreateModelInstance().getRenderables(renderables, pool);
            this.torusModels[axis.ordinal()].getOrCreateModelInstance().getRenderables(renderables, pool);
        }
    }

    public FramePose3DReadOnly getPose() {
        return this.framePose3D;
    }

    public RigidBodyTransform getTransformToParent() {
        return this.transformToParent;
    }

    public ReferenceFrame getGizmoFrame() {
        return this.gizmoFrame;
    }

    public static Mesh angularHighlightMesh(double majorRadius, double minorRadius) {
        return RDXPose3DGizmo.tetrahedronRingMesh(1.75 * minorRadius, 1.25 * minorRadius, 5);
    }

    public static Mesh linearControlHighlightMesh(double bodyRadius, double bodyLength, double spacing) {
        RDXMeshBuilder meshBuilder = new RDXMeshBuilder();
        int numberOfHighlights = 5;
        Point3D center = new Point3D(0.0, 0.0, 0.5 * spacing + 0.33 * bodyLength);
        MeshDataHolder ringMesh = RDXPose3DGizmo.tetrahedronRingMeshDataHolder(1.75 * bodyRadius, 1.25 * bodyRadius, numberOfHighlights);
        meshBuilder.addMesh(ringMesh, (Tuple3DReadOnly)center);
        center.negate();
        meshBuilder.addMesh(ringMesh, (Tuple3DReadOnly)center);
        return meshBuilder.generateMesh();
    }

    public static Mesh tetrahedronRingMesh(double ringRadius, double tetrahedronSize, int numberOfTetrahedrons) {
        return RDXMeshDataInterpreter.interpretMeshData(RDXPose3DGizmo.tetrahedronRingMeshDataHolder(ringRadius, tetrahedronSize, numberOfTetrahedrons));
    }

    public static MeshDataHolder tetrahedronRingMeshDataHolder(double ringRadius, double tetrahedronSize, int numberOfTetrahedrons) {
        RDXMeshBuilder meshBuilder = new RDXMeshBuilder();
        Point3D position = new Point3D();
        Point3D offset = new Point3D();
        Quaternion orientation = new Quaternion();
        for (int i = 0; i < numberOfTetrahedrons; ++i) {
            MeshDataHolder tetrahedron = MeshDataGenerator.Tetrahedron((double)tetrahedronSize);
            orientation.setToYawOrientation((double)i * 2.0 * Math.PI / (double)numberOfTetrahedrons);
            orientation.appendPitchRotation(1.5707963267948966);
            offset.set(0.0, 0.0, ringRadius);
            orientation.transform((Tuple3DBasics)offset);
            position.set(offset);
            meshBuilder.addMesh(tetrahedron, (Tuple3DReadOnly)position, (Orientation3DReadOnly)orientation);
        }
        return meshBuilder.generateMeshDataHolder();
    }

    private double getTranslateSpeedFactor() {
        return 0.5 * this.distanceToCamera;
    }

    public void setResizeAutomatically(boolean resizeAutomatically) {
        this.resizeAutomatically.set(resizeAutomatically);
    }

    ClockFaceRotation3DMouseDragAlgorithm getClockFaceDragAlgorithm() {
        return this.clockFaceDragAlgorithm;
    }
}

