/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import imgui.internal.ImGui;
import imgui.type.ImFloat;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.rdx.RDXFocusBasedCamera;
import us.ihmc.rdx.imgui.ImGuiPanel;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.input.ImGui3DViewInput;
import us.ihmc.rdx.input.ImGui3DViewPickResult;
import us.ihmc.rdx.input.ImGuiMouseDragData;
import us.ihmc.rdx.mesh.RDXMultiColorMeshBuilder;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.ui.gizmo.BoxRayIntersection;
import us.ihmc.rdx.ui.gizmo.ClockFaceRotation3DMouseDragAlgorithm;
import us.ihmc.rdx.ui.gizmo.DiscreteIsoscelesTriangularPrismRayIntersection;
import us.ihmc.rdx.ui.gizmo.DynamicLibGDXModel;
import us.ihmc.rdx.ui.gizmo.HollowCylinderRayIntersection;
import us.ihmc.rdx.ui.gizmo.Plane3DMouseDragAlgorithm;
import us.ihmc.rdx.ui.gizmo.RDXGizmoTools;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;

public class RDXPathControlRingGizmo
implements RenderableProvider {
    public static final Color DISC_COLOR = RDXGizmoTools.CENTER_DEFAULT_COLOR;
    public static final Color X_ARROW_COLOR = RDXGizmoTools.X_AXIS_DEFAULT_COLOR;
    public static final Color Y_ARROW_COLOR = RDXGizmoTools.Y_AXIS_DEFAULT_COLOR;
    private final double QUARTER_TURN = 1.5707963267948966;
    private final ImFloat discOuterRadius = new ImFloat(0.426f);
    private final ImFloat discInnerRadius = new ImFloat(0.29f);
    private final ImFloat discThickness = new ImFloat(0.03f);
    private final ImFloat arrowWidth = new ImFloat(0.257f);
    private final ImFloat arrowHeight = new ImFloat(0.137f);
    private final ImFloat arrowSpacing = new ImFloat(0.079f);
    private final ImFloat arrowTailWidthRatio = new ImFloat(0.5f);
    private final ImFloat arrowTailLengthRatio = new ImFloat(1.0f);
    private Material normalMaterial;
    private Material highlightedMaterial;
    private DynamicLibGDXModel discModel = new DynamicLibGDXModel();
    private DynamicLibGDXModel positiveXArrowModel = new DynamicLibGDXModel();
    private DynamicLibGDXModel positiveYArrowModel = new DynamicLibGDXModel();
    private DynamicLibGDXModel negativeXArrowModel = new DynamicLibGDXModel();
    private DynamicLibGDXModel negativeYArrowModel = new DynamicLibGDXModel();
    private final RigidBodyTransform xArrowTailTransform = new RigidBodyTransform();
    private final RigidBodyTransform yArrowTailTransform = new RigidBodyTransform();
    private final RigidBodyTransform temporaryTailTransform = new RigidBodyTransform();
    private final Point3D closestCollision = new Point3D();
    private int closestCollisionSelection = -1;
    private double closestCollisionDistance;
    private final ImGui3DViewPickResult pickResult = new ImGui3DViewPickResult();
    private boolean isGizmoHovered = false;
    private boolean isBeingManipulated = false;
    private final HollowCylinderRayIntersection hollowCylinderIntersection = new HollowCylinderRayIntersection();
    private final DiscreteIsoscelesTriangularPrismRayIntersection positiveXArrowIntersection = new DiscreteIsoscelesTriangularPrismRayIntersection();
    private final DiscreteIsoscelesTriangularPrismRayIntersection positiveYArrowIntersection = new DiscreteIsoscelesTriangularPrismRayIntersection();
    private final BoxRayIntersection negativeXArrowIntersection = new BoxRayIntersection();
    private final BoxRayIntersection negativeYArrowIntersection = new BoxRayIntersection();
    private final RigidBodyTransform transformToParent;
    private ReferenceFrame parentReferenceFrame;
    private ReferenceFrame gizmoFrame;
    private final RigidBodyTransform controlRingTransformToWorld = new RigidBodyTransform();
    private final FramePose3D controlRingPose = new FramePose3D();
    private final FramePose3D tempFramePose3D = new FramePose3D();
    private RDXFocusBasedCamera camera3D;
    private final RigidBodyTransform tempTransform = new RigidBodyTransform();
    private final RigidBodyTransform transformFromKeyboardTransformationToWorld = new RigidBodyTransform();
    private ReferenceFrame keyboardTransformationFrame;
    private final Point3D cameraPosition = new Point3D();
    private double distanceToCamera;
    private double lastDistanceToCamera = -1.0;
    private final Plane3DMouseDragAlgorithm planeDragAlgorithm = new Plane3DMouseDragAlgorithm();
    private final ClockFaceRotation3DMouseDragAlgorithm clockFaceDragAlgorithm = new ClockFaceRotation3DMouseDragAlgorithm();
    private boolean hollowCylinderIntersects;
    private boolean positiveXArrowIntersects;
    private boolean positiveYArrowIntersects;
    private boolean negativeXArrowIntersects;
    private boolean negativeYArrowIntersects;
    private boolean showArrows = true;
    private boolean highlightingEnabled = true;
    private boolean isNewlyModified;
    private final double translateSpeedFactor = 0.5;

    public RDXPathControlRingGizmo() {
        this(ReferenceFrame.getWorldFrame());
    }

    public RDXPathControlRingGizmo(ReferenceFrame parentReferenceFrame) {
        this.parentReferenceFrame = parentReferenceFrame;
        this.transformToParent = new RigidBodyTransform();
        this.gizmoFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((ReferenceFrame)parentReferenceFrame, (RigidBodyTransform)this.transformToParent);
        this.keyboardTransformationFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransform)this.transformFromKeyboardTransformationToWorld);
    }

    public void setParentFrame(ReferenceFrame parentReferenceFrame) {
        this.parentReferenceFrame = parentReferenceFrame;
        this.gizmoFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((ReferenceFrame)parentReferenceFrame, (RigidBodyTransform)this.transformToParent);
    }

    public void create(RDXFocusBasedCamera camera3D) {
        this.camera3D = camera3D;
        this.normalMaterial = this.createAlphaPaletteMaterial(RDXGizmoTools.X_AXIS_DEFAULT_COLOR.a);
        this.highlightedMaterial = this.createAlphaPaletteMaterial(RDXGizmoTools.X_AXIS_SELECTED_DEFAULT_COLOR.a);
        this.discModel.setMesh(meshBuilder -> meshBuilder.addHollowCylinder(this.discThickness.get(), this.discOuterRadius.get(), this.discInnerRadius.get(), (Tuple3DReadOnly)new Point3D(0.0, 0.0, 0.0), DISC_COLOR));
        this.positiveXArrowModel.setMesh(meshBuilder -> meshBuilder.addIsoscelesTriangularPrism(this.arrowWidth.get(), this.arrowHeight.get(), this.discThickness.get(), (Tuple3DReadOnly)new Point3D((double)(this.discOuterRadius.get() + this.arrowSpacing.get()), 0.0, (double)this.discThickness.get() / 2.0), (Orientation3DReadOnly)new YawPitchRoll(-1.5707963267948966, 0.0, -1.5707963267948966), X_ARROW_COLOR));
        this.positiveYArrowModel.setMesh(meshBuilder -> meshBuilder.addIsoscelesTriangularPrism(this.arrowWidth.get(), this.arrowHeight.get(), this.discThickness.get(), (Tuple3DReadOnly)new Point3D(0.0, (double)(this.discOuterRadius.get() + this.arrowSpacing.get()), (double)this.discThickness.get() / 2.0), (Orientation3DReadOnly)new YawPitchRoll(0.0, 0.0, -1.5707963267948966), Y_ARROW_COLOR));
        this.negativeXArrowModel.setMesh(meshBuilder -> {
            float arrowLength = this.arrowTailLengthRatio.get() * this.arrowHeight.get();
            this.xArrowTailTransform.getTranslation().set((double)(-this.discOuterRadius.get() - this.arrowSpacing.get()) - (double)arrowLength / 2.0, 0.0, (double)this.discThickness.get() / 2.0);
            this.xArrowTailTransform.getRotation().setYawPitchRoll(1.5707963267948966, 0.0, 0.0);
            meshBuilder.addBox(this.arrowTailWidthRatio.get() * this.arrowWidth.get(), arrowLength, this.discThickness.get(), (Tuple3DReadOnly)this.xArrowTailTransform.getTranslation(), (Orientation3DReadOnly)this.xArrowTailTransform.getRotation(), X_ARROW_COLOR);
        });
        this.negativeYArrowModel.setMesh(meshBuilder -> {
            float arrowLength = this.arrowTailLengthRatio.get() * this.arrowHeight.get();
            this.yArrowTailTransform.getTranslation().set(0.0, (double)(-this.discOuterRadius.get() - this.arrowSpacing.get()) - (double)arrowLength / 2.0, (double)this.discThickness.get() / 2.0);
            this.yArrowTailTransform.getRotation().setYawPitchRoll(0.0, 0.0, 0.0);
            meshBuilder.addBox(this.arrowTailWidthRatio.get() * this.arrowWidth.get(), arrowLength, this.discThickness.get(), (Tuple3DReadOnly)this.yArrowTailTransform.getTranslation(), (Orientation3DReadOnly)this.yArrowTailTransform.getRotation(), Y_ARROW_COLOR);
        });
        this.recreateGraphics();
    }

    private Material createAlphaPaletteMaterial(float alpha) {
        Material material = new Material();
        material.set((Attribute)TextureAttribute.createDiffuse((Texture)RDXMultiColorMeshBuilder.loadPaletteTexture()));
        material.set((Attribute)new BlendingAttribute(true, alpha));
        return material;
    }

    public void calculate3DViewPick(ImGui3DViewInput input) {
        this.updateTransforms();
        ImGuiMouseDragData translateDragData = input.getMouseDragData(0);
        ImGuiMouseDragData yawDragData = input.getMouseDragData(1);
        if (!translateDragData.isDragging() && !yawDragData.isDragging()) {
            Line3DReadOnly pickRay = input.getPickRayInWorld();
            this.determineCurrentSelectionFromPickRay(pickRay);
        }
        if (this.closestCollisionSelection > -1) {
            this.pickResult.setDistanceToCamera(this.closestCollisionDistance);
            input.addPickResult(this.pickResult);
        }
    }

    public void process3DViewInput(ImGui3DViewInput input) {
        this.process3DViewInput(input, true);
    }

    public void process3DViewInput(ImGui3DViewInput input, boolean allowUserInput) {
        this.updateTransforms();
        int yawMouseButton = 1;
        ImGuiMouseDragData translateDragData = input.getMouseDragData(0);
        ImGuiMouseDragData yawDragData = input.getMouseDragData(yawMouseButton);
        this.isNewlyModified = false;
        this.isGizmoHovered = input.isWindowHovered() && this.pickResult == input.getClosestPick();
        boolean isRingHovered = this.isGizmoHovered && this.closestCollisionSelection == 0;
        boolean leftButtonDown = ImGui.isMouseDown((int)0);
        boolean rightButtonDown = ImGui.isMouseDown((int)yawMouseButton);
        if (allowUserInput) {
            if (isRingHovered) {
                if (yawDragData.getDragJustStarted()) {
                    this.clockFaceDragAlgorithm.reset();
                    yawDragData.setObjectBeingDragged(this);
                } else if (translateDragData.getDragJustStarted()) {
                    translateDragData.setObjectBeingDragged(this);
                }
            }
            boolean bl = this.isBeingManipulated = yawDragData.getObjectBeingDragged() == this && rightButtonDown || translateDragData.getObjectBeingDragged() == this && leftButtonDown;
            if (this.isBeingManipulated) {
                this.isNewlyModified = true;
                Line3DReadOnly pickRay = input.getPickRayInWorld();
                if (translateDragData.isDragging()) {
                    Vector3DReadOnly planarMotion = this.planeDragAlgorithm.calculate(pickRay, (Point3DReadOnly)this.closestCollision, (Vector3DReadOnly)Axis3D.Z);
                    this.tempFramePose3D.setToZero(this.gizmoFrame);
                    this.tempFramePose3D.changeFrame(ReferenceFrame.getWorldFrame());
                    this.tempFramePose3D.getPosition().add((Tuple3DReadOnly)planarMotion);
                    this.tempFramePose3D.changeFrame(this.parentReferenceFrame);
                    this.tempFramePose3D.get((RigidBodyTransformBasics)this.transformToParent);
                    this.closestCollision.add((Tuple3DReadOnly)planarMotion);
                } else if (this.clockFaceDragAlgorithm.calculate(pickRay, this.closestCollision, (Vector3DReadOnly)Axis3D.Z, (RigidBodyTransformReadOnly)this.controlRingPose)) {
                    this.tempFramePose3D.setToZero(this.gizmoFrame);
                    this.tempFramePose3D.changeFrame(ReferenceFrame.getWorldFrame());
                    this.clockFaceDragAlgorithm.getMotion().transform((Orientation3DBasics)this.tempFramePose3D.getOrientation());
                    this.tempFramePose3D.changeFrame(this.parentReferenceFrame);
                    this.tempFramePose3D.get((RigidBodyTransformBasics)this.transformToParent);
                }
            }
            boolean upArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getUpArrowKey());
            boolean downArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getDownArrowKey());
            boolean leftArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getLeftArrowKey());
            boolean rightArrowHeld = ImGui.isKeyDown((int)ImGuiTools.getRightArrowKey());
            boolean anyArrowHeld = upArrowHeld || downArrowHeld || leftArrowHeld || rightArrowHeld;
            this.isNewlyModified |= anyArrowHeld;
            boolean ctrlHeld = ImGui.getIO().getKeyCtrl();
            boolean altHeld = ImGui.getIO().getKeyAlt();
            boolean shiftHeld = ImGui.getIO().getKeyShift();
            double deltaTime = Gdx.graphics.getDeltaTime();
            if (altHeld) {
                double amount = deltaTime * (shiftHeld ? 0.2 : 1.0);
                if (leftArrowHeld) {
                    this.transformToParent.getRotation().appendYawRotation(amount);
                }
                if (rightArrowHeld) {
                    this.transformToParent.getRotation().appendYawRotation(-amount);
                }
            } else if (anyArrowHeld) {
                this.transformFromKeyboardTransformationToWorld.setToZero();
                this.transformFromKeyboardTransformationToWorld.getRotation().setToYawOrientation(this.camera3D.getFocusPointPose().getYaw());
                this.keyboardTransformationFrame.update();
                this.tempFramePose3D.setToZero(this.keyboardTransformationFrame);
                double amount = deltaTime * (shiftHeld ? 0.05 : 0.4);
                if (upArrowHeld && !ctrlHeld) {
                    this.tempFramePose3D.getPosition().addX(this.getTranslateSpeedFactor() * amount);
                }
                if (downArrowHeld && !ctrlHeld) {
                    this.tempFramePose3D.getPosition().subX(this.getTranslateSpeedFactor() * amount);
                }
                if (leftArrowHeld) {
                    this.tempFramePose3D.getPosition().addY(this.getTranslateSpeedFactor() * amount);
                }
                if (rightArrowHeld) {
                    this.tempFramePose3D.getPosition().subY(this.getTranslateSpeedFactor() * amount);
                }
                if (upArrowHeld && ctrlHeld) {
                    this.tempFramePose3D.getPosition().addZ(this.getTranslateSpeedFactor() * amount);
                }
                if (downArrowHeld && ctrlHeld) {
                    this.tempFramePose3D.getPosition().subZ(this.getTranslateSpeedFactor() * amount);
                }
                this.tempFramePose3D.changeFrame(ReferenceFrame.getWorldFrame());
                this.tempFramePose3D.get((RigidBodyTransformBasics)this.tempTransform);
                this.transformToParent.getTranslation().add((Tuple3DReadOnly)this.tempTransform.getTranslation());
            }
        }
        this.updateTransforms();
        LibGDXTools.toEuclid(this.camera3D.position, (Point3DBasics)this.cameraPosition);
        this.distanceToCamera = this.cameraPosition.distance((Point3DReadOnly)this.controlRingPose.getPosition());
        if (this.lastDistanceToCamera != this.distanceToCamera) {
            this.lastDistanceToCamera = this.distanceToCamera;
            this.recreateGraphics();
            this.updateTransforms();
        }
    }

    public void updateTransforms() {
        this.gizmoFrame.update();
        this.tempFramePose3D.setToZero(this.gizmoFrame);
        this.tempFramePose3D.changeFrame(ReferenceFrame.getWorldFrame());
        this.tempFramePose3D.getOrientation().setToYawOrientation(this.tempFramePose3D.getOrientation().getYaw());
        this.tempFramePose3D.changeFrame(this.parentReferenceFrame);
        this.tempFramePose3D.get((RigidBodyTransformBasics)this.transformToParent);
        this.gizmoFrame.update();
        this.controlRingPose.setToZero(this.gizmoFrame);
        this.controlRingPose.changeFrame(ReferenceFrame.getWorldFrame());
        this.controlRingPose.get((RigidBodyTransformBasics)this.controlRingTransformToWorld);
        LibGDXTools.toLibGDX(this.controlRingTransformToWorld, this.discModel.getOrCreateModelInstance().transform);
        LibGDXTools.toLibGDX(this.controlRingTransformToWorld, this.positiveXArrowModel.getOrCreateModelInstance().transform);
        LibGDXTools.toLibGDX(this.controlRingTransformToWorld, this.positiveYArrowModel.getOrCreateModelInstance().transform);
        LibGDXTools.toLibGDX(this.controlRingTransformToWorld, this.negativeXArrowModel.getOrCreateModelInstance().transform);
        LibGDXTools.toLibGDX(this.controlRingTransformToWorld, this.negativeYArrowModel.getOrCreateModelInstance().transform);
    }

    private void determineCurrentSelectionFromPickRay(Line3DReadOnly pickRay) {
        this.hollowCylinderIntersects = false;
        this.positiveXArrowIntersects = false;
        this.positiveYArrowIntersects = false;
        this.negativeXArrowIntersects = false;
        this.negativeYArrowIntersects = false;
        this.closestCollisionSelection = -1;
        this.closestCollisionDistance = Double.POSITIVE_INFINITY;
        this.hollowCylinderIntersection.update(this.discThickness.get(), this.discOuterRadius.get(), this.discInnerRadius.get(), (double)this.discThickness.get() / 2.0, (RigidBodyTransformReadOnly)this.controlRingTransformToWorld);
        double distance = this.hollowCylinderIntersection.intersect(pickRay);
        if (!Double.isNaN(distance) && distance < this.closestCollisionDistance) {
            this.hollowCylinderIntersects = true;
            this.closestCollisionDistance = distance;
            this.closestCollisionSelection = 0;
            this.closestCollision.set(this.hollowCylinderIntersection.getClosestIntersection());
        }
        if (this.showArrows) {
            this.positiveXArrowIntersection.update(this.arrowWidth.get(), this.arrowHeight.get(), this.discThickness.get(), (Tuple3DReadOnly)new Point3D((double)(this.discOuterRadius.get() + this.arrowSpacing.get()), 0.0, (double)this.discThickness.get() / 2.0), (Orientation3DReadOnly)new YawPitchRoll(-1.5707963267948966, 0.0, -1.5707963267948966), (RigidBodyTransformReadOnly)this.controlRingTransformToWorld);
            distance = this.positiveXArrowIntersection.intersect(pickRay, 100);
            if (!Double.isNaN(distance) && distance < this.closestCollisionDistance) {
                this.positiveXArrowIntersects = true;
                this.closestCollisionDistance = distance;
                this.closestCollisionSelection = 1;
                this.closestCollision.set(this.positiveXArrowIntersection.getClosestIntersection());
            }
            this.positiveYArrowIntersection.update(this.arrowWidth.get(), this.arrowHeight.get(), this.discThickness.get(), (Tuple3DReadOnly)new Point3D(0.0, (double)(this.discOuterRadius.get() + this.arrowSpacing.get()), (double)this.discThickness.get() / 2.0), (Orientation3DReadOnly)new YawPitchRoll(0.0, 0.0, -1.5707963267948966), (RigidBodyTransformReadOnly)this.controlRingTransformToWorld);
            distance = this.positiveYArrowIntersection.intersect(pickRay, 100);
            if (!Double.isNaN(distance) && distance < this.closestCollisionDistance) {
                this.positiveYArrowIntersects = true;
                this.closestCollisionDistance = distance;
                this.closestCollisionSelection = 2;
                this.closestCollision.set(this.positiveYArrowIntersection.getClosestIntersection());
            }
            this.temporaryTailTransform.set(this.xArrowTailTransform);
            this.controlRingTransformToWorld.transform((RigidBodyTransformBasics)this.temporaryTailTransform);
            boolean intersects = this.negativeXArrowIntersection.intersect(this.arrowTailWidthRatio.get() * this.arrowWidth.get(), this.arrowTailLengthRatio.get() * this.arrowHeight.get(), this.discThickness.get(), this.temporaryTailTransform, pickRay);
            distance = this.negativeXArrowIntersection.getFirstIntersectionToPack().distance(pickRay.getPoint());
            if (intersects && distance < this.closestCollisionDistance) {
                this.negativeXArrowIntersects = true;
                this.closestCollisionDistance = distance;
                this.closestCollisionSelection = 3;
                this.closestCollision.set((Tuple3DReadOnly)this.negativeXArrowIntersection.getFirstIntersectionToPack());
            }
            this.temporaryTailTransform.set(this.yArrowTailTransform);
            this.controlRingTransformToWorld.transform((RigidBodyTransformBasics)this.temporaryTailTransform);
            intersects = this.negativeYArrowIntersection.intersect(this.arrowTailWidthRatio.get() * this.arrowWidth.get(), this.arrowTailLengthRatio.get() * this.arrowHeight.get(), this.discThickness.get(), this.temporaryTailTransform, pickRay);
            distance = this.negativeYArrowIntersection.getFirstIntersectionToPack().distance(pickRay.getPoint());
            if (intersects && distance < this.closestCollisionDistance) {
                this.negativeYArrowIntersects = true;
                this.closestCollisionDistance = distance;
                this.closestCollisionSelection = 4;
                this.closestCollision.set((Tuple3DReadOnly)this.negativeYArrowIntersection.getFirstIntersectionToPack());
            }
        }
        this.updateMaterialHighlighting();
    }

    private void updateMaterialHighlighting() {
        boolean prior = this.highlightingEnabled && this.isGizmoHovered;
        this.discModel.setMaterial(prior && this.closestCollisionSelection == 0 ? this.highlightedMaterial : this.normalMaterial);
        this.positiveXArrowModel.setMaterial(prior && this.closestCollisionSelection == 1 ? this.highlightedMaterial : this.normalMaterial);
        this.positiveYArrowModel.setMaterial(prior && this.closestCollisionSelection == 2 ? this.highlightedMaterial : this.normalMaterial);
        this.negativeXArrowModel.setMaterial(prior && this.closestCollisionSelection == 3 ? this.highlightedMaterial : this.normalMaterial);
        this.negativeYArrowModel.setMaterial(prior && this.closestCollisionSelection == 4 ? this.highlightedMaterial : this.normalMaterial);
    }

    public ImGuiPanel createTunerPanel(String name) {
        return new ImGuiPanel("Footstep Ring Gizmo Tuner (" + name + ")", this::renderImGuiTuner);
    }

    public void renderImGuiTuner() {
        ImGui.text((String)"Use the right mouse button to manipulate the widget.");
        if (ImGui.button((String)"Reset")) {
            this.transformToParent.setToZero();
        }
        ImGui.pushItemWidth((float)100.0f);
        boolean proportionsChanged = false;
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Disc outer radius"), (float[])this.discOuterRadius.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Disc inner radius"), (float[])this.discInnerRadius.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Disc thickness"), (float[])this.discThickness.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Arrow width"), (float[])this.arrowWidth.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Arrow height"), (float[])this.arrowHeight.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Arrow spacing"), (float[])this.arrowSpacing.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
        proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Arrow tail width ratio"), (float[])this.arrowTailWidthRatio.getData(), (float)0.001f, (float)0.0f, (float)1000.0f);
        ImGui.popItemWidth();
        if (proportionsChanged |= ImGui.dragFloat((String)ImGuiTools.uniqueLabel(this, "Arrow tail length ratio"), (float[])this.arrowTailLengthRatio.getData(), (float)0.001f, (float)0.0f, (float)1000.0f)) {
            this.recreateGraphics();
        }
        this.updateTransforms();
    }

    private void recreateGraphics() {
        this.updateMaterialHighlighting();
        this.discModel.invalidateMesh();
        this.positiveXArrowModel.invalidateMesh();
        this.positiveYArrowModel.invalidateMesh();
        this.negativeXArrowModel.invalidateMesh();
        this.negativeYArrowModel.invalidateMesh();
    }

    public void getRenderables(Array<Renderable> renderables, Pool<Renderable> pool) {
        this.discModel.getOrCreateModelInstance().getRenderables(renderables, pool);
        if (this.showArrows) {
            this.positiveXArrowModel.getOrCreateModelInstance().getRenderables(renderables, pool);
            this.positiveYArrowModel.getOrCreateModelInstance().getRenderables(renderables, pool);
            this.negativeXArrowModel.getOrCreateModelInstance().getRenderables(renderables, pool);
            this.negativeYArrowModel.getOrCreateModelInstance().getRenderables(renderables, pool);
        }
    }

    public Pose3DReadOnly getPose3D() {
        return this.controlRingPose;
    }

    public RigidBodyTransform getTransformToParent() {
        return this.transformToParent;
    }

    public ReferenceFrame getGizmoFrame() {
        return this.gizmoFrame;
    }

    public boolean getAnyPartPickSelected() {
        return this.isGizmoHovered && (this.hollowCylinderIntersects || this.positiveXArrowIntersects || this.positiveYArrowIntersects || this.negativeXArrowIntersects || this.negativeYArrowIntersects);
    }

    public boolean getAnyArrowPickSelected() {
        return this.isGizmoHovered && (this.positiveXArrowIntersects || this.positiveYArrowIntersects || this.negativeXArrowIntersects || this.negativeYArrowIntersects);
    }

    public boolean getHollowCylinderPickSelected() {
        return this.isGizmoHovered && this.hollowCylinderIntersects;
    }

    public boolean getPositiveXArrowPickSelected() {
        return this.isGizmoHovered && this.positiveXArrowIntersects;
    }

    public boolean getPositiveYArrowPickSelected() {
        return this.isGizmoHovered && this.positiveYArrowIntersects;
    }

    public boolean getNegativeXArrowPickSelected() {
        return this.isGizmoHovered && this.negativeXArrowIntersects;
    }

    public boolean getNegativeYArrowPickSelected() {
        return this.isGizmoHovered && this.negativeYArrowIntersects;
    }

    public void setShowArrows(boolean showArrows) {
        this.showArrows = showArrows;
    }

    private double getTranslateSpeedFactor() {
        return 0.5 * this.distanceToCamera;
    }

    public void setHighlightingEnabled(boolean highlightingEnabled) {
        this.highlightingEnabled = highlightingEnabled;
    }

    public boolean isNewlyModified() {
        return this.isNewlyModified;
    }

    public boolean getGizmoHovered() {
        return this.isGizmoHovered;
    }
}

