/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;

public class HollowCylinderRayIntersection {
    private final Cylinder3D cylinder = new Cylinder3D();
    private final Cylinder3D hollowPart = new Cylinder3D();
    private final Line3D cylinderAxis = new Line3D();
    private final Point3D firstIntersectionToPack = new Point3D();
    private final Point3D secondIntersectionToPack = new Point3D();
    private final Point3D secondHollowIntersectionToPack = new Point3D();
    private final Point3D closestCollisionPoint = new Point3D();
    private double innerRadius;

    public void update(double length, double outerRadius, double innerRadius, double zOffset, RigidBodyTransformReadOnly transform) {
        this.innerRadius = innerRadius;
        this.cylinder.setToZero();
        this.cylinder.setSize(length, outerRadius);
        this.cylinder.getPosition().addZ(zOffset);
        this.cylinder.applyTransform((Transform)transform);
        this.cylinderAxis.getPoint().setToZero();
        this.cylinderAxis.getDirection().set((UnitVector3DReadOnly)Axis3D.Z);
        this.cylinderAxis.applyTransform((Transform)transform);
        this.hollowPart.setToZero();
        this.hollowPart.setSize(length, innerRadius);
        this.hollowPart.getPosition().addZ(zOffset);
        this.hollowPart.applyTransform((Transform)transform);
    }

    public double intersect(Line3DReadOnly pickRay) {
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)this.cylinder.getLength(), (double)this.cylinder.getRadius(), (Point3DReadOnly)this.cylinder.getPosition(), (Vector3DReadOnly)this.cylinder.getAxis(), (Point3DReadOnly)pickRay.getPoint(), (Vector3DReadOnly)pickRay.getDirection(), (Point3DBasics)this.firstIntersectionToPack, (Point3DBasics)this.secondIntersectionToPack);
        boolean intersectsBigCylinder = numberOfIntersections == 2;
        this.closestCollisionPoint.setToNaN();
        if (intersectsBigCylinder) {
            boolean secondIntersectionIsInsideHollowPart;
            double firstDistanceToAxis = this.cylinderAxis.distance((Point3DReadOnly)this.firstIntersectionToPack);
            double secondDistanceToAxis = this.cylinderAxis.distance((Point3DReadOnly)this.secondIntersectionToPack);
            boolean firstIntersectionIsInsideHollowPart = firstDistanceToAxis < this.innerRadius;
            boolean bl = secondIntersectionIsInsideHollowPart = secondDistanceToAxis < this.innerRadius;
            if (!firstIntersectionIsInsideHollowPart) {
                this.closestCollisionPoint.set(this.firstIntersectionToPack);
            } else if (!secondIntersectionIsInsideHollowPart) {
                EuclidGeometryTools.intersectionBetweenRay3DAndCylinder3D((double)this.hollowPart.getLength(), (double)this.hollowPart.getRadius(), (Point3DReadOnly)this.hollowPart.getPosition(), (Vector3DReadOnly)this.hollowPart.getAxis(), (Point3DReadOnly)pickRay.getPoint(), (Vector3DReadOnly)pickRay.getDirection(), null, (Point3DBasics)this.secondHollowIntersectionToPack);
                this.closestCollisionPoint.set(this.secondHollowIntersectionToPack);
            }
        }
        return !this.closestCollisionPoint.containsNaN() ? this.firstIntersectionToPack.distance(pickRay.getPoint()) : Double.NaN;
    }

    public Point3D getClosestIntersection() {
        return this.closestCollisionPoint;
    }

    public Cylinder3D getCylinder() {
        return this.cylinder;
    }
}

