/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.shape.primitives.Torus3D;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.rdx.ui.gizmo.StepCheckIsPointInsideAlgorithm;

public class DiscreteTorusRayIntersection {
    private final Torus3D torus = new Torus3D();
    private final StepCheckIsPointInsideAlgorithm stepCheckIsPointInsideAlgorithm = new StepCheckIsPointInsideAlgorithm();

    public void update(double radius, double tubeRadius, RigidBodyTransformReadOnly transform) {
        this.torus.setToZero();
        this.torus.setRadii(radius, tubeRadius);
        this.torus.applyTransform((Transform)transform);
        this.stepCheckIsPointInsideAlgorithm.update(radius + tubeRadius, transform);
    }

    public double intersect(Line3DReadOnly pickRay, int resolution) {
        return this.stepCheckIsPointInsideAlgorithm.intersect(pickRay, resolution, arg_0 -> ((Torus3D)this.torus).isPointInside(arg_0));
    }

    public Point3D getClosestIntersection() {
        return this.stepCheckIsPointInsideAlgorithm.getClosestIntersection();
    }
}

