/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.robotics.geometry.shapes.FramePlane3d;

public class DiscreteIsoscelesTriangularPrismRayIntersection {
    public static final ReferenceFrame WORLD_FRAME = ReferenceFrame.getWorldFrame();
    private final FramePlane3d basePlane = new FramePlane3d();
    private final FramePlane3d leftPlane = new FramePlane3d();
    private final FramePlane3d rightPlane = new FramePlane3d();
    private final FramePlane3d topPlane = new FramePlane3d();
    private final FramePlane3d bottomPlane = new FramePlane3d();
    private final YawPitchRoll tempOrientation = new YawPitchRoll();
    private final RigidBodyTransform shapeTransformToWorld = new RigidBodyTransform();
    private final ReferenceFrame shapeFrame = ReferenceFrameTools.constructFrameWithChangingTransformToParent((String)"shapeFrame", (ReferenceFrame)WORLD_FRAME, (RigidBodyTransformReadOnly)this.shapeTransformToWorld);
    private final Point3D closestIntersection = new Point3D();
    private final Point3D candidatePlaneIntersection = new Point3D();

    public void update(double triangleWidth, double triangleHeight, double prismThickness, Tuple3DReadOnly offset, Orientation3DReadOnly orientation, RigidBodyTransformReadOnly transform) {
        this.shapeTransformToWorld.set(transform);
        this.shapeTransformToWorld.appendTranslation(offset);
        this.shapeTransformToWorld.appendOrientation(orientation);
        this.shapeFrame.update();
        this.basePlane.setToZero(this.shapeFrame);
        this.leftPlane.setToZero(this.shapeFrame);
        this.rightPlane.setToZero(this.shapeFrame);
        this.topPlane.setToZero(this.shapeFrame);
        this.bottomPlane.setToZero(this.shapeFrame);
        double lowerInnerAngle = 1.5707963267948966 - Math.atan2(triangleHeight, triangleWidth / 2.0);
        this.leftPlane.getPoint().subX(triangleWidth / 2.0);
        this.tempOrientation.set(0.0, lowerInnerAngle + 1.5707963267948966, 0.0);
        this.tempOrientation.transform((Tuple3DBasics)this.leftPlane.getNormal());
        this.rightPlane.getPoint().addX(triangleWidth / 2.0);
        this.tempOrientation.set(0.0, -lowerInnerAngle - 1.5707963267948966, 0.0);
        this.tempOrientation.transform((Tuple3DBasics)this.rightPlane.getNormal());
        this.topPlane.getPoint().addY(prismThickness / 2.0);
        this.tempOrientation.set(0.0, 0.0, 1.5707963267948966);
        this.tempOrientation.transform((Tuple3DBasics)this.topPlane.getNormal());
        this.bottomPlane.getPoint().subY(prismThickness / 2.0);
        this.tempOrientation.set(0.0, 0.0, -1.5707963267948966);
        this.tempOrientation.transform((Tuple3DBasics)this.bottomPlane.getNormal());
        this.basePlane.changeFrame(WORLD_FRAME);
        this.leftPlane.changeFrame(WORLD_FRAME);
        this.rightPlane.changeFrame(WORLD_FRAME);
        this.topPlane.changeFrame(WORLD_FRAME);
        this.bottomPlane.changeFrame(WORLD_FRAME);
    }

    public double intersect(Line3DReadOnly pickRay, int resolution) {
        double distance;
        this.closestIntersection.setToNaN();
        double closestDistance = Double.POSITIVE_INFINITY;
        this.basePlane.getIntersectionWithLine(this.candidatePlaneIntersection, pickRay);
        if (this.isPointInside((Point3DReadOnly)this.candidatePlaneIntersection) && (distance = this.candidatePlaneIntersection.distance(pickRay.getPoint())) < closestDistance) {
            this.closestIntersection.set(this.candidatePlaneIntersection);
            closestDistance = distance;
        }
        this.leftPlane.getIntersectionWithLine(this.candidatePlaneIntersection, pickRay);
        if (this.isPointInside((Point3DReadOnly)this.candidatePlaneIntersection) && (distance = this.candidatePlaneIntersection.distance(pickRay.getPoint())) < closestDistance) {
            this.closestIntersection.set(this.candidatePlaneIntersection);
            closestDistance = distance;
        }
        this.rightPlane.getIntersectionWithLine(this.candidatePlaneIntersection, pickRay);
        if (this.isPointInside((Point3DReadOnly)this.candidatePlaneIntersection) && (distance = this.candidatePlaneIntersection.distance(pickRay.getPoint())) < closestDistance) {
            this.closestIntersection.set(this.candidatePlaneIntersection);
            closestDistance = distance;
        }
        this.bottomPlane.getIntersectionWithLine(this.candidatePlaneIntersection, pickRay);
        if (this.isPointInside((Point3DReadOnly)this.candidatePlaneIntersection) && (distance = this.candidatePlaneIntersection.distance(pickRay.getPoint())) < closestDistance) {
            this.closestIntersection.set(this.candidatePlaneIntersection);
            closestDistance = distance;
        }
        this.topPlane.getIntersectionWithLine(this.candidatePlaneIntersection, pickRay);
        if (this.isPointInside((Point3DReadOnly)this.candidatePlaneIntersection) && (distance = this.candidatePlaneIntersection.distance(pickRay.getPoint())) < closestDistance) {
            this.closestIntersection.set(this.candidatePlaneIntersection);
            closestDistance = distance;
        }
        return this.closestIntersection.containsNaN() ? Double.NaN : closestDistance;
    }

    private boolean isPointInside(Point3DReadOnly pointToCheck) {
        boolean onOrAboveBasePlane = this.basePlane.isOnOrAbove(pointToCheck, 1.0E-7);
        boolean onOrAboveLeftPlane = this.leftPlane.isOnOrAbove(pointToCheck, 1.0E-7);
        boolean onOrAboveRightPlane = this.rightPlane.isOnOrAbove(pointToCheck, 1.0E-7);
        boolean onOrAboveTopPlane = this.topPlane.isOnOrAbove(pointToCheck, 1.0E-7);
        boolean onOrAboveBottomPlane = this.bottomPlane.isOnOrAbove(pointToCheck, 1.0E-7);
        return onOrAboveBasePlane && onOrAboveLeftPlane && onOrAboveRightPlane && onOrAboveTopPlane && onOrAboveBottomPlane;
    }

    public Point3D getClosestIntersection() {
        return this.closestIntersection;
    }
}

