/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.rdx.ui.gizmo.SphereRayIntersection;

public class DiscreteConeRayIntersection {
    private final SphereRayIntersection boundingSphereIntersection = new SphereRayIntersection();
    private final Plane3D coneBasePlaneFacingTip = new Plane3D();
    private final Plane3D coneTipPlaneFacingBase = new Plane3D();
    private final Line3D coneBaseTowardsTipAxis = new Line3D();
    private final Point3D closestConeAxisPoint = new Point3D();
    private final RigidBodyTransform coneBaseCenterTipUpTransform = new RigidBodyTransform();
    private final Point3D interpolatedPoint = new Point3D();
    private double arrowHeadRadius;
    private double arrowHeadLength;

    public void update(double coneBaseRadius, double coneHeight, double zOffset, RigidBodyTransformReadOnly transform) {
        this.arrowHeadRadius = coneBaseRadius;
        this.arrowHeadLength = coneHeight;
        this.coneBaseCenterTipUpTransform.setToZero();
        this.coneBaseCenterTipUpTransform.getTranslation().addZ(zOffset);
        transform.transform((RigidBodyTransformBasics)this.coneBaseCenterTipUpTransform);
        double boundingSphereRadius = coneBaseRadius > 0.5 * coneHeight ? coneBaseRadius / Math.sin(Math.atan(2.0 * coneBaseRadius / coneHeight)) : 0.5 * coneHeight;
        this.boundingSphereIntersection.update(boundingSphereRadius, zOffset + Math.signum(zOffset) * 0.5 * coneHeight, transform);
    }

    public double intersect(Line3DReadOnly pickRay, int resolution) {
        if (this.boundingSphereIntersection.intersect(pickRay)) {
            this.coneBasePlaneFacingTip.setToZero();
            this.coneBasePlaneFacingTip.applyTransform((Transform)this.coneBaseCenterTipUpTransform);
            this.coneTipPlaneFacingBase.setToZero();
            this.coneTipPlaneFacingBase.getPoint().addZ(this.arrowHeadLength);
            this.coneTipPlaneFacingBase.getNormal().set(0.0, 0.0, -1.0);
            this.coneTipPlaneFacingBase.applyTransform((Transform)this.coneBaseCenterTipUpTransform);
            this.coneBaseTowardsTipAxis.set((Point3DReadOnly)this.coneBasePlaneFacingTip.getPoint(), (Vector3DReadOnly)this.coneBasePlaneFacingTip.getNormal());
            for (int i = 0; i < resolution; ++i) {
                this.interpolatedPoint.interpolate((Tuple3DReadOnly)this.boundingSphereIntersection.getFirstIntersectionToPack(), (Tuple3DReadOnly)this.boundingSphereIntersection.getSecondIntersectionToPack(), (double)i / (double)resolution);
                if (!this.coneBasePlaneFacingTip.isOnOrAbove((Point3DReadOnly)this.interpolatedPoint) || !this.coneTipPlaneFacingBase.isOnOrAbove((Point3DReadOnly)this.interpolatedPoint)) continue;
                this.coneBaseTowardsTipAxis.orthogonalProjection((Point3DReadOnly)this.interpolatedPoint, (Point3DBasics)this.closestConeAxisPoint);
                double distanceFromBase = this.closestConeAxisPoint.distance((Point3DReadOnly)this.coneBasePlaneFacingTip.getPoint());
                double radiusBoundsAtTier = EuclidCoreTools.interpolate((double)this.arrowHeadRadius, (double)0.0, (double)(distanceFromBase / this.arrowHeadLength));
                if (!(this.closestConeAxisPoint.distance((Point3DReadOnly)this.interpolatedPoint) <= radiusBoundsAtTier)) continue;
                return this.interpolatedPoint.distance(pickRay.getPoint());
            }
        }
        return Double.NaN;
    }

    public Point3D getIntersectionPoint() {
        return this.interpolatedPoint;
    }
}

