/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.rdx.ui.gizmo.CylinderRayIntersection;
import us.ihmc.rdx.ui.gizmo.DiscreteConeRayIntersection;

public class DiscreteArrowRayIntersection {
    private final CylinderRayIntersection cylinderIntersection = new CylinderRayIntersection();
    private final DiscreteConeRayIntersection coneRayIntersection = new DiscreteConeRayIntersection();
    private final Point3D intersection = new Point3D();

    public void update(double arrowBodyLength, double arrowBodyRadius, double arrowHeadRadius, double arrowHeadLength, double zOffset, RigidBodyTransformReadOnly transform) {
        this.cylinderIntersection.update(arrowBodyLength, arrowBodyRadius, zOffset, transform);
        this.coneRayIntersection.update(arrowHeadRadius, arrowHeadLength, zOffset + Math.signum(zOffset) * 0.5 * arrowBodyLength, transform);
    }

    public double intersect(Line3DReadOnly pickRay, int resolution, boolean collideArrowHead) {
        double cylinderDistance = this.cylinderIntersection.intersect(pickRay);
        if (collideArrowHead) {
            double coneDistance = this.coneRayIntersection.intersect(pickRay, resolution);
            if (Double.isNaN(cylinderDistance) && Double.isNaN(coneDistance)) {
                return Double.NaN;
            }
            if (Double.isNaN(cylinderDistance) || coneDistance < cylinderDistance) {
                this.intersection.set(this.coneRayIntersection.getIntersectionPoint());
                return coneDistance;
            }
            this.intersection.set((Tuple3DReadOnly)this.cylinderIntersection.getClosestIntersection());
            return cylinderDistance;
        }
        if (!Double.isNaN(cylinderDistance)) {
            this.intersection.set((Tuple3DReadOnly)this.cylinderIntersection.getClosestIntersection());
        }
        return cylinderDistance;
    }

    public Point3D getIntersection() {
        return this.intersection;
    }
}

