/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.rdx.ui.gizmo.CylinderRayIntersection;
import us.ihmc.rdx.ui.gizmo.SphereRayIntersection;

public class CapsuleRayIntersection {
    private final SphereRayIntersection sphereIntersectionPositiveEnd = new SphereRayIntersection();
    private final SphereRayIntersection sphereIntersectionNegativeEnd = new SphereRayIntersection();
    private final CylinderRayIntersection cylinderIntersection = new CylinderRayIntersection();
    private final FramePoint3D tempSphereCenter = new FramePoint3D();

    public void update(double radius, double length, Point3DReadOnly position, UnitVector3DReadOnly axis, ReferenceFrame frameAfterJoint) {
        this.cylinderIntersection.update(length, radius, position, axis, frameAfterJoint);
        this.tempSphereCenter.setIncludingFrame(frameAfterJoint, (Tuple3DReadOnly)this.cylinderIntersection.getCylinder().getTopCenter());
        this.tempSphereCenter.changeFrame(ReferenceFrame.getWorldFrame());
        this.sphereIntersectionPositiveEnd.update(radius, (Point3DReadOnly)this.tempSphereCenter);
        this.tempSphereCenter.setIncludingFrame(frameAfterJoint, (Tuple3DReadOnly)this.cylinderIntersection.getCylinder().getBottomCenter());
        this.tempSphereCenter.changeFrame(ReferenceFrame.getWorldFrame());
        this.sphereIntersectionNegativeEnd.update(radius, (Point3DReadOnly)this.tempSphereCenter);
    }

    public boolean intersect(Line3DReadOnly pickRay) {
        boolean intersects = false;
        intersects |= this.sphereIntersectionPositiveEnd.intersect(pickRay);
        intersects |= this.sphereIntersectionNegativeEnd.intersect(pickRay);
        double closestDistance = this.cylinderIntersection.intersect(pickRay);
        return intersects |= !Double.isNaN(closestDistance);
    }

    public double getDistanceToCollision(Line3DReadOnly pickRay) {
        double distance;
        double distanceToCollision = Double.POSITIVE_INFINITY;
        if (this.sphereIntersectionPositiveEnd.getIntersects() && (distance = pickRay.getPoint().distance(this.sphereIntersectionPositiveEnd.getFirstIntersectionToPack())) < distanceToCollision) {
            distanceToCollision = distance;
        }
        if (this.sphereIntersectionNegativeEnd.getIntersects() && (distance = pickRay.getPoint().distance(this.sphereIntersectionNegativeEnd.getFirstIntersectionToPack())) < distanceToCollision) {
            distanceToCollision = distance;
        }
        if (this.cylinderIntersection.getIntersects() && (distance = pickRay.getPoint().distance(this.cylinderIntersection.getClosestIntersection())) < distanceToCollision) {
            distanceToCollision = distance;
        }
        return distanceToCollision;
    }
}

