/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui.gizmo;

import us.ihmc.euclid.geometry.interfaces.Line3DReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.referenceFrames.ReferenceFrameMissingTools;

public class BoxRayIntersection {
    private final RigidBodyTransform boxToWorldTransform = new RigidBodyTransform();
    private final ReferenceFrame boxFrame = ReferenceFrameMissingTools.constructFrameWithChangingTransformToParent((ReferenceFrame)ReferenceFrame.getWorldFrame(), (RigidBodyTransform)this.boxToWorldTransform);
    private final FramePoint3D rayOrigin = new FramePoint3D();
    private final FrameVector3D rayDirection = new FrameVector3D();
    private final Point3D boundingBoxMin = new Point3D();
    private final Point3D boundingBoxMax = new Point3D();
    private final FramePoint3D firstIntersectionToPack = new FramePoint3D();
    private final FramePoint3D secondIntersectionToPack = new FramePoint3D();
    private boolean intersects = false;

    public boolean intersect(double sizeX, double sizeY, double sizeZ, RigidBodyTransform boxCenterToWorld, Line3DReadOnly pickRay) {
        this.boxToWorldTransform.set(boxCenterToWorld);
        this.boxFrame.update();
        this.rayOrigin.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)pickRay.getPoint());
        this.rayDirection.setIncludingFrame(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)pickRay.getDirection());
        this.rayOrigin.changeFrame(this.boxFrame);
        this.rayDirection.changeFrame(this.boxFrame);
        this.boundingBoxMin.set(-sizeX / 2.0, -sizeY / 2.0, -sizeZ / 2.0);
        this.boundingBoxMax.set(sizeX / 2.0, sizeY / 2.0, sizeZ / 2.0);
        this.firstIntersectionToPack.setToZero(this.boxFrame);
        this.secondIntersectionToPack.setToZero(this.boxFrame);
        int numberOfIntersections = EuclidGeometryTools.intersectionBetweenRay3DAndBoundingBox3D((Point3DReadOnly)this.boundingBoxMin, (Point3DReadOnly)this.boundingBoxMax, (Point3DReadOnly)this.rayOrigin, (Vector3DReadOnly)this.rayDirection, (Point3DBasics)this.firstIntersectionToPack, (Point3DBasics)this.secondIntersectionToPack);
        this.firstIntersectionToPack.changeFrame(ReferenceFrame.getWorldFrame());
        this.secondIntersectionToPack.changeFrame(ReferenceFrame.getWorldFrame());
        this.intersects = numberOfIntersections == 2;
        return this.intersects;
    }

    public Point3DReadOnly getFirstIntersectionToPack() {
        return this.firstIntersectionToPack;
    }

    public Point3DReadOnly getSecondIntersectionToPack() {
        return this.secondIntersectionToPack;
    }

    public boolean getIntersects() {
        return this.intersects;
    }
}

