/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import imgui.internal.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImInt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import us.ihmc.commons.FormattingTools;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.Lwjgl3ApplicationAdapter;
import us.ihmc.rdx.imgui.ImGuiPanelManager;
import us.ihmc.rdx.imgui.ImGuiPanelSizeHandler;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.RDXImGuiWindowAndDockSystem;
import us.ihmc.rdx.input.ImGui2DViewInput;
import us.ihmc.rdx.input.RDXInputMode;
import us.ihmc.rdx.sceneManager.RDX2DSceneManager;
import us.ihmc.rdx.tools.LibGDXApplicationCreator;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.ui.ImGuiConfigurationLocation;
import us.ihmc.rdx.ui.RDXImGuiLayoutManager;
import us.ihmc.tools.io.HybridDirectory;
import us.ihmc.tools.io.HybridFile;
import us.ihmc.tools.io.JSONFileTools;

public class RDXBaseUI2D {
    public static final int ANTI_ALIASING = 2;
    private static final String VIEW_2D_WINDOW_NAME = "2D View";
    private final RDX2DSceneManager sceneManager = new RDX2DSceneManager();
    private final RDXImGuiWindowAndDockSystem imGuiWindowAndDockSystem;
    private final ArrayList<Runnable> onCloseRequestListeners = new ArrayList();
    private final String windowTitle;
    private final Path dotIHMCDirectory = Paths.get(System.getProperty("user.home"), ".ihmc");
    private String configurationExtraPath;
    private final HybridDirectory configurationBaseDirectory;
    private HybridFile libGDXSettingsFile;
    private final Stopwatch runTime = new Stopwatch().start();
    private final ImGuiPanelSizeHandler view2DPanelSizeHandler = new ImGuiPanelSizeHandler();
    private ImGui2DViewInput inputCalculator;
    private final ArrayList<Consumer<ImGui2DViewInput>> imgui2DViewInputProcessors = new ArrayList();
    private GLFrameBuffer frameBuffer;
    private float sizeX;
    private float sizeY;
    private final ImInt foregroundFPS = new ImInt(240);
    private final ImBoolean vsync = new ImBoolean(false);
    private final ImInt libGDXLogLevel = new ImInt(LibGDXTools.toLibGDX(LogTools.getLevel()));
    private final RDXImGuiLayoutManager layoutManager;

    public RDXBaseUI2D(Class<?> classForLoading, String directoryNameToAssumePresent, String subsequentPathToResourceFolder) {
        this(classForLoading, directoryNameToAssumePresent, subsequentPathToResourceFolder, classForLoading.getSimpleName());
    }

    public RDXBaseUI2D(Class<?> classForLoading, String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String windowTitle) {
        this.windowTitle = windowTitle;
        this.configurationExtraPath = "/configurations/" + windowTitle.replaceAll(" ", "");
        this.configurationBaseDirectory = new HybridDirectory(this.dotIHMCDirectory, directoryNameToAssumePresent, subsequentPathToResourceFolder, classForLoading, this.configurationExtraPath);
        this.imGuiWindowAndDockSystem = new RDXImGuiWindowAndDockSystem();
        this.layoutManager = new RDXImGuiLayoutManager(classForLoading, directoryNameToAssumePresent, subsequentPathToResourceFolder, this.configurationExtraPath, this.configurationBaseDirectory);
        this.layoutManager.getLayoutDirectoryUpdatedListeners().add(this.imGuiWindowAndDockSystem::setDirectory);
        this.layoutManager.getLayoutDirectoryUpdatedListeners().add(updatedLayoutDirectory -> {
            this.libGDXSettingsFile = new HybridFile(updatedLayoutDirectory, "GDXSettings.json");
        });
        this.layoutManager.getLoadListeners().add(this.imGuiWindowAndDockSystem::loadConfiguration);
        this.layoutManager.getLoadListeners().add(loadConfigurationLocation -> {
            Gdx.graphics.setWindowedMode(this.imGuiWindowAndDockSystem.getCalculatedPrimaryWindowSize().getWidth(), this.imGuiWindowAndDockSystem.getCalculatedPrimaryWindowSize().getHeight());
            ((Lwjgl3Graphics)Gdx.graphics).getWindow().setPosition(this.imGuiWindowAndDockSystem.getPrimaryWindowPosition().getX(), this.imGuiWindowAndDockSystem.getPrimaryWindowPosition().getY());
            return true;
        });
        this.layoutManager.getSaveListeners().add(this::saveApplicationSettings);
        this.layoutManager.applyLayoutDirectory();
        this.imGuiWindowAndDockSystem.getPanelManager().addSelfManagedPanel(VIEW_2D_WINDOW_NAME);
    }

    public void launchGDXApplication(Lwjgl3ApplicationAdapter applicationAdapter) {
        AtomicReference<Integer> windowWidth = new AtomicReference<Integer>(800);
        AtomicReference<Integer> windowHeight = new AtomicReference<Integer>(600);
        JSONFileTools.loadUserWithClasspathDefaultFallback((HybridFile)this.libGDXSettingsFile, jsonNode -> {
            windowWidth.set(jsonNode.get("windowWidth").asInt());
            windowHeight.set(jsonNode.get("windowHeight").asInt());
        });
        LogTools.info((String)"Launching GDX application");
        LibGDXApplicationCreator.launchGDXApplication(applicationAdapter, this.windowTitle, windowWidth.get().intValue(), windowHeight.get().intValue());
    }

    public void create() {
        LogTools.info((String)"Creating...");
        LibGDXTools.printGLVersion();
        this.sceneManager.create(RDXInputMode.ImGui);
        this.inputCalculator = new ImGui2DViewInput(this.sceneManager.getOrthographicCamera(), this::getViewportSizeX, this::getViewportSizeY);
        Gdx.input.setInputProcessor(null);
        this.imgui2DViewInputProcessors.add(this.sceneManager.getOrthographicCamera()::processImGuiInput);
        this.imGuiWindowAndDockSystem.create(((Lwjgl3Graphics)Gdx.graphics).getWindow().getWindowHandle(), this.layoutManager);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Gdx.app.exit(), "Exit" + this.getClass().getSimpleName()));
    }

    public void renderBeforeOnScreenUI() {
        Gdx.graphics.setTitle(this.windowTitle + " - " + Gdx.graphics.getFramesPerSecond() + " FPS");
        this.imGuiWindowAndDockSystem.beforeWindowManagement();
        this.render2DView();
        this.renderMenuBar();
    }

    public void renderEnd() {
        this.imGuiWindowAndDockSystem.afterWindowManagement();
    }

    private void renderMenuBar() {
        ImGui.beginMainMenuBar();
        this.layoutManager.renderImGuiLayoutMenu();
        if (ImGui.beginMenu((String)"Panels")) {
            this.imGuiWindowAndDockSystem.renderMenuDockPanelItems();
            ImGui.endMenu();
        }
        if (ImGui.beginMenu((String)"Settings")) {
            ImGui.pushItemWidth((float)80.0f);
            if (ImGui.inputInt((String)"Foreground FPS", (ImInt)this.foregroundFPS, (int)1)) {
                Gdx.graphics.setForegroundFPS(this.foregroundFPS.get());
            }
            if (ImGui.checkbox((String)"Vsync", (ImBoolean)this.vsync)) {
                Gdx.graphics.setVSync(this.vsync.get());
            }
            if (ImGui.inputInt((String)"libGDX log level", (ImInt)this.libGDXLogLevel, (int)1)) {
                Gdx.app.setLogLevel(this.libGDXLogLevel.get());
            }
            ImGui.popItemWidth();
            ImGui.endMenu();
        }
        ImGui.sameLine((float)(ImGui.getWindowSizeX() - 170.0f));
        ImGui.text((String)(FormattingTools.getFormattedDecimal2D((double)this.runTime.totalElapsed()) + " s"));
        ImGui.sameLine((float)(ImGui.getWindowSizeX() - 100.0f));
        ImGui.endMainMenuBar();
    }

    private void render2DView() {
        this.view2DPanelSizeHandler.handleSizeBeforeBegin();
        ImGui.pushStyleVar((int)2, (float)0.0f, (float)0.0f);
        int flags = 0;
        ImGui.begin((String)VIEW_2D_WINDOW_NAME, (int)flags);
        this.view2DPanelSizeHandler.handleSizeAfterBegin();
        float posX = ImGui.getWindowPosX();
        float posY = ImGui.getWindowPosY() + ImGuiTools.TAB_BAR_HEIGHT;
        this.sizeX = ImGui.getWindowSizeX();
        this.sizeY = ImGui.getWindowSizeY() - ImGuiTools.TAB_BAR_HEIGHT;
        float renderSizeX = this.sizeX * 2.0f;
        float renderSizeY = this.sizeY * 2.0f;
        this.inputCalculator.compute();
        for (Consumer<ImGui2DViewInput> imGuiInputProcessor : this.imgui2DViewInputProcessors) {
            imGuiInputProcessor.accept(this.inputCalculator);
        }
        if (this.frameBuffer == null || (float)this.frameBuffer.getWidth() < renderSizeX || (float)this.frameBuffer.getHeight() < renderSizeY) {
            if (this.frameBuffer != null) {
                this.frameBuffer.dispose();
            }
            int newWidth = this.frameBuffer == null ? Gdx.graphics.getWidth() * 2 : this.frameBuffer.getWidth() * 2;
            int newHeight = this.frameBuffer == null ? Gdx.graphics.getHeight() * 2 : this.frameBuffer.getHeight() * 2;
            LogTools.info((String)"Allocating framebuffer of size: {}x{}", (Object)newWidth, (Object)newHeight);
            GLFrameBuffer.FrameBufferBuilder frameBufferBuilder = new GLFrameBuffer.FrameBufferBuilder(newWidth, newHeight);
            frameBufferBuilder.addBasicColorTextureAttachment(Pixmap.Format.RGBA8888);
            frameBufferBuilder.addBasicStencilDepthPackedRenderBuffer();
            this.frameBuffer = frameBufferBuilder.build();
        }
        this.sceneManager.setViewportBounds((int)renderSizeX, (int)renderSizeY);
        this.frameBuffer.begin();
        this.sceneManager.render();
        this.frameBuffer.end();
        int frameBufferWidth = this.frameBuffer.getWidth();
        int frameBufferHeight = this.frameBuffer.getHeight();
        float percentOfFramebufferUsedX = renderSizeX / (float)frameBufferWidth;
        float percentOfFramebufferUsedY = renderSizeY / (float)frameBufferHeight;
        int textureID = this.frameBuffer.getColorBufferTexture().getTextureObjectHandle();
        float pMinX = posX;
        float pMinY = posY;
        float pMaxX = posX + this.sizeX;
        float pMaxY = posY + this.sizeY;
        float uvMinX = 0.0f;
        float uvMinY = percentOfFramebufferUsedY;
        float uvMaxX = percentOfFramebufferUsedX;
        float uvMaxY = 0.0f;
        ImGui.getWindowDrawList().addImage(textureID, pMinX, pMinY, pMaxX, pMaxY, uvMinX, uvMinY, uvMaxX, uvMaxY);
        ImGui.end();
        ImGui.popStyleVar();
    }

    private void saveApplicationSettings(ImGuiConfigurationLocation saveConfigurationLocation) {
        this.imGuiWindowAndDockSystem.saveConfiguration(saveConfigurationLocation);
        Consumer<ObjectNode> rootConsumer = root -> {
            root.put("windowWidth", Gdx.graphics.getWidth());
            root.put("windowHeight", Gdx.graphics.getHeight());
        };
        if (saveConfigurationLocation.isVersionControl()) {
            LogTools.info((String)"Saving libGDX settings to {}", (Object)this.libGDXSettingsFile.getWorkspaceFile().toString());
            JSONFileTools.save((Path)this.libGDXSettingsFile.getWorkspaceFile(), rootConsumer);
        } else {
            LogTools.info((String)"Saving libGDX settings to {}", (Object)this.libGDXSettingsFile.getExternalFile().toString());
            JSONFileTools.save((Path)this.libGDXSettingsFile.getExternalFile(), rootConsumer);
        }
    }

    public void dispose() {
        this.imGuiWindowAndDockSystem.dispose();
    }

    public void addOnCloseRequestListener(Runnable onCloseRequest) {
        this.onCloseRequestListeners.add(onCloseRequest);
    }

    public void addImGui2DViewInputProcessor(Consumer<ImGui2DViewInput> processImGuiInput) {
        this.imgui2DViewInputProcessors.add(processImGuiInput);
    }

    public void setVsync(boolean enabled) {
        this.vsync.set(enabled);
        Gdx.graphics.setVSync(enabled);
    }

    public void setForegroundFPS(int foregroundFPS) {
        this.foregroundFPS.set(foregroundFPS);
        Gdx.graphics.setForegroundFPS(foregroundFPS);
    }

    public ImGuiPanelManager getImGuiPanelManager() {
        return this.imGuiWindowAndDockSystem.getPanelManager();
    }

    public RDXImGuiLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public RDX2DSceneManager get2DSceneManager() {
        return this.sceneManager;
    }

    public float getViewportSizeX() {
        return this.sizeX;
    }

    public float getViewportSizeY() {
        return this.sizeY;
    }

    public RDXImGuiWindowAndDockSystem getImGuiWindowAndDockSystem() {
        return this.imGuiWindowAndDockSystem;
    }

    public HybridDirectory getConfigurationBaseDirectory() {
        return this.configurationBaseDirectory;
    }
}

