/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.graphics.profiling.GLProfiler;
import com.fasterxml.jackson.databind.node.ObjectNode;
import imgui.internal.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImFloat;
import imgui.type.ImInt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import us.ihmc.commons.FormattingTools;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.commons.nio.WriteOption;
import us.ihmc.commons.time.Stopwatch;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.Lwjgl3ApplicationAdapter;
import us.ihmc.rdx.imgui.ImGuiPanelManager;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;
import us.ihmc.rdx.imgui.RDXImGuiWindowAndDockSystem;
import us.ihmc.rdx.input.RDXInputMode;
import us.ihmc.rdx.sceneManager.RDX3DScene;
import us.ihmc.rdx.sceneManager.RDXSceneLevel;
import us.ihmc.rdx.tools.LibGDXApplicationCreator;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.ui.ImGuiConfigurationLocation;
import us.ihmc.rdx.ui.RDX3DPanel;
import us.ihmc.rdx.ui.RDXImGuiLayoutManager;
import us.ihmc.rdx.vr.RDXVRManager;
import us.ihmc.tools.io.HybridDirectory;
import us.ihmc.tools.io.HybridFile;
import us.ihmc.tools.io.JSONFileTools;
import us.ihmc.tools.time.FrequencyCalculator;

public class RDXBaseUI {
    public static final int ANTI_ALIASING = 2;
    private static boolean RECORD_VIDEO = Boolean.parseBoolean(System.getProperty("record.video"));
    public static volatile Object ACTIVE_EDITOR;
    private static final String VIEW_3D_WINDOW_NAME = "3D View";
    private GLProfiler glProfiler;
    private final RDX3DScene primaryScene = new RDX3DScene();
    private final RDX3DPanel primary3DPanel;
    private final ArrayList<RDX3DPanel> additional3DPanels = new ArrayList();
    private final RDXVRManager vrManager = new RDXVRManager();
    private final RDXImGuiWindowAndDockSystem imGuiWindowAndDockSystem;
    private final ArrayList<Runnable> onCloseRequestListeners = new ArrayList();
    private final String windowTitle;
    private final Path dotIHMCDirectory = Paths.get(System.getProperty("user.home"), ".ihmc");
    private String configurationExtraPath;
    private final HybridDirectory configurationBaseDirectory;
    private HybridFile libGDXSettingsFile;
    private final FrequencyCalculator fpsCalculator = new FrequencyCalculator();
    private final Stopwatch runTime = new Stopwatch().start();
    private String statusText = "";
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final ImInt foregroundFPS = new ImInt(240);
    private final ImBoolean vsync = new ImBoolean(false);
    private final ImBoolean shadows = new ImBoolean(false);
    private final ImBoolean middleClickOrbit = new ImBoolean(false);
    private final ImBoolean modelSceneMouseCollisionEnabled = new ImBoolean(false);
    private final ImFloat backgroundShade = new ImFloat(0.5019608f);
    private final ImInt libGDXLogLevel = new ImInt(LibGDXTools.toLibGDX(LogTools.getLevel()));
    private final ImFloat imguiFontScale = new ImFloat(1.0f);
    private final RDXImGuiLayoutManager layoutManager;
    private long renderIndex = 0L;
    private double isoZoomOut = 0.7;
    private Theme theme = Theme.LIGHT;
    private Path themeFilePath;
    private final String shadePrefix = "shade=";

    public RDXBaseUI(String directoryNameToAssumePresent, String subsequentPathToResourceFolder) {
        this(0, directoryNameToAssumePresent, subsequentPathToResourceFolder, null);
    }

    public RDXBaseUI(String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String windowTitle) {
        this(0, directoryNameToAssumePresent, subsequentPathToResourceFolder, windowTitle);
    }

    RDXBaseUI(int additionalStackHeightForFindingCaller, String directoryNameToAssumePresent, String subsequentPathToResourceFolder, String windowTitle) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        Class classForLoading = (Class)ExceptionTools.handle(() -> Class.forName(stackTraceElements[3 + additionalStackHeightForFindingCaller].getClassName()), (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
        LogTools.info((String)"Using class for loading resources: {}", (Object)classForLoading.getName());
        windowTitle = windowTitle == null ? classForLoading.getSimpleName() : windowTitle;
        this.windowTitle = windowTitle;
        this.configurationExtraPath = "/configurations/" + windowTitle.replaceAll(" ", "");
        this.configurationBaseDirectory = new HybridDirectory(this.dotIHMCDirectory, directoryNameToAssumePresent, subsequentPathToResourceFolder, classForLoading, this.configurationExtraPath);
        this.imGuiWindowAndDockSystem = new RDXImGuiWindowAndDockSystem();
        this.layoutManager = new RDXImGuiLayoutManager(classForLoading, directoryNameToAssumePresent, subsequentPathToResourceFolder, this.configurationExtraPath, this.configurationBaseDirectory);
        this.layoutManager.getLayoutDirectoryUpdatedListeners().add(this.imGuiWindowAndDockSystem::setDirectory);
        this.layoutManager.getLayoutDirectoryUpdatedListeners().add(updatedLayoutDirectory -> {
            this.libGDXSettingsFile = new HybridFile(updatedLayoutDirectory, "GDXSettings.json");
        });
        this.layoutManager.getLoadListeners().add(this.imGuiWindowAndDockSystem::loadConfiguration);
        this.layoutManager.getLoadListeners().add(loadConfigurationLocation -> {
            Gdx.graphics.setWindowedMode(this.imGuiWindowAndDockSystem.getCalculatedPrimaryWindowSize().getWidth(), this.imGuiWindowAndDockSystem.getCalculatedPrimaryWindowSize().getHeight());
            ((Lwjgl3Graphics)Gdx.graphics).getWindow().setPosition(this.imGuiWindowAndDockSystem.getPrimaryWindowPosition().getX(), this.imGuiWindowAndDockSystem.getPrimaryWindowPosition().getY());
            return true;
        });
        this.layoutManager.getSaveListeners().add(this::saveApplicationSettings);
        this.layoutManager.applyLayoutDirectory();
        if (RECORD_VIDEO) {
            // empty if block
        }
        this.primary3DPanel = new RDX3DPanel(VIEW_3D_WINDOW_NAME, 2, true);
    }

    public void launchRDXApplication(Lwjgl3ApplicationAdapter applicationAdapter) {
        LogTools.info((String)"Launching RDX application");
        Lwjgl3ApplicationConfiguration applicationConfiguration = LibGDXApplicationCreator.getDefaultConfiguration(this.windowTitle);
        applicationConfiguration.setInitialVisible(false);
        LibGDXApplicationCreator.launchGDXApplication(applicationConfiguration, applicationAdapter, this.windowTitle);
    }

    public void create() {
        this.create(RDXSceneLevel.MODEL, RDXSceneLevel.VIRTUAL);
    }

    public void create(RDXSceneLevel ... sceneLevels) {
        LogTools.info((String)"Creating...");
        LibGDXTools.printGLVersion();
        if (LibGDXTools.ENABLE_OPENGL_DEBUGGER) {
            this.glProfiler = LibGDXTools.createGLProfiler();
        }
        this.primaryScene.create(sceneLevels);
        this.primaryScene.addDefaultLighting();
        this.primary3DPanel.create(RDXInputMode.ImGui, this.glProfiler, this.primaryScene);
        this.imGuiWindowAndDockSystem.getPanelManager().addPanel(this.primary3DPanel.getImGuiPanel());
        this.primary3DPanel.getImGuiPanel().getIsShowing().set(true);
        Gdx.input.setInputProcessor(null);
        this.primary3DPanel.getCamera3D().changeCameraPosition(-this.isoZoomOut, -this.isoZoomOut, this.isoZoomOut);
        this.primaryScene.addCoordinateFrame(0.3);
        this.imGuiWindowAndDockSystem.create(((Lwjgl3Graphics)Gdx.graphics).getWindow().getWindowHandle(), this.layoutManager);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Gdx.app.exit(), "Exit" + this.getClass().getSimpleName()));
        this.vrManager.create();
        this.primaryScene.addRenderableProvider(this.vrManager::getVirtualRenderables, RDXSceneLevel.VIRTUAL);
        this.primary3DPanel.addImGui3DViewPickCalculator(this.vrManager::calculate3DViewPick);
        this.primary3DPanel.addImGui3DViewInputProcessor(this.vrManager::process3DViewInput);
        this.imGuiWindowAndDockSystem.getPanelManager().addPanel("VR Thread Debugger", this.vrManager::renderImGuiDebugWidgets);
        this.imGuiWindowAndDockSystem.getPanelManager().addPanel("VR Settings", this.vrManager::renderImGuiTunerWidgets);
        this.themeFilePath = Paths.get(System.getProperty("user.home"), ".ihmc/themePreference.ini");
        if (Files.exists(this.themeFilePath, new LinkOption[0])) {
            List lines = FileTools.readAllLines((Path)this.themeFilePath, (ExceptionHandler)DefaultExceptionHandler.PROCEED_SILENTLY);
            int numberOfLines = lines.size();
            String firstLine = "";
            String secondLine = "";
            if (numberOfLines > 0) {
                firstLine = (String)lines.get(0);
            }
            if (numberOfLines > 1) {
                secondLine = (String)lines.get(1);
            }
            for (Theme theme : Theme.values()) {
                if (!firstLine.contains(theme.name())) continue;
                this.setTheme(theme);
            }
            try {
                if (!secondLine.isEmpty()) {
                    this.backgroundShade.set(Float.parseFloat(secondLine.substring("shade=".length())));
                    this.setBackgroundShade(this.backgroundShade.get());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void renderBeforeOnScreenUI() {
        this.vrManager.pollEventsAndRender(this, this.primaryScene);
        Gdx.graphics.setTitle(this.windowTitle);
        this.imGuiWindowAndDockSystem.beforeWindowManagement();
        this.primary3DPanel.render();
        for (RDX3DPanel additional3DPanel : this.additional3DPanels) {
            additional3DPanel.render();
        }
        this.renderMenuBar();
    }

    public void renderEnd() {
        this.imGuiWindowAndDockSystem.afterWindowManagement();
        ++this.renderIndex;
        if (this.renderIndex == 2L) {
            ((Lwjgl3Graphics)Gdx.graphics).getWindow().setVisible(true);
        }
    }

    private void renderMenuBar() {
        ImGui.beginMainMenuBar();
        this.layoutManager.renderImGuiLayoutMenu();
        if (ImGui.beginMenu((String)"Panels")) {
            this.imGuiWindowAndDockSystem.renderMenuDockPanelItems();
            ImGui.endMenu();
        }
        if (ImGui.beginMenu((String)"Settings")) {
            ImGui.pushItemWidth((float)80.0f);
            if (ImGuiTools.volatileInputInt(this.labels.get("Foreground FPS Limit"), this.foregroundFPS, 1)) {
                Gdx.graphics.setForegroundFPS(this.foregroundFPS.get());
            }
            if (ImGui.checkbox((String)this.labels.get("Vsync"), (ImBoolean)this.vsync)) {
                Gdx.graphics.setVSync(this.vsync.get());
            }
            if (ImGui.checkbox((String)this.labels.get("Shadows"), (ImBoolean)this.shadows)) {
                this.primaryScene.setShadowsEnabled(this.shadows.get());
            }
            if (ImGuiTools.volatileInputInt(this.labels.get("libGDX log level"), this.libGDXLogLevel, 1)) {
                Gdx.app.setLogLevel(this.libGDXLogLevel.get());
            }
            if (ImGuiTools.volatileInputFloat(this.labels.get("Font Size"), this.imguiFontScale, 0.1f)) {
                ImGui.getIO().setFontGlobalScale(this.imguiFontScale.get());
            }
            ImGui.separator();
            boolean renderingGroundTruthEnvironment = this.primaryScene.getSceneLevelsToRender().contains((Object)RDXSceneLevel.GROUND_TRUTH);
            if (ImGui.checkbox((String)this.labels.get("Render Ground Truth Environment"), (boolean)renderingGroundTruthEnvironment)) {
                if (renderingGroundTruthEnvironment) {
                    this.primaryScene.getSceneLevelsToRender().remove((Object)RDXSceneLevel.GROUND_TRUTH);
                } else {
                    this.primaryScene.getSceneLevelsToRender().add(RDXSceneLevel.GROUND_TRUTH);
                }
            }
            boolean renderingModelEnvironment = this.primaryScene.getSceneLevelsToRender().contains((Object)RDXSceneLevel.MODEL);
            if (ImGui.checkbox((String)this.labels.get("Render Model Environment"), (boolean)renderingModelEnvironment)) {
                if (renderingModelEnvironment) {
                    this.primaryScene.getSceneLevelsToRender().remove((Object)RDXSceneLevel.MODEL);
                } else {
                    this.primaryScene.getSceneLevelsToRender().add(RDXSceneLevel.MODEL);
                }
            }
            boolean renderingVirtualEnvironment = this.primaryScene.getSceneLevelsToRender().contains((Object)RDXSceneLevel.VIRTUAL);
            if (ImGui.checkbox((String)this.labels.get("Render Virtual Environment"), (boolean)renderingVirtualEnvironment)) {
                if (renderingVirtualEnvironment) {
                    this.primaryScene.getSceneLevelsToRender().remove((Object)RDXSceneLevel.VIRTUAL);
                } else {
                    this.primaryScene.getSceneLevelsToRender().add(RDXSceneLevel.VIRTUAL);
                }
            }
            if (ImGui.checkbox((String)this.labels.get("Model scene mouse collision enabled"), (ImBoolean)this.modelSceneMouseCollisionEnabled)) {
                this.setModelSceneMouseCollisionEnabled(this.modelSceneMouseCollisionEnabled.get());
            }
            ImGui.separator();
            if (ImGui.checkbox((String)this.labels.get("Middle-click view orbit"), (ImBoolean)this.middleClickOrbit)) {
                this.setUseMiddleClickViewOrbit(this.middleClickOrbit.get());
            }
            float previousShade = this.backgroundShade.get();
            if (ImGuiTools.volatileInputFloat(this.labels.get("Background shade"), this.backgroundShade)) {
                this.setBackgroundShade(this.backgroundShade.get());
            }
            ImGui.separator();
            ImGui.text((String)"UI Theme:");
            ImGui.sameLine();
            Theme previousTheme = this.theme;
            for (int i = 0; i < Theme.values().length; ++i) {
                if (ImGui.radioButton((String)this.labels.get(StringUtils.capitalize((String)Theme.values()[i].name().toLowerCase())), (this.theme == Theme.values()[i] ? 1 : 0) != 0)) {
                    this.setTheme(Theme.values()[i]);
                }
                if (i >= Theme.values().length - 1) continue;
                ImGui.sameLine();
            }
            if (this.theme != previousTheme || previousShade != this.backgroundShade.get()) {
                FileTools.ensureFileExists((Path)this.themeFilePath, (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
                FileTools.writeAllLines(List.of("theme=" + this.theme.name() + "\nshade=" + this.backgroundShade), (Path)this.themeFilePath, (WriteOption)WriteOption.TRUNCATE, (ExceptionHandler)DefaultExceptionHandler.MESSAGE_AND_STACKTRACE);
            }
            ImGui.popItemWidth();
            ImGui.endMenu();
        }
        ImGui.sameLine((float)(ImGui.getWindowSizeX() - 220.0f));
        this.fpsCalculator.ping();
        Object fpsString = String.valueOf((int)this.fpsCalculator.getFrequency());
        while (((String)fpsString).length() < 3) {
            fpsString = " " + (String)fpsString;
        }
        ImGui.text((String)((String)fpsString + " Hz"));
        ImGui.text((String)(FormattingTools.getFormattedDecimal2D((double)this.runTime.totalElapsed()) + " s"));
        ImGui.sameLine((float)(ImGui.getWindowSizeX() - 100.0f));
        this.vrManager.renderImGuiEnableWidget();
        ImGui.endMainMenuBar();
    }

    private void saveApplicationSettings(ImGuiConfigurationLocation saveConfigurationLocation) {
        this.imGuiWindowAndDockSystem.saveConfiguration(saveConfigurationLocation);
        Consumer<ObjectNode> rootConsumer = root -> {
            root.put("windowWidth", Gdx.graphics.getWidth());
            root.put("windowHeight", Gdx.graphics.getHeight());
        };
        if (saveConfigurationLocation.isVersionControl()) {
            LogTools.info((String)"Saving libGDX settings to {}", (Object)this.libGDXSettingsFile.getWorkspaceFile().toString());
            JSONFileTools.save((Path)this.libGDXSettingsFile.getWorkspaceFile(), rootConsumer);
        } else {
            LogTools.info((String)"Saving libGDX settings to {}", (Object)this.libGDXSettingsFile.getExternalFile().toString());
            JSONFileTools.save((Path)this.libGDXSettingsFile.getExternalFile(), rootConsumer);
        }
    }

    public void dispose() {
        this.imGuiWindowAndDockSystem.dispose();
        this.vrManager.dispose();
        this.primaryScene.dispose();
    }

    public void add3DPanel(RDX3DPanel panel3D) {
        this.add3DPanel(panel3D, this.primaryScene);
    }

    public void add3DPanel(RDX3DPanel panel3D, RDX3DScene scene3D) {
        panel3D.create(RDXInputMode.ImGui, this.glProfiler, scene3D);
        panel3D.getCamera3D().changeCameraPosition(-this.isoZoomOut, -this.isoZoomOut, this.isoZoomOut);
        this.imGuiWindowAndDockSystem.getPanelManager().addPanel(panel3D.getImGuiPanel());
        this.additional3DPanels.add(panel3D);
    }

    public void addOnCloseRequestListener(Runnable onCloseRequest) {
        this.onCloseRequestListeners.add(onCloseRequest);
    }

    public void setStatus(String statusText) {
        this.statusText = statusText;
    }

    public void setVsync(boolean enabled) {
        this.vsync.set(enabled);
        Gdx.graphics.setVSync(enabled);
    }

    public void setForegroundFPS(int foregroundFPS) {
        this.foregroundFPS.set(foregroundFPS);
        Gdx.graphics.setForegroundFPS(foregroundFPS);
    }

    public ImGuiPanelManager getImGuiPanelManager() {
        return this.imGuiWindowAndDockSystem.getPanelManager();
    }

    public RDXImGuiLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public RDX3DScene getPrimaryScene() {
        return this.primaryScene;
    }

    public RDX3DPanel getPrimary3DPanel() {
        return this.primary3DPanel;
    }

    public RDXVRManager getVRManager() {
        return this.vrManager;
    }

    public RDXImGuiWindowAndDockSystem getImGuiWindowAndDockSystem() {
        return this.imGuiWindowAndDockSystem;
    }

    public HybridDirectory getConfigurationBaseDirectory() {
        return this.configurationBaseDirectory;
    }

    public long getRenderIndex() {
        return this.renderIndex;
    }

    public void setUseMiddleClickViewOrbit(boolean useMiddleClickViewOrbit) {
        this.middleClickOrbit.set(useMiddleClickViewOrbit);
        this.primary3DPanel.getCamera3D().setUseMiddleClickViewOrbit(useMiddleClickViewOrbit);
        for (RDX3DPanel additional3DPanel : this.additional3DPanels) {
            additional3DPanel.getCamera3D().setUseMiddleClickViewOrbit(useMiddleClickViewOrbit);
        }
    }

    public void setBackgroundShade(float backgroundShade) {
        this.backgroundShade.set(backgroundShade);
        this.primary3DPanel.setBackgroundShade(backgroundShade);
        for (RDX3DPanel additional3DPanel : this.additional3DPanels) {
            additional3DPanel.setBackgroundShade(backgroundShade);
        }
    }

    public void setModelSceneMouseCollisionEnabled(boolean modelSceneMouseCollisionEnabled) {
        this.modelSceneMouseCollisionEnabled.set(modelSceneMouseCollisionEnabled);
        this.primary3DPanel.setModelSceneMouseCollisionEnabled(modelSceneMouseCollisionEnabled);
        for (RDX3DPanel additional3DPanel : this.additional3DPanels) {
            additional3DPanel.setModelSceneMouseCollisionEnabled(modelSceneMouseCollisionEnabled);
        }
    }

    public void setTheme(Theme theme) {
        switch (theme) {
            case LIGHT: {
                ImGui.styleColorsLight();
                break;
            }
            case DARK: {
                ImGui.styleColorsDark();
                break;
            }
            case CLASSIC: {
                ImGui.styleColorsClassic();
            }
        }
        this.theme = theme;
    }

    private static enum Theme {
        LIGHT,
        DARK,
        CLASSIC;

    }
}

