/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.ui;

import imgui.ImGui;
import java.util.ArrayList;
import us.ihmc.rdx.imgui.ImGuiTools;
import us.ihmc.rdx.imgui.ImGuiUniqueLabelMap;
import us.ihmc.rdx.tools.RDXIconTexture;
import us.ihmc.rdx.ui.RDX3DPanelToolbarButton;

public class RDX3DPanelToolbar {
    private final ImGuiUniqueLabelMap labels = new ImGuiUniqueLabelMap(this.getClass());
    private final float iconSize = 35.0f;
    private final float gap = 17.7f;
    private final ArrayList<RDX3DPanelToolbarButton> buttons = new ArrayList();

    public RDX3DPanelToolbarButton addButton() {
        RDX3DPanelToolbarButton toolbarButton = new RDX3DPanelToolbarButton();
        this.buttons.add(toolbarButton);
        return toolbarButton;
    }

    public void render(float mainWindowWidth, float mainWindowPosX, float mainWindowPosY) {
        if (this.buttons.size() > 0) {
            int numButtons = this.buttons.size();
            float offsetY = 12.0f;
            float panelWidth = 35.0f * (float)numButtons + 17.7f * (float)numButtons;
            float panelHeight = 35.0f + 2.0f * offsetY;
            ImGui.setNextWindowSize((float)panelWidth, (float)panelHeight);
            float centerX = mainWindowPosX + mainWindowWidth / 2.0f;
            float startX = centerX - panelWidth / 2.0f;
            ImGui.setNextWindowPos((float)startX, (float)(mainWindowPosY + 15.0f));
            int windowFlags = 1;
            ImGui.begin((String)this.labels.get("Toolbar"), (int)windowFlags);
            for (RDX3DPanelToolbarButton button : this.buttons) {
                RDXIconTexture icon = button.getIcon();
                if (icon == null) continue;
                if (ImGui.imageButton((int)icon.getTexture().getTextureObjectHandle(), (float)35.0f, (float)35.0f)) {
                    button.onPressed();
                }
                if (button.getTooltipText() != null) {
                    ImGuiTools.previousWidgetTooltip(button.getTooltipText());
                }
                ImGui.sameLine();
            }
            ImGui.end();
        }
    }
}

