/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.tools;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.loader.G3dModelLoader;
import com.badlogic.gdx.graphics.g3d.model.data.ModelData;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.UBJsonReader;
import java.util.HashMap;
import us.ihmc.log.LogTools;
import us.ihmc.rdx.tools.LibGDXTools;
import us.ihmc.rdx.tools.assimp.RDXAssimpModelLoader;
import us.ihmc.tools.io.resources.ResourceTools;

public class RDXModelLoader {
    private static final RDXModelLoader modelLoader = new RDXModelLoader();
    private final HashMap<String, Object> modelLoadingSynchronizers = new HashMap();
    private final HashMap<String, Model> loadedModels = new HashMap();

    private RDXModelLoader() {
    }

    public static Model load(String modelFileName) {
        return modelLoader.loadOrGetModel(modelFileName);
    }

    public static ModelData loadModelData(String modelFileName) {
        return modelLoader.loadModelDataInternal(modelFileName);
    }

    public static void destroy() {
        modelLoader.destroyInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model loadOrGetModel(String modelFileName) {
        Model model;
        Object preventLoadingMoreThanOnceSynchronizer;
        modelFileName = ResourceTools.sanitizeResourcePath((String)modelFileName);
        Object object = preventLoadingMoreThanOnceSynchronizer = this.modelLoadingSynchronizers.computeIfAbsent(modelFileName, key -> new Object());
        synchronized (object) {
            ModelData modelData;
            model = this.loadedModels.get(modelFileName);
            if (model == null && (modelData = RDXModelLoader.loadModelData(modelFileName)) != null) {
                model = new Model(modelData);
                RDXModelLoader.ensureModelHasDiffuseTextureAttribute(modelFileName, model);
                this.loadedModels.put(modelFileName, model);
            }
        }
        return model;
    }

    private ModelData loadModelDataInternal(String modelFileName) {
        LogTools.debug((String)"Loading {}", (Object)modelFileName);
        ModelData modelData = null;
        try {
            modelFileName = this.useABetterFormatIfAvailable(modelFileName);
            if (modelFileName.endsWith(".g3dj")) {
                fileHandle = Gdx.files.internal(modelFileName);
                modelData = new G3dModelLoader((BaseJsonReader)new JsonReader()).loadModelData(fileHandle);
            } else if (modelFileName.endsWith(".g3db")) {
                fileHandle = Gdx.files.internal(modelFileName);
                modelData = new G3dModelLoader((BaseJsonReader)new UBJsonReader()).loadModelData(fileHandle);
            } else {
                LogTools.warn((String)"Using Assimp to load {}. It is recommended to convert to G3DJ for more reliable and faster loading.", (Object)modelFileName);
                modelData = new RDXAssimpModelLoader(modelFileName).loadModelData();
            }
            long numberOfVertices = LibGDXTools.countVertices(modelData);
            LogTools.debug((String)"Loaded {} ({} vertices)", (Object)modelFileName, (Object)numberOfVertices);
            if (numberOfVertices > 15000L) {
                LogTools.warn((String)"{} has {} vertices, which is a lot! This will begin to affect frame rate.", (Object)modelFileName, (Object)numberOfVertices);
            }
        }
        catch (SerializationException | NullPointerException e) {
            LogTools.error((String)"Failed to load {}", (Object)modelFileName);
            e.printStackTrace();
        }
        return modelData;
    }

    public static void ensureModelHasDiffuseTextureAttribute(String modelFileName, Model model) {
        for (Material material : model.materials) {
            if (material.has(TextureAttribute.Diffuse)) continue;
            LogTools.debug((String)("Material \"" + material.id + "\" in model \"" + modelFileName + "\" does not contain TextureAttribute Diffuse. Creating..."));
            Pixmap map = new Pixmap(100, 100, Pixmap.Format.RGBA8888);
            map.setColor(((ColorAttribute)material.get((long)ColorAttribute.Diffuse)).color);
            map.drawRectangle(0, 0, 100, 100);
            material.set((Attribute)TextureAttribute.createDiffuse((Texture)new Texture(map)));
            map.dispose();
        }
    }

    private String useABetterFormatIfAvailable(String modelFileName) {
        String modelFileNameWithoutExtension;
        FileHandle potentialFileHandle;
        boolean gltfExists = false;
        boolean g3dbExists = false;
        if (!gltfExists && !((String)modelFileName).endsWith(".g3db") && (potentialFileHandle = Gdx.files.internal((modelFileNameWithoutExtension = ((String)modelFileName).substring(0, ((String)modelFileName).lastIndexOf("."))) + ".g3db")).exists()) {
            LogTools.debug((String)"Found G3DB file as an alternative for {}", (Object)modelFileName);
            modelFileName = modelFileNameWithoutExtension + ".g3db";
            g3dbExists = true;
        }
        if (!gltfExists && !g3dbExists && !((String)modelFileName).endsWith(".g3dj") && (potentialFileHandle = Gdx.files.internal((modelFileNameWithoutExtension = ((String)modelFileName).substring(0, ((String)modelFileName).lastIndexOf("."))) + ".g3dj")).exists()) {
            LogTools.debug((String)"Found G3DJ file as an alternative for {}", (Object)modelFileName);
            modelFileName = modelFileNameWithoutExtension + ".g3dj";
        }
        return modelFileName;
    }

    private void destroyInternal() {
        for (Model loadedModel : this.loadedModels.values()) {
            loadedModel.dispose();
        }
        this.loadedModels.clear();
    }
}

