/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.rdx.tools;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.model.data.ModelData;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMesh;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMeshPart;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.profiling.GLInterceptor;
import com.badlogic.gdx.graphics.profiling.GLProfiler;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import java.nio.FloatBuffer;
import javafx.scene.paint.Color;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL41;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.openvr.HmdMatrix34;
import org.lwjgl.openvr.HmdMatrix44;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Callback;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.visual.ColorDefinition;

public class LibGDXTools {
    public static boolean ENABLE_OPENGL_DEBUGGER = Boolean.parseBoolean(System.getProperty("enable.opengl.debugger", "false"));

    public static void syncLogLevelWithLogTools() {
        Gdx.app.setLogLevel(LibGDXTools.toLibGDX(LogTools.getLevel()));
    }

    public static int toLibGDX(Level log4jLevel) {
        int gdxLogLevel = 2;
        switch (log4jLevel.getStandardLevel()) {
            case OFF: {
                gdxLogLevel = 0;
                break;
            }
            case FATAL: 
            case ERROR: {
                gdxLogLevel = 1;
                break;
            }
            case WARN: 
            case INFO: {
                gdxLogLevel = 2;
                break;
            }
            case DEBUG: 
            case TRACE: {
                gdxLogLevel = 3;
            }
        }
        return gdxLogLevel;
    }

    public static void toLibGDX(AffineTransform euclidAffine, Matrix4 gdxAffineToPack) {
        gdxAffineToPack.val[0] = (float)euclidAffine.getM00();
        gdxAffineToPack.val[4] = (float)euclidAffine.getM01();
        gdxAffineToPack.val[8] = (float)euclidAffine.getM02();
        gdxAffineToPack.val[1] = (float)euclidAffine.getM10();
        gdxAffineToPack.val[5] = (float)euclidAffine.getM11();
        gdxAffineToPack.val[9] = (float)euclidAffine.getM12();
        gdxAffineToPack.val[2] = (float)euclidAffine.getM20();
        gdxAffineToPack.val[6] = (float)euclidAffine.getM21();
        gdxAffineToPack.val[10] = (float)euclidAffine.getM22();
        gdxAffineToPack.val[12] = (float)euclidAffine.getM03();
        gdxAffineToPack.val[13] = (float)euclidAffine.getM13();
        gdxAffineToPack.val[14] = (float)euclidAffine.getM23();
    }

    public static void toEuclid(Matrix4 gdxAffine, AffineTransform euclidAffine) {
        euclidAffine.getLinearTransform().setM00((double)gdxAffine.val[0]);
        euclidAffine.getLinearTransform().setM01((double)gdxAffine.val[4]);
        euclidAffine.getLinearTransform().setM02((double)gdxAffine.val[8]);
        euclidAffine.getLinearTransform().setM10((double)gdxAffine.val[1]);
        euclidAffine.getLinearTransform().setM11((double)gdxAffine.val[5]);
        euclidAffine.getLinearTransform().setM12((double)gdxAffine.val[9]);
        euclidAffine.getLinearTransform().setM20((double)gdxAffine.val[2]);
        euclidAffine.getLinearTransform().setM21((double)gdxAffine.val[6]);
        euclidAffine.getLinearTransform().setM22((double)gdxAffine.val[10]);
        euclidAffine.getLinearTransform().normalize();
        euclidAffine.getTranslation().setX((double)gdxAffine.val[12]);
        euclidAffine.getTranslation().setY((double)gdxAffine.val[13]);
        euclidAffine.getTranslation().setZ((double)gdxAffine.val[14]);
    }

    public static void toEuclid(Matrix4 gdxAffine, RotationMatrix euclidRotationMatrix) {
        euclidRotationMatrix.setAndNormalize((double)gdxAffine.val[0], (double)gdxAffine.val[4], (double)gdxAffine.val[8], (double)gdxAffine.val[1], (double)gdxAffine.val[5], (double)gdxAffine.val[9], (double)gdxAffine.val[2], (double)gdxAffine.val[6], (double)gdxAffine.val[10]);
    }

    public static void toLibGDX(RigidBodyTransform rigidBodyTransform, Matrix4 gdxAffineToPack) {
        gdxAffineToPack.val[0] = (float)rigidBodyTransform.getM00();
        gdxAffineToPack.val[4] = (float)rigidBodyTransform.getM01();
        gdxAffineToPack.val[8] = (float)rigidBodyTransform.getM02();
        gdxAffineToPack.val[1] = (float)rigidBodyTransform.getM10();
        gdxAffineToPack.val[5] = (float)rigidBodyTransform.getM11();
        gdxAffineToPack.val[9] = (float)rigidBodyTransform.getM12();
        gdxAffineToPack.val[2] = (float)rigidBodyTransform.getM20();
        gdxAffineToPack.val[6] = (float)rigidBodyTransform.getM21();
        gdxAffineToPack.val[10] = (float)rigidBodyTransform.getM22();
        gdxAffineToPack.val[12] = (float)rigidBodyTransform.getM03();
        gdxAffineToPack.val[13] = (float)rigidBodyTransform.getM13();
        gdxAffineToPack.val[14] = (float)rigidBodyTransform.getM23();
    }

    public static void toLibGDX(HmdMatrix44 openVRProjectionMatrix, Matrix4 gdxProjectionMatrixToPack) {
        FloatBuffer openVRValueBuffer = openVRProjectionMatrix.m();
        gdxProjectionMatrixToPack.val[0] = openVRValueBuffer.get(0);
        gdxProjectionMatrixToPack.val[1] = openVRValueBuffer.get(4);
        gdxProjectionMatrixToPack.val[2] = openVRValueBuffer.get(8);
        gdxProjectionMatrixToPack.val[3] = openVRValueBuffer.get(12);
        gdxProjectionMatrixToPack.val[4] = openVRValueBuffer.get(1);
        gdxProjectionMatrixToPack.val[5] = openVRValueBuffer.get(5);
        gdxProjectionMatrixToPack.val[6] = openVRValueBuffer.get(9);
        gdxProjectionMatrixToPack.val[7] = openVRValueBuffer.get(13);
        gdxProjectionMatrixToPack.val[8] = openVRValueBuffer.get(2);
        gdxProjectionMatrixToPack.val[9] = openVRValueBuffer.get(6);
        gdxProjectionMatrixToPack.val[10] = openVRValueBuffer.get(10);
        gdxProjectionMatrixToPack.val[11] = openVRValueBuffer.get(14);
        gdxProjectionMatrixToPack.val[12] = openVRValueBuffer.get(3);
        gdxProjectionMatrixToPack.val[13] = openVRValueBuffer.get(7);
        gdxProjectionMatrixToPack.val[14] = openVRValueBuffer.get(11);
        gdxProjectionMatrixToPack.val[15] = openVRValueBuffer.get(15);
    }

    public static void toLibGDX(HmdMatrix34 openVRRigidBodyTransform, Matrix4 gdxAffineToPack) {
        FloatBuffer openVRValueBuffer = openVRRigidBodyTransform.m();
        gdxAffineToPack.val[0] = openVRValueBuffer.get(0);
        gdxAffineToPack.val[1] = openVRValueBuffer.get(4);
        gdxAffineToPack.val[2] = openVRValueBuffer.get(8);
        gdxAffineToPack.val[3] = 0.0f;
        gdxAffineToPack.val[4] = openVRValueBuffer.get(1);
        gdxAffineToPack.val[5] = openVRValueBuffer.get(5);
        gdxAffineToPack.val[6] = openVRValueBuffer.get(9);
        gdxAffineToPack.val[7] = 0.0f;
        gdxAffineToPack.val[8] = openVRValueBuffer.get(2);
        gdxAffineToPack.val[9] = openVRValueBuffer.get(6);
        gdxAffineToPack.val[10] = openVRValueBuffer.get(10);
        gdxAffineToPack.val[11] = 0.0f;
        gdxAffineToPack.val[12] = openVRValueBuffer.get(3);
        gdxAffineToPack.val[13] = openVRValueBuffer.get(7);
        gdxAffineToPack.val[14] = openVRValueBuffer.get(11);
        gdxAffineToPack.val[15] = 1.0f;
    }

    public static void toEuclid(HmdMatrix34 openVRRigidBodyTransform, RigidBodyTransform rigidBodyTransformToPack) {
        FloatBuffer openVRValueBuffer = openVRRigidBodyTransform.m();
        rigidBodyTransformToPack.getRotation().setAndNormalize((double)openVRValueBuffer.get(0), (double)openVRValueBuffer.get(1), (double)openVRValueBuffer.get(2), (double)openVRValueBuffer.get(4), (double)openVRValueBuffer.get(5), (double)openVRValueBuffer.get(6), (double)openVRValueBuffer.get(8), (double)openVRValueBuffer.get(9), (double)openVRValueBuffer.get(10));
        rigidBodyTransformToPack.getTranslation().setX((double)openVRValueBuffer.get(3));
        rigidBodyTransformToPack.getTranslation().setY((double)openVRValueBuffer.get(7));
        rigidBodyTransformToPack.getTranslation().setZ((double)openVRValueBuffer.get(11));
    }

    public static void toEuclid(HmdMatrix34 openVRRigidBodyTransform, Pose3DBasics poseToPack) {
        FloatBuffer openVRValueBuffer = openVRRigidBodyTransform.m();
        poseToPack.getOrientation().setRotationMatrix((double)openVRValueBuffer.get(0), (double)openVRValueBuffer.get(1), (double)openVRValueBuffer.get(2), (double)openVRValueBuffer.get(4), (double)openVRValueBuffer.get(5), (double)openVRValueBuffer.get(6), (double)openVRValueBuffer.get(8), (double)openVRValueBuffer.get(9), (double)openVRValueBuffer.get(10));
        poseToPack.getOrientation().normalize();
        poseToPack.getPosition().setX((double)openVRValueBuffer.get(3));
        poseToPack.getPosition().setY((double)openVRValueBuffer.get(7));
        poseToPack.getPosition().setZ((double)openVRValueBuffer.get(11));
    }

    public static void toEuclid(HmdMatrix34 openVRAffineTransform, AffineTransform euclidAffine) {
        FloatBuffer openVRValueBuffer = openVRAffineTransform.m();
        euclidAffine.getLinearTransform().setM00((double)openVRValueBuffer.get(0));
        euclidAffine.getLinearTransform().setM01((double)openVRValueBuffer.get(1));
        euclidAffine.getLinearTransform().setM02((double)openVRValueBuffer.get(2));
        euclidAffine.getLinearTransform().setM10((double)openVRValueBuffer.get(4));
        euclidAffine.getLinearTransform().setM11((double)openVRValueBuffer.get(5));
        euclidAffine.getLinearTransform().setM12((double)openVRValueBuffer.get(6));
        euclidAffine.getLinearTransform().setM20((double)openVRValueBuffer.get(8));
        euclidAffine.getLinearTransform().setM21((double)openVRValueBuffer.get(9));
        euclidAffine.getLinearTransform().setM22((double)openVRValueBuffer.get(10));
        euclidAffine.getLinearTransform().normalize();
        euclidAffine.getTranslation().setX((double)openVRValueBuffer.get(3));
        euclidAffine.getTranslation().setY((double)openVRValueBuffer.get(7));
        euclidAffine.getTranslation().setZ((double)openVRValueBuffer.get(11));
    }

    public static void toEuclid(Matrix4 gdxAffine, RigidBodyTransform rigidBodyTransform) {
        rigidBodyTransform.getRotation().setAndNormalize((double)gdxAffine.val[0], (double)gdxAffine.val[4], (double)gdxAffine.val[8], (double)gdxAffine.val[1], (double)gdxAffine.val[5], (double)gdxAffine.val[9], (double)gdxAffine.val[2], (double)gdxAffine.val[6], (double)gdxAffine.val[10]);
        rigidBodyTransform.getTranslation().setX((double)gdxAffine.val[12]);
        rigidBodyTransform.getTranslation().setY((double)gdxAffine.val[13]);
        rigidBodyTransform.getTranslation().setZ((double)gdxAffine.val[14]);
    }

    public static void toLibGDX(RotationMatrix euclidRotationMatrix, Matrix4 gdxRotationMatrix) {
        gdxRotationMatrix.val[0] = (float)euclidRotationMatrix.getM00();
        gdxRotationMatrix.val[4] = (float)euclidRotationMatrix.getM01();
        gdxRotationMatrix.val[8] = (float)euclidRotationMatrix.getM02();
        gdxRotationMatrix.val[1] = (float)euclidRotationMatrix.getM10();
        gdxRotationMatrix.val[5] = (float)euclidRotationMatrix.getM11();
        gdxRotationMatrix.val[9] = (float)euclidRotationMatrix.getM12();
        gdxRotationMatrix.val[2] = (float)euclidRotationMatrix.getM20();
        gdxRotationMatrix.val[6] = (float)euclidRotationMatrix.getM21();
        gdxRotationMatrix.val[10] = (float)euclidRotationMatrix.getM22();
    }

    public static void toLibGDX(QuaternionReadOnly euclidQuaternion, Quaternion gdxQuaternion) {
        gdxQuaternion.x = euclidQuaternion.getX32();
        gdxQuaternion.y = euclidQuaternion.getY32();
        gdxQuaternion.z = euclidQuaternion.getZ32();
        gdxQuaternion.w = euclidQuaternion.getS32();
    }

    public static void toEuclid(Quaternion gdxQuaternion, us.ihmc.euclid.tuple4D.Quaternion euclidQuaternion) {
        euclidQuaternion.set((double)gdxQuaternion.x, (double)gdxQuaternion.y, (double)gdxQuaternion.z, (double)gdxQuaternion.w);
    }

    public static Vector3 toLibGDX(Tuple3DReadOnly euclidTuple) {
        return new Vector3(euclidTuple.getX32(), euclidTuple.getY32(), euclidTuple.getZ32());
    }

    public static Vector2 toLibGDX(Tuple2DReadOnly euclidTuple) {
        return new Vector2(euclidTuple.getX32(), euclidTuple.getY32());
    }

    public static void toLibGDX(Tuple3DReadOnly euclidTuple, Vector3 gdxVector3) {
        gdxVector3.set(euclidTuple.getX32(), euclidTuple.getY32(), euclidTuple.getZ32());
    }

    public static void toEuclid(Vector3 gdxVector3, Vector3DBasics euclidVector3D32) {
        euclidVector3D32.set((double)gdxVector3.x, (double)gdxVector3.y, (double)gdxVector3.z);
    }

    public static void toEuclid(Vector3 gdxVector3, Point3DBasics euclidPoint3D32) {
        euclidPoint3D32.set((double)gdxVector3.x, (double)gdxVector3.y, (double)gdxVector3.z);
    }

    public static void toEuclid(Matrix4 gdxAffine, Point3DBasics euclidPoint) {
        euclidPoint.set((double)gdxAffine.val[12], (double)gdxAffine.val[13], (double)gdxAffine.val[14]);
    }

    public static void toLibGDX(Point3DReadOnly euclidPoint, Matrix4 gdxAffine) {
        gdxAffine.setTranslation(euclidPoint.getX32(), euclidPoint.getY32(), euclidPoint.getZ32());
    }

    public static void toLibGDX(Pose3DReadOnly euclidPose, RigidBodyTransform tempTransform, Matrix4 gdxAffine) {
        tempTransform.set((RigidBodyTransformReadOnly)euclidPose);
        LibGDXTools.toLibGDX(tempTransform, gdxAffine);
    }

    public static void toLibGDX(Color javaFXColor, com.badlogic.gdx.graphics.Color gdxColor) {
        gdxColor.set((float)javaFXColor.getRed(), (float)javaFXColor.getGreen(), (float)javaFXColor.getBlue(), (float)javaFXColor.getOpacity());
    }

    public static com.badlogic.gdx.graphics.Color toLibGDX(Color javaFXColor) {
        return new com.badlogic.gdx.graphics.Color((float)javaFXColor.getRed(), (float)javaFXColor.getGreen(), (float)javaFXColor.getBlue(), (float)javaFXColor.getOpacity());
    }

    public static Color toJavaFX(com.badlogic.gdx.graphics.Color gdxColor) {
        return Color.color((double)gdxColor.r, (double)gdxColor.g, (double)gdxColor.b, (double)gdxColor.a);
    }

    public static com.badlogic.gdx.graphics.Color hueSaturationValue(double hue, double saturation, double value) {
        return new com.badlogic.gdx.graphics.Color().fromHsv((float)hue, (float)saturation, (float)value);
    }

    public static com.badlogic.gdx.graphics.Color toLibGDX(AppearanceDefinition appearanceDefinition) {
        com.badlogic.gdx.graphics.Color gdxColor = new com.badlogic.gdx.graphics.Color(1.0f, 1.0f, 1.0f, 1.0f);
        LibGDXTools.toLibGDX(appearanceDefinition, gdxColor);
        return gdxColor;
    }

    public static com.badlogic.gdx.graphics.Color toLibGDX(ColorDefinition colorDefinition) {
        com.badlogic.gdx.graphics.Color gdxColor = new com.badlogic.gdx.graphics.Color(1.0f, 1.0f, 1.0f, 1.0f);
        LibGDXTools.toLibGDX(colorDefinition, gdxColor);
        return gdxColor;
    }

    public static void toLibGDX(ColorDefinition colorDefinition, com.badlogic.gdx.graphics.Color gdxColor) {
        gdxColor.r = (float)colorDefinition.getRed();
        gdxColor.g = (float)colorDefinition.getGreen();
        gdxColor.b = (float)colorDefinition.getBlue();
        gdxColor.a = (float)colorDefinition.getAlpha();
    }

    public static void toLibGDX(Vector3 bulletColor, com.badlogic.gdx.graphics.Color gdxColor) {
        gdxColor.r = bulletColor.x;
        gdxColor.g = bulletColor.y;
        gdxColor.b = bulletColor.z;
        gdxColor.a = 1.0f;
    }

    public static com.badlogic.gdx.graphics.Color toLibGDX(double red, double green, double blue, double alpha) {
        return new com.badlogic.gdx.graphics.Color((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void toLibGDX(float[] imColor, com.badlogic.gdx.graphics.Color gdxColor) {
        gdxColor.set(imColor[0], imColor[1], imColor[2], imColor[3]);
    }

    public static void toLibGDX(AppearanceDefinition appearanceDefinition, com.badlogic.gdx.graphics.Color gdxColor) {
        gdxColor.r = appearanceDefinition.getColor().getX();
        gdxColor.g = appearanceDefinition.getColor().getY();
        gdxColor.b = appearanceDefinition.getColor().getZ();
        gdxColor.a = 1.0f - (float)appearanceDefinition.getTransparency();
    }

    public static void setOpacity(ModelInstance modelInstance, float opacity) {
        for (Material material : modelInstance.materials) {
            LibGDXTools.setOpacity(material, opacity);
        }
    }

    public static void setOpacity(Model model, float opacity) {
        for (Material material : model.materials) {
            LibGDXTools.setOpacity(material, opacity);
        }
    }

    public static void setOpacity(Material material, float opacity) {
        if (opacity < 1.0f) {
            material.set((Attribute)new BlendingAttribute(true, opacity));
        } else {
            material.remove(BlendingAttribute.Type);
        }
    }

    public static void setDiffuseColor(ModelInstance modelInstance, com.badlogic.gdx.graphics.Color color) {
        for (Material material : modelInstance.materials) {
            material.set((Attribute)ColorAttribute.createDiffuse((com.badlogic.gdx.graphics.Color)color));
        }
    }

    public static long countVertices(ModelInstance modelInstance) {
        return LibGDXTools.countVertices(modelInstance.model);
    }

    public static long countVertices(Model model) {
        long numberOfVertices = 0L;
        for (int i = 0; i < model.meshes.size; ++i) {
            numberOfVertices += (long)((Mesh)model.meshes.get(i)).getNumVertices();
        }
        return numberOfVertices;
    }

    public static long countVertices(ModelData modelData) {
        long numberOfVertices = 0L;
        for (int i = 0; i < modelData.meshes.size; ++i) {
            ModelMesh modelMesh = (ModelMesh)modelData.meshes.get(i);
            long floatsPerVertex = LibGDXTools.calculateFloatsPerVertex(modelMesh);
            numberOfVertices += (long)modelMesh.vertices.length / floatsPerVertex;
        }
        return numberOfVertices;
    }

    public static int calculateFloatsPerVertex(ModelMesh modelMesh) {
        int vertexSize = 0;
        for (int j = 0; j < modelMesh.attributes.length; ++j) {
            VertexAttribute attribute = modelMesh.attributes[j];
            vertexSize += attribute.getSizeInBytes();
        }
        return vertexSize / 4;
    }

    public static ModelMeshPart findModelMeshPart(ModelData modelData, String meshPartId) {
        for (ModelMesh mesh : modelData.meshes) {
            for (ModelMeshPart part : mesh.parts) {
                if (!part.id.equals(meshPartId)) continue;
                return part;
            }
        }
        return null;
    }

    public static ModelMesh findMeshContainingPart(ModelData modelData, String meshPartId) {
        for (ModelMesh mesh : modelData.meshes) {
            for (ModelMeshPart part : mesh.parts) {
                if (!part.id.equals(meshPartId)) continue;
                return mesh;
            }
        }
        return null;
    }

    public static void setFloatVertexPosition(float[] vertices, int floatsPerVertex, int vertexIndex, Tuple3DReadOnly position) {
        vertices[floatsPerVertex * vertexIndex] = position.getX32();
        vertices[floatsPerVertex * vertexIndex + 1] = position.getY32();
        vertices[floatsPerVertex * vertexIndex + 2] = position.getZ32();
    }

    public static void printShaderLog(String shaderPath, ShaderProgram shaderProgram) {
        for (String line : shaderProgram.getLog().split("\n")) {
            if (line.isEmpty()) continue;
            if (line.contains("error")) {
                LogTools.error((String)line);
                continue;
            }
            LogTools.info((String)line);
        }
    }

    public static void printGLVersion() {
        String glfwVersionString = GLFW.glfwGetVersionString();
        LogTools.info((String)"Using GLFW {}", (Object)glfwVersionString);
        String openGLVersion = GL41.glGetString((int)7938);
        String openGLVendor = GL41.glGetString((int)7936);
        String openGLRenderer = GL41.glGetString((int)7937);
        LogTools.info((String)"Using OpenGL {} {} {}", (Object)openGLVersion, (Object)openGLRenderer, (Object)openGLVendor);
    }

    public static GLProfiler createGLProfiler() {
        GLProfiler glProfiler = new GLProfiler(Gdx.graphics);
        glProfiler.enable();
        glProfiler.setListener(error -> {
            int checkIndex = 0;
            int ihmcIndex = 0;
            String glMethodName = null;
            try {
                StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                for (int i = 0; i < stack.length; ++i) {
                    if (stack[i].getMethodName().equals("check") && i + 1 < stack.length) {
                        StackTraceElement glMethod = stack[i + 1];
                        glMethodName = glMethod.getMethodName();
                        checkIndex = i + 1;
                    }
                    if (glMethodName == null || !stack[i].getClassName().contains("us.ihmc.")) continue;
                    ihmcIndex = i;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (glMethodName != null) {
                LogTools.error((int)ihmcIndex, (Object)("GLProfiler: Error " + GLInterceptor.resolveErrorNumber((int)error) + " from " + glMethodName));
            } else {
                LogTools.error((int)ihmcIndex, (Object)("GLProfiler: Error " + GLInterceptor.resolveErrorNumber((int)error) + " at: " + new Exception()));
            }
            new Throwable().printStackTrace();
        });
        return glProfiler;
    }

    public static Callback setupDebugMessageCallback(int minimumDebugLevel) {
        LogTools.info((String)"Using KHR_debug for OpenGL debugging");
        GLDebugMessageCallback callback = GLDebugMessageCallback.create((source, type, id, severity, length, message, userParam) -> {
            if (LibGDXTools.getDebugSeverityLevel(severity) >= LibGDXTools.getDebugSeverityLevel(minimumDebugLevel)) {
                String messageString = "[" + LibGDXTools.getDebugSeverity(severity) + "] ID: " + String.format("0x%X", id) + " Source: " + LibGDXTools.getDebugSource(source) + " Type: " + LibGDXTools.getDebugType(type) + " " + GLDebugMessageCallback.getMessage((int)length, (long)message);
                switch (severity) {
                    case 37190: {
                        LogTools.fatal((String)messageString);
                        break;
                    }
                    case 37191: {
                        LogTools.error((String)messageString);
                        break;
                    }
                    case 37192: {
                        LogTools.warn((String)messageString);
                        break;
                    }
                    default: {
                        LogTools.info((String)messageString);
                    }
                }
            }
        });
        KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)callback, (long)0L);
        GL41.glEnable((int)37600);
        return callback;
    }

    private static int getDebugSeverityLevel(int severity) {
        switch (severity) {
            case 37190: {
                return 5;
            }
            case 37191: {
                return 4;
            }
            case 37192: {
                return 3;
            }
        }
        return 2;
    }

    private static String getDebugSeverity(int severity) {
        switch (severity) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
            case 33387: {
                return "NOTIFICATION";
            }
        }
        return APIUtil.apiUnknownToken((int)severity);
    }

    private static String getDebugSource(int source) {
        switch (source) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken((int)source);
    }

    private static String getDebugType(int type) {
        switch (type) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
            case 33384: {
                return "MARKER";
            }
        }
        return APIUtil.apiUnknownToken((int)type);
    }

    public static Pair<String, String> loadCombinedShader(String pathForLoadingFromClasspath) {
        String combinedString = Gdx.files.classpath(pathForLoadingFromClasspath).readString();
        combinedString = combinedString.replaceAll("\\r\\n", "\n");
        String vertexMacro = "#type vertex\n";
        int vertexBegin = combinedString.indexOf(vertexMacro);
        String fragmentMacro = "#type fragment\n";
        int fragmentBegin = combinedString.indexOf(fragmentMacro);
        String vertexShader = combinedString.substring(vertexBegin + vertexMacro.length() - 1, fragmentBegin).trim();
        String fragmentShader = combinedString.substring(fragmentBegin + fragmentMacro.length() - 1).trim();
        return Pair.of((Object)vertexShader, (Object)fragmentShader);
    }
}

